/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mq.itests;

import java.io.File;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.karaf.tooling.exam.options.KarafDistributionOption;
import org.apache.karaf.tooling.exam.options.LogLevelOption;
import org.fusesource.mq.itests.MQTestSupport;
import org.fusesource.tooling.testing.pax.exam.karaf.ServiceLocator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.spi.reactors.AllConfinedStagedReactorFactory;

@RunWith(value=JUnit4TestRunner.class)
@ExamReactorStrategy(value={AllConfinedStagedReactorFactory.class})
public class MQDistroTest
extends MQTestSupport {
    static final String JOLOKIA_URL = "http://localhost:8181/hawtio/jolokia/";
    static final String BROKER_MBEAN = "org.apache.activemq:type=Broker,brokerName=amq";
    public static final String USER_NAME_ND_PASSWORD = "admin";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebConsoleAndClient() throws Exception {
        HttpClient client = new HttpClient();
        client.getParams().setAuthenticationPreemptive(true);
        client.getState().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(USER_NAME_ND_PASSWORD, USER_NAME_ND_PASSWORD));
        GetMethod get = new GetMethod("http://localhost:8181/hawtio/jolokia/exec/org.apache.activemq:type=Broker,brokerName=amq/addQueue/FOO");
        get.setDoAuthentication(true);
        client.executeMethod((HttpMethod)get);
        Assert.assertEquals((String)"destination created", (long)200L, (long)get.getStatusCode());
        get = new GetMethod("http://localhost:8181/hawtio/jolokia/exec/org.apache.activemq:type=Broker,brokerName=amq,destinationType=Queue,destinationName=FOO/sendTextMessage(java.lang.String,java.lang.String,java.lang.String)/Hello/admin/admin");
        client.executeMethod((HttpMethod)get);
        Assert.assertEquals((String)"message sent", (long)200L, (long)get.getStatusCode());
        ActiveMQConnection connection = (ActiveMQConnection)new ActiveMQConnectionFactory().createConnection(USER_NAME_ND_PASSWORD, USER_NAME_ND_PASSWORD);
        connection.start();
        try {
            Session session = connection.createSession(false, 1);
            TextMessage textMessage = (TextMessage)session.createConsumer((Destination)new ActiveMQQueue("FOO")).receive(10000L);
            Assert.assertNotNull((String)"got a message", (Object)textMessage);
            Assert.assertEquals((String)"it is ours", (Object)"Hello", (Object)textMessage.getText());
        }
        finally {
            connection.close();
        }
        ConnectionFactory connectionFactory = (ConnectionFactory)ServiceLocator.getOsgiService(ConnectionFactory.class);
        Assert.assertTrue((boolean)(connectionFactory instanceof ActiveMQConnectionFactory));
        ActiveMQConnection connectionFromOsgiFactory = (ActiveMQConnection)connectionFactory.createConnection(USER_NAME_ND_PASSWORD, USER_NAME_ND_PASSWORD);
        connectionFromOsgiFactory.start();
        try {
            Assert.assertEquals((String)"same broker", (Object)connection.getBrokerName(), (Object)connectionFromOsgiFactory.getBrokerName());
        }
        finally {
            connectionFromOsgiFactory.close();
        }
        Process process = Runtime.getRuntime().exec("java -jar extras" + File.separator + "mq-client.jar producer --count 1 --user " + USER_NAME_ND_PASSWORD + " --password " + USER_NAME_ND_PASSWORD, null, new File(System.getProperty("user.dir")));
        process.waitFor();
        Assert.assertEquals((String)"producer worked, exit(0)?", (long)0L, (long)process.exitValue());
        process = Runtime.getRuntime().exec("java -jar extras" + File.separator + "mq-client.jar consumer --count 1 --user " + USER_NAME_ND_PASSWORD + " --password " + USER_NAME_ND_PASSWORD, null, new File(System.getProperty("user.dir")));
        process.waitFor();
        Assert.assertEquals((String)"consumer worked, exit(0)?", (long)0L, (long)process.exitValue());
        System.out.println(this.executeCommand("activemq:bstat"));
    }

    @Configuration
    public Option[] config() {
        return new Option[]{new DefaultCompositeOption(this.mqDistributionConfiguration()), KarafDistributionOption.keepRuntimeFolder(), MQDistroTest.mavenBundle((String)"commons-httpclient", (String)"commons-httpclient").versionAsInProject().type("jar"), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.INFO)};
    }
}

