/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.server.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DOMUtils {
    private static Logger log = LoggerFactory.getLogger(DOMUtils.class);
    private static ThreadLocal<Document> documentThreadLocal = new ThreadLocal();
    private static ThreadLocal<DocumentBuilder> builderThreadLocal = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                this.setEntityResolver(builder);
                return builder;
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("Failed to create DocumentBuilder", e);
            }
        }

        private void setEntityResolver(DocumentBuilder builder) {
            String[] resolvers = new String[]{"org.jboss.ws.core.utils.JBossWSEntityResolver", "org.jboss.util.xml.JBossEntityResolver"};
            EntityResolver entityResolver = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            for (String resolver : resolvers) {
                try {
                    Class<?> resolverClass = loader.loadClass(resolver);
                    entityResolver = (EntityResolver)resolverClass.newInstance();
                }
                catch (Exception ex) {
                    log.debug("Cannot load: " + resolver);
                }
            }
            if (entityResolver != null) {
                builder.setEntityResolver(entityResolver);
            }
        }
    };

    public static void clearThreadLocals() {
        documentThreadLocal.remove();
        builderThreadLocal.remove();
    }

    private DOMUtils() {
    }

    public static DocumentBuilder getDocumentBuilder() {
        return builderThreadLocal.get();
    }

    public static Element parse(String xmlString) throws IOException {
        try {
            return DOMUtils.parse(new ByteArrayInputStream(xmlString.getBytes("UTF-8")));
        }
        catch (IOException e) {
            log.error("Cannot parse: " + xmlString);
            throw e;
        }
    }

    public static Element parse(InputStream xmlStream) throws IOException {
        try {
            Element element = DOMUtils.getDocumentBuilder().parse(xmlStream).getDocumentElement();
            return element;
        }
        catch (SAXException se) {
            throw new IOException(se.toString());
        }
        finally {
            xmlStream.close();
        }
    }

    public static Element parse(InputSource source) throws IOException {
        try {
            Element element = DOMUtils.getDocumentBuilder().parse(source).getDocumentElement();
            return element;
        }
        catch (SAXException se) {
            throw new IOException(se.toString());
        }
        finally {
            Reader r;
            InputStream is = source.getByteStream();
            if (is != null) {
                is.close();
            }
            if ((r = source.getCharacterStream()) != null) {
                r.close();
            }
        }
    }

    public static Element createElement(String localPart) {
        Document doc = DOMUtils.getOwnerDocument();
        log.trace("createElement {}" + localPart);
        return doc.createElement(localPart);
    }

    public static Element createElement(String localPart, String prefix) {
        Document doc = DOMUtils.getOwnerDocument();
        log.trace("createElement {}" + prefix + ":" + localPart);
        return doc.createElement(prefix + ":" + localPart);
    }

    public static Element createElement(String localPart, String prefix, String uri) {
        Document doc = DOMUtils.getOwnerDocument();
        if (prefix == null || prefix.length() == 0) {
            log.trace("createElement {" + uri + "}" + localPart);
            return doc.createElementNS(uri, localPart);
        }
        log.trace("createElement {" + uri + "}" + prefix + ":" + localPart);
        return doc.createElementNS(uri, prefix + ":" + localPart);
    }

    public static Element createElement(QName qname) {
        return DOMUtils.createElement(qname.getLocalPart(), qname.getPrefix(), qname.getNamespaceURI());
    }

    public static Text createTextNode(String value) {
        Document doc = DOMUtils.getOwnerDocument();
        return doc.createTextNode(value);
    }

    public static QName getElementQName(Element el) {
        String qualifiedName = el.getNodeName();
        return DOMUtils.resolveQName(el, qualifiedName);
    }

    public static QName resolveQName(Element el, String qualifiedName) {
        String prefix = "";
        String namespaceURI = "";
        String localPart = qualifiedName;
        int colIndex = qualifiedName.indexOf(":");
        if (colIndex > 0) {
            prefix = qualifiedName.substring(0, colIndex);
            localPart = qualifiedName.substring(colIndex + 1);
            if ("xmlns".equals(prefix)) {
                namespaceURI = "URI:XML_PREDEFINED_NAMESPACE";
            } else {
                Element nsElement = el;
                while (namespaceURI.equals("") && nsElement != null) {
                    namespaceURI = nsElement.getAttribute("xmlns:" + prefix);
                    if (!namespaceURI.equals("")) continue;
                    nsElement = DOMUtils.getParentElement(nsElement);
                }
            }
            if (namespaceURI.equals("")) {
                throw new IllegalArgumentException("Cannot find namespace uri for: " + qualifiedName);
            }
        } else {
            Element nsElement = el;
            while (namespaceURI.equals("") && nsElement != null) {
                namespaceURI = nsElement.getAttribute("xmlns");
                if (!namespaceURI.equals("")) continue;
                nsElement = DOMUtils.getParentElement(nsElement);
            }
        }
        QName qname = new QName(namespaceURI, localPart, prefix);
        return qname;
    }

    public static String getAttributeValue(Element el, String attrName) {
        return DOMUtils.getAttributeValue(el, new QName(attrName));
    }

    public static String getAttributeValue(Element el, QName attrName) {
        String attr = null;
        attr = "".equals(attrName.getNamespaceURI()) ? el.getAttribute(attrName.getLocalPart()) : el.getAttributeNS(attrName.getNamespaceURI(), attrName.getLocalPart());
        if ("".equals(attr)) {
            attr = null;
        }
        return attr;
    }

    public static QName getAttributeValueAsQName(Element el, String attrName) {
        return DOMUtils.getAttributeValueAsQName(el, new QName(attrName));
    }

    public static QName getAttributeValueAsQName(Element el, QName attrName) {
        QName qname = null;
        String qualifiedName = DOMUtils.getAttributeValue(el, attrName);
        if (qualifiedName != null) {
            qname = DOMUtils.resolveQName(el, qualifiedName);
        }
        return qname;
    }

    public static boolean getAttributeValueAsBoolean(Element el, String attrName) {
        return DOMUtils.getAttributeValueAsBoolean(el, new QName(attrName));
    }

    public static boolean getAttributeValueAsBoolean(Element el, QName attrName) {
        String attrVal = DOMUtils.getAttributeValue(el, attrName);
        boolean ret = "true".equalsIgnoreCase(attrVal) || "1".equalsIgnoreCase(attrVal);
        return ret;
    }

    public static Integer getAttributeValueAsInteger(Element el, String attrName) {
        return DOMUtils.getAttributeValueAsInteger(el, new QName(attrName));
    }

    public static Integer getAttributeValueAsInteger(Element el, QName attrName) {
        String attrVal = DOMUtils.getAttributeValue(el, attrName);
        return attrVal != null ? new Integer(attrVal) : null;
    }

    public static Map getAttributes(Element el) {
        HashMap<QName, String> attmap = new HashMap<QName, String>();
        NamedNodeMap attribs = el.getAttributes();
        for (int i = 0; i < attribs.getLength(); ++i) {
            Attr attr = (Attr)attribs.item(i);
            String name = attr.getName();
            QName qname = DOMUtils.resolveQName(el, name);
            String value = attr.getNodeValue();
            attmap.put(qname, value);
        }
        return attmap;
    }

    public static void copyAttributes(Element destElement, Element srcElement) {
        NamedNodeMap attribs = srcElement.getAttributes();
        for (int i = 0; i < attribs.getLength(); ++i) {
            Attr attr = (Attr)attribs.item(i);
            String uri = attr.getNamespaceURI();
            String qname = attr.getName();
            String value = attr.getNodeValue();
            if (uri == null && qname.startsWith("xmlns")) {
                log.trace("Ignore attribute: [uri=" + uri + ",qname=" + qname + ",value=" + value + "]");
                continue;
            }
            destElement.setAttributeNS(uri, qname, value);
        }
    }

    public static boolean hasTextChildNodesOnly(Node node) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() == 0) {
            return false;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node acksToChildNode = nodeList.item(i);
            if (acksToChildNode.getNodeType() == 3) continue;
            return false;
        }
        return true;
    }

    public static boolean hasChildElements(Node node) {
        NodeList nlist = node.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node child = nlist.item(i);
            if (child.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    public static Iterator<Element> getChildElements(Node node) {
        LinkedList<Element> list = new LinkedList<Element>();
        NodeList nlist = node.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node child = nlist.item(i);
            if (child.getNodeType() != 1) continue;
            list.add((Element)child);
        }
        return list.iterator();
    }

    public static String getTextContent(Node node) {
        boolean hasTextContent = false;
        StringBuffer buffer = new StringBuffer();
        NodeList nlist = node.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node child = nlist.item(i);
            if (child.getNodeType() != 3) continue;
            buffer.append(child.getNodeValue());
            hasTextContent = true;
        }
        return hasTextContent ? buffer.toString() : null;
    }

    public static Element getFirstChildElement(Node node) {
        return DOMUtils.getFirstChildElement(node, false);
    }

    public static Element getFirstChildElement(Node node, boolean recursive) {
        return DOMUtils.getFirstChildElementIntern(node, null, recursive);
    }

    public static Element getFirstChildElement(Node node, String nodeName) {
        return DOMUtils.getFirstChildElement(node, nodeName, false);
    }

    public static Element getFirstChildElement(Node node, String nodeName, boolean recursive) {
        return DOMUtils.getFirstChildElementIntern(node, new QName(nodeName), recursive);
    }

    public static Element getFirstChildElement(Node node, QName nodeName) {
        return DOMUtils.getFirstChildElement(node, nodeName, false);
    }

    public static Element getFirstChildElement(Node node, QName nodeName, boolean recursive) {
        return DOMUtils.getFirstChildElementIntern(node, nodeName, recursive);
    }

    private static Element getFirstChildElementIntern(Node node, QName nodeName, boolean recursive) {
        Element childElement = null;
        Iterator it = DOMUtils.getChildElementsIntern(node, nodeName, recursive);
        if (it.hasNext()) {
            childElement = (Element)it.next();
        }
        return childElement;
    }

    public static Iterator getChildElements(Node node, String nodeName) {
        return DOMUtils.getChildElements(node, nodeName, false);
    }

    public static Iterator getChildElements(Node node, String nodeName, boolean recursive) {
        return DOMUtils.getChildElementsIntern(node, new QName(nodeName), recursive);
    }

    public static Iterator getChildElements(Node node, QName nodeName) {
        return DOMUtils.getChildElements(node, nodeName, false);
    }

    public static Iterator getChildElements(Node node, QName nodeName, boolean recursive) {
        return DOMUtils.getChildElementsIntern(node, nodeName, recursive);
    }

    public static List<Element> getChildElementsAsList(Node node, String nodeName) {
        return DOMUtils.getChildElementsAsList(node, nodeName, false);
    }

    public static List<Element> getChildElementsAsList(Node node, String nodeName, boolean recursive) {
        return DOMUtils.getChildElementsAsListIntern(node, new QName(nodeName), recursive);
    }

    public static List<Element> getChildElementsAsList(Node node, QName nodeName) {
        return DOMUtils.getChildElementsAsList(node, nodeName, false);
    }

    public static List<Element> getChildElementsAsList(Node node, QName nodeName, boolean recursive) {
        return DOMUtils.getChildElementsAsListIntern(node, nodeName, recursive);
    }

    private static List<Element> getChildElementsAsListIntern(Node node, QName nodeName, boolean recursive) {
        LinkedList<Element> list = new LinkedList<Element>();
        NodeList nlist = node.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node child = nlist.item(i);
            if (child.getNodeType() != 1) continue;
            DOMUtils.search(list, (Element)child, nodeName, recursive);
        }
        return list;
    }

    private static void search(List<Element> list, Element baseElement, QName nodeName, boolean recursive) {
        if (nodeName == null) {
            list.add(baseElement);
        } else {
            QName qname = nodeName.getNamespaceURI().length() > 0 ? new QName(baseElement.getNamespaceURI(), baseElement.getLocalName()) : new QName(baseElement.getLocalName());
            if (qname.equals(nodeName)) {
                list.add(baseElement);
            }
        }
        if (recursive) {
            NodeList nlist = baseElement.getChildNodes();
            for (int i = 0; i < nlist.getLength(); ++i) {
                Node child = nlist.item(i);
                if (child.getNodeType() != 1) continue;
                DOMUtils.search(list, (Element)child, nodeName, recursive);
            }
        }
    }

    private static Iterator getChildElementsIntern(Node node, QName nodeName, boolean recursive) {
        return DOMUtils.getChildElementsAsListIntern(node, nodeName, recursive).iterator();
    }

    public static Element getParentElement(Node node) {
        Node parent = node.getParentNode();
        return parent instanceof Element ? (Element)parent : null;
    }

    public static Document getOwnerDocument() {
        Document doc = documentThreadLocal.get();
        if (doc == null) {
            doc = DOMUtils.getDocumentBuilder().newDocument();
            documentThreadLocal.set(doc);
        }
        return doc;
    }

    public static Element sourceToElement(Source source) throws IOException {
        Element retElement;
        block9: {
            retElement = null;
            try {
                if (source instanceof StreamSource) {
                    StreamSource streamSource = (StreamSource)source;
                    InputStream ins = streamSource.getInputStream();
                    if (ins != null) {
                        retElement = DOMUtils.parse(ins);
                    } else {
                        Reader reader = streamSource.getReader();
                        retElement = DOMUtils.parse(new InputSource(reader));
                    }
                    break block9;
                }
                if (source instanceof DOMSource) {
                    DOMSource domSource = (DOMSource)source;
                    Node node = domSource.getNode();
                    if (node instanceof Element) {
                        retElement = (Element)node;
                        break block9;
                    }
                    if (node instanceof Document) {
                        retElement = ((Document)node).getDocumentElement();
                        break block9;
                    }
                    throw new RuntimeException("Unsupported Node type: " + node.getClass().getName());
                }
                if (source instanceof SAXSource) {
                    TransformerFactory tf = TransformerFactory.newInstance();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                    Transformer transformer = tf.newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.setOutputProperty("method", "xml");
                    transformer.transform(source, new StreamResult(baos));
                    retElement = DOMUtils.parse(new ByteArrayInputStream(baos.toByteArray()));
                    break block9;
                }
                throw new RuntimeException("Source type not implemented: " + source.getClass().getName());
            }
            catch (TransformerException ex) {
                IOException ioex = new IOException();
                ioex.initCause(ex);
                throw ioex;
            }
        }
        return retElement;
    }
}

