/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.server;

import com.google.gson.Gson;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.bpm.console.client.model.DeploymentRefWrapper;
import org.jboss.bpm.console.client.model.JobRefWrapper;
import org.jboss.bpm.console.server.gson.GsonFactory;
import org.jboss.bpm.console.server.plugin.PluginMgr;
import org.jboss.bpm.console.server.plugin.ProcessEnginePlugin;
import org.jboss.bpm.console.server.util.ProjectName;
import org.jboss.bpm.console.server.util.RsComment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="engine")
@RsComment(title="Process Engine", description="Process runtime state")
public class EngineFacade {
    private static final Logger log = LoggerFactory.getLogger(EngineFacade.class);
    private ProcessEnginePlugin processEnginePlugin;

    private ProcessEnginePlugin getDeploymentPlugin() {
        if (null == this.processEnginePlugin) {
            this.processEnginePlugin = (ProcessEnginePlugin)PluginMgr.load(ProcessEnginePlugin.class);
        }
        return this.processEnginePlugin;
    }

    @GET
    @Path(value="deployments")
    @Produces(value={"application/json"})
    public Response getDeployments() {
        ProcessEnginePlugin dplPlugin = this.getDeploymentPlugin();
        if (this.processEnginePlugin != null) {
            List dpls = dplPlugin.getDeployments();
            return this.createJsonResponse((Object)new DeploymentRefWrapper(dpls));
        }
        log.error("ProcessEnginePlugin not available");
        return Response.serverError().build();
    }

    @POST
    @Path(value="deployment/{id}/suspend")
    @Produces(value={"application/json"})
    @RsComment(project={ProjectName.JBPM})
    public Response suspendDeployment(@PathParam(value="id") String id) {
        return this.doSuspend(id, true);
    }

    @POST
    @Path(value="deployment/{id}/resume")
    @Produces(value={"application/json"})
    @RsComment(project={ProjectName.JBPM})
    public Response resumeDeployment(@PathParam(value="id") String id) {
        return this.doSuspend(id, false);
    }

    private Response doSuspend(String id, boolean suspended) {
        ProcessEnginePlugin dplPlugin = this.getDeploymentPlugin();
        if (this.processEnginePlugin != null) {
            this.processEnginePlugin.suspendDeployment(id, suspended);
            return Response.ok().build();
        }
        log.error("ProcessEnginePlugin not available");
        return Response.serverError().build();
    }

    @POST
    @Path(value="deployment/{id}/delete")
    @Produces(value={"application/json"})
    @RsComment(project={ProjectName.JBPM})
    public Response deleteDeployment(@PathParam(value="id") String id) {
        ProcessEnginePlugin dplPlugin = this.getDeploymentPlugin();
        if (this.processEnginePlugin != null) {
            this.processEnginePlugin.deleteDeployment(id);
            return Response.ok().build();
        }
        log.error("ProcessEnginePlugin not available");
        return Response.serverError().build();
    }

    @GET
    @Path(value="jobs")
    @Produces(value={"application/json"})
    @RsComment(project={ProjectName.JBPM})
    public Response getJobs() {
        ProcessEnginePlugin dplPlugin = this.getDeploymentPlugin();
        if (this.processEnginePlugin != null) {
            List jobs = dplPlugin.getJobs();
            return this.createJsonResponse((Object)new JobRefWrapper(jobs));
        }
        log.error("ProcessEnginePlugin not available");
        return Response.serverError().build();
    }

    @POST
    @Path(value="job/{id}/execute")
    @Produces(value={"application/json"})
    @RsComment(project={ProjectName.JBPM})
    public Response executeJob(@PathParam(value="id") String id) {
        ProcessEnginePlugin dplPlugin = this.getDeploymentPlugin();
        if (this.processEnginePlugin != null) {
            dplPlugin.executeJob(id);
            return Response.ok().build();
        }
        log.error("ProcessEnginePlugin not available");
        return Response.serverError().build();
    }

    private Response createJsonResponse(Object wrapper) {
        Gson gson = GsonFactory.createInstance();
        String json = gson.toJson(wrapper);
        return Response.ok((Object)json).type("application/json").build();
    }
}

