/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.model;

import com.google.gwt.core.client.JsArray;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.jboss.bpm.console.client.model.HistoryActivityInstanceRef;
import org.jboss.bpm.console.client.model.HistoryProcessInstanceRef;
import org.jboss.bpm.console.client.model.JSOModel;
import org.jboss.bpm.console.client.model.PluginInfo;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.model.ServerStatus;
import org.jboss.bpm.console.client.model.StringRef;
import org.jboss.bpm.console.client.model.TokenReference;
import org.jboss.bpm.report.model.ReportParameter;
import org.jboss.bpm.report.model.ReportReference;

/*
 * Exception performing whole class analysis ignored.
 */
public class JSOParser {
    public static List<ProcessDefinitionRef> parseProcessDefinitions(String json) {
        ArrayList<ProcessDefinitionRef> results = new ArrayList<ProcessDefinitionRef>();
        JSOModel rootModel = JSOModel.fromJson((String)json);
        JsArray definitions = rootModel.getArray("definitions");
        for (int i = 0; i < definitions.length(); ++i) {
            JSOModel def = (JSOModel)definitions.get(i);
            results.add(JSOParser.parseProcessDefinition((JSOModel)def));
        }
        return results;
    }

    public static ProcessDefinitionRef parseProcessDefinition(JSOModel rootModel) {
        ProcessDefinitionRef def = new ProcessDefinitionRef();
        def.setId(rootModel.get("id"));
        def.setName(rootModel.get("name"));
        def.setVersion(rootModel.getLong("version"));
        def.setKey(rootModel.get("key"));
        def.setDeploymentId(rootModel.get("deploymentId"));
        def.setSuspended(rootModel.getBoolean("suspended"));
        def.setPackageName(rootModel.get("packageName", ""));
        def.setFormUrl(rootModel.get("formUrl", null));
        def.setDiagramUrl(rootModel.get("diagramUrl", null));
        return def;
    }

    public static List<ProcessInstanceRef> parseProcessInstances(String json) {
        System.out.println(json);
        ArrayList<ProcessInstanceRef> results = new ArrayList<ProcessInstanceRef>();
        JSOModel rootModel = JSOModel.fromJson((String)json);
        JsArray instances = rootModel.getArray("instances");
        for (int i = 0; i < instances.length(); ++i) {
            results.add(JSOParser.parseProcessInstance((JSOModel)((JSOModel)instances.get(i))));
        }
        return results;
    }

    public static ProcessInstanceRef parseProcessInstance(JSOModel root) {
        String id = root.get("id");
        String definitionId = root.get("definitionId");
        Date start = root.getDate("startDate");
        Date end = root.getDate("endDate", null);
        boolean suspended = root.getBoolean("suspended");
        ProcessInstanceRef processInstance = new ProcessInstanceRef(id, definitionId, start, end, suspended);
        JSOModel rootTokenJson = root.getObject("rootToken");
        if (rootTokenJson != null) {
            TokenReference rootToken = JSOParser.parseTokenReference((JSOModel)rootTokenJson);
            processInstance.setRootToken(rootToken);
        }
        return processInstance;
    }

    private static TokenReference parseTokenReference(JSOModel rootToken) {
        JsArray tokenSignalsJson;
        JsArray tokenChildrenJson;
        TokenReference tokenReference = new TokenReference();
        tokenReference.setId(rootToken.get("id"));
        tokenReference.setCurrentNodeName(rootToken.get("currentNodeName"));
        tokenReference.setCanBeSignaled(rootToken.getBoolean("canBeSignaled"));
        if (rootToken.hasKey("name")) {
            tokenReference.setName(rootToken.get("name"));
        }
        if ((tokenChildrenJson = rootToken.getArray("children")) != null) {
            ArrayList<TokenReference> children = new ArrayList<TokenReference>();
            for (int i = 0; i < tokenChildrenJson.length(); ++i) {
                children.add(JSOParser.parseTokenReference((JSOModel)((JSOModel)tokenChildrenJson.get(i))));
            }
            tokenReference.setChildren(children);
        }
        if ((tokenSignalsJson = rootToken.getArray("availableSignals")) != null) {
            ArrayList<String> availableSignals = new ArrayList<String>();
            for (int i = 0; i < tokenSignalsJson.length(); ++i) {
                availableSignals.add(((JSOModel)tokenSignalsJson.get(i)).toString());
            }
            tokenReference.setAvailableSignals(availableSignals);
        }
        return tokenReference;
    }

    public static List<ReportReference> parseReportConfig(String json) {
        ArrayList<ReportReference> results = new ArrayList<ReportReference>();
        JsArray rootModel = JSOModel.arrayFromJson((String)json);
        for (int i = 0; i < rootModel.length(); ++i) {
            JSOModel reportCfg = (JSOModel)rootModel.get(i);
            String title = reportCfg.get("title");
            String description = reportCfg.get("description", "");
            String reportFile = reportCfg.get("reportFileName");
            ReportReference reportRef = new ReportReference(reportFile);
            reportRef.setTitle(title);
            reportRef.setDescription(description);
            JsArray params = reportCfg.getArray("parameterMetaData");
            for (int x = 0; x < params.length(); ++x) {
                JSOModel p = (JSOModel)params.get(x);
                String name = p.get("name");
                String type = p.get("type");
                String dataType = p.get("dataType");
                ReportParameter pmd = new ReportParameter(name, ReportParameter.Type.valueOf((String)type));
                pmd.setDataType(ReportParameter.DataType.valueOf((String)dataType));
                pmd.setHelptext(p.get("helptext", ""));
                pmd.setPromptText(p.get("promptText", ""));
                reportRef.getParameterMetaData().add(pmd);
            }
            results.add(reportRef);
        }
        return results;
    }

    public static ServerStatus parseStatus(String json) {
        ServerStatus status = new ServerStatus();
        JSOModel rootModel = JSOModel.fromJson((String)json);
        JsArray plugins = rootModel.getArray("plugins");
        for (int i = 0; i < plugins.length(); ++i) {
            JSOModel item = (JSOModel)plugins.get(i);
            String type = item.get("type");
            boolean avail = item.getBoolean("available");
            status.getPlugins().add(new PluginInfo(type, avail));
        }
        return status;
    }

    public static List<StringRef> parseStringRef(String json) {
        LinkedList<StringRef> refs = new LinkedList<StringRef>();
        JSOModel rootModel = JSOModel.fromJson((String)json);
        JsArray values = rootModel.getArray("values");
        for (int i = 0; i < values.length(); ++i) {
            JSOModel entry = (JSOModel)values.get(i);
            StringRef ref = new StringRef(entry.get("value"));
            refs.add(ref);
        }
        return refs;
    }

    public static List<HistoryActivityInstanceRef> parseProcessInstanceHistory(String json) {
        ArrayList<HistoryActivityInstanceRef> results = new ArrayList<HistoryActivityInstanceRef>();
        JSOModel rootModel = JSOModel.fromJson((String)json);
        JsArray historyEntires = rootModel.getArray("historyEntires");
        for (int i = 0; i < historyEntires.length(); ++i) {
            JSOModel entry = (JSOModel)historyEntires.get(i);
            results.add(JSOParser.parseProcessInstanceHistory((JSOModel)entry));
        }
        return results;
    }

    public static HistoryActivityInstanceRef parseProcessInstanceHistory(JSOModel rootModel) {
        HistoryActivityInstanceRef def = new HistoryActivityInstanceRef();
        def.setActivityName(rootModel.get("activityName"));
        def.setStartTime(rootModel.getDate("startTime"));
        def.setEndTime(rootModel.getDate("endTime"));
        def.setExecutionId(rootModel.get("executionId"));
        def.setDuration(rootModel.getLong("duration"));
        return def;
    }

    public static List<HistoryProcessInstanceRef> parseProcessDefinitionHistory(String json) {
        ArrayList<HistoryProcessInstanceRef> results = new ArrayList<HistoryProcessInstanceRef>();
        JSOModel rootModel = JSOModel.fromJson((String)json);
        JsArray historyEntires = rootModel.getArray("historyEntires");
        for (int i = 0; i < historyEntires.length(); ++i) {
            JSOModel entry = (JSOModel)historyEntires.get(i);
            results.add(JSOParser.parseProcessDefinitionHistory((JSOModel)entry));
        }
        return results;
    }

    public static HistoryProcessInstanceRef parseProcessDefinitionHistory(JSOModel rootModel) {
        HistoryProcessInstanceRef def = new HistoryProcessInstanceRef();
        def.setProcessDefinitionId(rootModel.get("processDefinitionId"));
        def.setProcessInstanceId(rootModel.get("processInstanceId"));
        def.setStartTime(rootModel.getDate("startTime"));
        def.setEndTime(rootModel.getDate("endTime"));
        def.setEndActivityName(rootModel.get("endActivityName"));
        def.setState(rootModel.get("state"));
        def.setKey(rootModel.get("key"));
        def.setDuration(rootModel.getLong("duration"));
        return def;
    }
}

