/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONValue;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.gwt.mosaic.ui.client.MessageBox;
import org.jboss.bpm.console.client.Authentication;
import org.jboss.bpm.console.client.BootstrapAction;
import org.jboss.bpm.console.client.ConsoleConfig;
import org.jboss.bpm.console.client.URLBuilder;
import org.jboss.bpm.console.client.util.ConsoleLog;
import org.jboss.bpm.console.client.util.JSONWalk;
import org.jboss.errai.workspaces.client.framework.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Authentication {
    private AuthCallback callback;
    private List<String> rolesAssigned = new ArrayList();
    private String sid;
    private String username;
    private String password;
    private ConsoleConfig config;
    private String rolesUrl;
    private Date loggedInSince;

    public Authentication(ConsoleConfig config, String sessionID, String rolesUrl) {
        this.config = config;
        this.sid = sessionID;
        this.rolesUrl = rolesUrl;
        this.loggedInSince = new Date();
    }

    public String getSid() {
        return this.sid;
    }

    public void login(String user, String pass) {
        this.username = user;
        this.password = pass;
        String formAction = this.config.getConsoleServerUrl() + "/rs/identity/secure/j_security_check";
        RequestBuilder rb = new RequestBuilder(RequestBuilder.POST, formAction);
        rb.setHeader("Content-Type", "application/x-www-form-urlencoded");
        try {
            rb.sendRequest("j_username=" + user + "&j_password=" + pass, (RequestCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (RequestException e) {
            ConsoleLog.error((String)"Request error", (Throwable)e);
        }
    }

    private void loadBootstrapAction() {
        ((Controller)Registry.get(Controller.class)).handleEvent(new Event(BootstrapAction.ID, (Object)Boolean.TRUE));
    }

    public Date getLoggedInSince() {
        return this.loggedInSince;
    }

    private void checkBPELEngineAndRequestAssignedRoles() {
        RequestBuilder rb = new RequestBuilder(RequestBuilder.GET, URLBuilder.getInstance().getRiftSawServerStatusURL());
        try {
            rb.sendRequest(null, (RequestCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (RequestException e) {
            throw new RuntimeException("Unknown error upon login attempt", e);
        }
    }

    private void requestAssignedRoles() {
        RequestBuilder rb = new RequestBuilder(RequestBuilder.GET, this.rolesUrl);
        ConsoleLog.debug((String)("Request roles: " + rb.getUrl()));
        try {
            rb.sendRequest(null, (RequestCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (RequestException e1) {
            throw new RuntimeException("Unknown error upon login attempt", e1);
        }
    }

    public void setCallback(AuthCallback callback) {
        this.callback = callback;
    }

    private native void reload();

    public static void logout(ConsoleConfig conf) {
        RequestBuilder rb = new RequestBuilder(RequestBuilder.POST, conf.getConsoleServerUrl() + "/rs/identity/sid/invalidate");
        try {
            rb.sendRequest(null, (RequestCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (RequestException e) {
            ConsoleLog.error((String)"Request error", (Throwable)e);
        }
    }

    public void logoutAndReload() {
        RequestBuilder rb = new RequestBuilder(RequestBuilder.POST, this.config.getConsoleServerUrl() + "/rs/identity/sid/invalidate");
        try {
            rb.sendRequest(null, (RequestCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (RequestException e) {
            ConsoleLog.error((String)"Request error", (Throwable)e);
        }
    }

    private void resetState() {
        this.sid = null;
        this.username = null;
        this.password = null;
        this.rolesAssigned = new ArrayList();
        this.loggedInSince = null;
    }

    public void handleSessionTimeout() {
        MessageBox.confirm((String)"Session expired", (String)"Please login again", (MessageBox.ConfirmationCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<String> getRolesAssigned() {
        return this.rolesAssigned;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public static List<String> parseRolesAssigned(String json) {
        ArrayList<String> roles = new ArrayList<String>();
        JSONValue root = JSONParser.parse((String)json);
        JSONArray array = JSONWalk.on((JSONValue)root).next("roles").asArray();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject item = array.get(i).isObject();
            boolean assigned = JSONWalk.on((JSONValue)item).next("assigned").asBool();
            String roleName = JSONWalk.on((JSONValue)item).next("role").asString();
            if (!assigned) continue;
            roles.add(roleName);
        }
        return roles;
    }

    static /* synthetic */ AuthCallback access$000(Authentication x0) {
        return x0.callback;
    }

    static /* synthetic */ ConsoleConfig access$100(Authentication x0) {
        return x0.config;
    }

    static /* synthetic */ void access$200(Authentication x0) {
        x0.checkBPELEngineAndRequestAssignedRoles();
    }

    static /* synthetic */ void access$300(Authentication x0) {
        x0.requestAssignedRoles();
    }

    static /* synthetic */ void access$400(Authentication x0) {
        x0.loadBootstrapAction();
    }

    static /* synthetic */ List access$502(Authentication x0, List x1) {
        x0.rolesAssigned = x1;
        return x0.rolesAssigned;
    }

    static /* synthetic */ void access$600(Authentication x0) {
        x0.resetState();
    }

    static /* synthetic */ void access$700(Authentication x0) {
        x0.reload();
    }
}

