/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.rebind;

import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class WorkspaceGenerator
extends Generator {
    private String className = null;
    private String packageName = null;
    private String typeName = null;
    public static final String WORKSPACE_CONFIG_DEFAULT = "org/jboss/bpm/console/workspace-default.cfg";
    public static final String WORKSPACE_CONFIG = "org/jboss/bpm/console/workspace.cfg";

    public String generate(TreeLogger logger, GeneratorContext context, String typeName) throws UnableToCompleteException {
        this.typeName = typeName;
        TypeOracle typeOracle = context.getTypeOracle();
        try {
            JClassType classType = typeOracle.getType(typeName);
            this.packageName = classType.getPackage().getName();
            this.className = classType.getSimpleSourceName() + "Wrapper";
            this.generateClass(logger, context);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            logger.log(TreeLogger.ERROR, "Failed to generate workspace launcher", (Throwable)e);
        }
        return this.packageName + "." + this.className;
    }

    private void generateClass(TreeLogger logger, GeneratorContext context) {
        PrintWriter printWriter = null;
        printWriter = context.tryCreate(logger, this.packageName, this.className);
        if (printWriter == null) {
            return;
        }
        ClassSourceFileComposerFactory composerFactory = new ClassSourceFileComposerFactory(this.packageName, this.className);
        composerFactory.addImport("org.jboss.bpm.console.client.Workspace");
        composerFactory.addImport("org.jboss.bpm.console.client.WorkspaceLauncher");
        composerFactory.addImplementedInterface("org.jboss.bpm.console.client.WorkspaceLauncher");
        SourceWriter sourceWriter = composerFactory.createSourceWriter(context, printWriter);
        this.generateMethods(sourceWriter);
        sourceWriter.outdent();
        sourceWriter.println("}");
        context.commit(logger, printWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateMethods(SourceWriter sourceWriter) {
        sourceWriter.println("public void launch(Workspace workspace) { ");
        sourceWriter.indent();
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(WORKSPACE_CONFIG);
        if (null == in && null == (in = this.getClass().getClassLoader().getResourceAsStream(WORKSPACE_CONFIG_DEFAULT))) {
            throw new RuntimeException("Cannot find 'org/jboss/bpm/console/workspace.cfg' or 'org/jboss/bpm/console/workspace-default.cfg'");
        }
        try {
            BufferedReader input = new BufferedReader(new InputStreamReader(in));
            try {
                String line = null;
                while ((line = input.readLine()) != null) {
                    if (line.equals("") || line.startsWith("#")) continue;
                    sourceWriter.println("workspace.addEditor( new " + line + "(), false );");
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading 'org/jboss/bpm/console/workspace.cfg'");
        }
        sourceWriter.outdent();
        sourceWriter.println("}");
    }
}

