/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client;

import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.Controller;
import com.mvc4g.client.ViewInterface;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.GridLayout;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.MosaicPanel;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.LazyPanel;
import org.jboss.bpm.console.client.ServerPlugins;
import org.jboss.bpm.console.client.common.HeaderLabel;
import org.jboss.bpm.console.client.model.PluginInfo;
import org.jboss.bpm.console.client.model.ServerStatus;
import org.jboss.errai.workspaces.client.api.ProvisioningCallback;
import org.jboss.errai.workspaces.client.api.WidgetProvider;
import org.jboss.errai.workspaces.client.framework.Registry;

public class ServerStatusView
implements ViewInterface,
LazyPanel,
WidgetProvider {
    public static final String ID = ServerStatusView.class.getName();
    private Controller controller;
    private ApplicationContext appContext = (ApplicationContext)Registry.get(ApplicationContext.class);
    private boolean initialized;
    MosaicPanel layoutPanel;
    MosaicPanel pluginPanel;

    public ServerStatusView() {
        this.controller = (Controller)Registry.get(Controller.class);
    }

    public void provideWidget(ProvisioningCallback callback) {
        this.layoutPanel = new MosaicPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        HeaderLabel console = new HeaderLabel("Console Info");
        this.layoutPanel.add((Widget)console, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        MosaicPanel layout1 = new MosaicPanel((LayoutManager)new GridLayout(2, 1));
        layout1.add((Widget)new HTML("Version:"));
        layout1.add((Widget)new HTML("2.4.8.Final-redhat-4"));
        this.layoutPanel.add((Widget)layout1, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        HeaderLabel server = new HeaderLabel("Server Info");
        this.layoutPanel.add((Widget)server, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        MosaicPanel layout2 = new MosaicPanel((LayoutManager)new GridLayout(2, 2));
        layout2.add((Widget)new HTML("Host:"));
        layout2.add((Widget)new HTML(((ApplicationContext)Registry.get(ApplicationContext.class)).getConfig().getConsoleServerUrl()));
        this.pluginPanel = new MosaicPanel();
        layout2.add((Widget)new Label("Plugins:"));
        layout2.add((Widget)this.pluginPanel);
        this.layoutPanel.add((Widget)layout2, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        this.controller.addView(ID, (ViewInterface)this);
        this.update(ServerPlugins.getStatus());
        callback.onSuccess((Widget)this.layoutPanel);
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() {
        if (!this.initialized) {
            this.update(ServerPlugins.getStatus());
            this.initialized = true;
        }
    }

    private void update(ServerStatus status) {
        this.pluginPanel.clear();
        Grid g = new Grid(status.getPlugins().size(), 2);
        g.setWidth("100%");
        for (int row = 0; row < status.getPlugins().size(); ++row) {
            PluginInfo p = (PluginInfo)status.getPlugins().get(row);
            String type = p.getType().substring(p.getType().lastIndexOf(".") + 1, p.getType().length());
            g.setText(row, 0, type);
            Image img = p.isAvailable() ? new Image("images/icons/confirm_small.png") : new Image("images/icons/deny_small.png");
            g.setWidget(row, 1, (Widget)img);
        }
        this.pluginPanel.add((Widget)g);
        this.pluginPanel.layout();
    }
}

