/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.groups.internal;

import io.fabric8.groups.Group;
import io.fabric8.groups.GroupListener;
import io.fabric8.groups.NodeState;
import io.fabric8.groups.internal.ZooKeeperGroup;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.framework.CuratorFramework;

public class DelegateZooKeeperGroup<T extends NodeState>
implements Group<T> {
    private final String path;
    private final Class<T> clazz;
    private final List<GroupListener<T>> listeners;
    private Group<T> group;
    private T state;
    private AtomicBoolean started = new AtomicBoolean();

    public DelegateZooKeeperGroup(String path, Class<T> clazz) {
        this.listeners = new ArrayList<GroupListener<T>>();
        this.path = path;
        this.clazz = clazz;
    }

    public void useCurator(CuratorFramework curator) {
        Group<T> group = this.group;
        if (group != null) {
            DelegateZooKeeperGroup.closeQuietly(group);
        }
        if (curator != null) {
            group = new ZooKeeperGroup<T>(curator, this.path, this.clazz);
            group.update(this.state);
            for (GroupListener<T> listener : this.listeners) {
                group.add(listener);
            }
            if (this.started.get()) {
                group.start();
            }
            this.group = group;
        }
    }

    @Override
    public void add(GroupListener<T> listener) {
        this.listeners.add(listener);
        Group<T> group = this.group;
        if (group != null) {
            group.add(listener);
        }
    }

    @Override
    public void remove(GroupListener<T> listener) {
        this.listeners.remove(listener);
        Group<T> group = this.group;
        if (group != null) {
            group.remove(listener);
        }
    }

    @Override
    public boolean isConnected() {
        Group<T> group = this.group;
        if (group != null) {
            return group.isConnected();
        }
        return false;
    }

    @Override
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.doStart();
        }
    }

    protected void doStart() {
        if (this.group != null) {
            this.group.start();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.started.compareAndSet(true, false)) {
            this.doStop();
        }
    }

    protected void doStop() throws IOException {
        DelegateZooKeeperGroup.closeQuietly(this.group);
    }

    @Override
    public void update(T state) {
        this.state = state;
        Group<T> group = this.group;
        if (group != null) {
            group.update(state);
        }
    }

    @Override
    public Map<String, T> members() {
        Group<T> group = this.group;
        if (group != null) {
            return group.members();
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean isMaster() {
        Group<T> group = this.group;
        if (group != null) {
            return group.isMaster();
        }
        return false;
    }

    @Override
    public T master() {
        Group<T> group = this.group;
        if (group != null) {
            return group.master();
        }
        return null;
    }

    @Override
    public List<T> slaves() {
        Group<T> group = this.group;
        if (group != null) {
            return group.slaves();
        }
        return Collections.emptyList();
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

