/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab;

import io.fabric8.fab.DependencyFilter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.fusesource.common.util.Filter;
import org.fusesource.common.util.Filters;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyNode;

public class DependencyFilters {
    public static final Filter<Dependency> testScopeFilter = DependencyFilters.createScopeFilter("test");
    public static final Filter<Dependency> optionalFilter = new Filter<Dependency>(){

        @Override
        public boolean matches(Dependency tree) {
            return tree.isOptional();
        }

        public String toString() {
            return "OptionalFilter";
        }
    };
    public static final Filter<Dependency> testScopeOrOptionalFilter = Filters.or(testScopeFilter, optionalFilter);

    public static boolean matches(Dependency dependency, Filter<Dependency> excludeDependencyFilter) {
        return excludeDependencyFilter == null || excludeDependencyFilter.matches(dependency);
    }

    public static boolean matches(DependencyNode node, Filter<Dependency> excludeDependencyFilter) {
        return DependencyFilters.matches(node.getDependency(), excludeDependencyFilter);
    }

    public static final Filter<Dependency> createScopeFilter(final String scopeFilter) {
        return new Filter<Dependency>(){

            @Override
            public boolean matches(Dependency Dependency2) {
                String scope = Dependency2.getScope();
                return scope != null && scopeFilter.equals(scope);
            }
        };
    }

    public static Filter<Dependency> parseExcludeFilter(String dependencyFilterText, Filter excludeOptionalDependenciesFilter) {
        Filter<Dependency> filter = DependencyFilters.parse(dependencyFilterText);
        if (Filters.isEmpty(filter)) {
            return excludeOptionalDependenciesFilter;
        }
        return Filters.or(excludeOptionalDependenciesFilter, filter);
    }

    public static Filter<Dependency> parseExcludeOptionalFilter(String includeOptionalDependencyFilterText) {
        final Filter<Dependency> filter = DependencyFilters.parse(includeOptionalDependencyFilterText);
        final boolean excludeAll = Filters.isEmpty(filter);
        return new Filter<Dependency>(){

            @Override
            public boolean matches(Dependency tree) {
                if (tree.isOptional()) {
                    if (excludeAll) {
                        return true;
                    }
                    return !filter.matches(tree);
                }
                return false;
            }
        };
    }

    public static Filter<Dependency> parseRequireBundleFilter(String filterText) {
        return DependencyFilters.parse(filterText);
    }

    public static Filter<Dependency> parse(String dependencyFilterText) {
        ArrayList filters = new ArrayList();
        StringTokenizer iter = new StringTokenizer(dependencyFilterText);
        while (iter.hasMoreElements()) {
            String text = iter.nextToken();
            Filter<Dependency> filter = DependencyFilters.parseSingleFilter(text);
            if (filter == null) continue;
            filters.add(filter);
        }
        return Filters.compositeFilter(filters);
    }

    protected static Filter<Dependency> parseSingleFilter(String text) {
        String[] split = text.split(":");
        if (split == null || split.length == 0) {
            return null;
        }
        Filter<String> groupFilter = DependencyFilters.createStringFilter(split[0]);
        Filter<Object> artifactFilter = split.length == 1 ? Filters.trueFilter() : DependencyFilters.createStringFilter(split[1]);
        return new DependencyFilter(groupFilter, artifactFilter);
    }

    protected static Filter<String> createStringFilter(final String text) {
        if (text.startsWith("!")) {
            String remaining = text.substring(1);
            return Filters.not(DependencyFilters.createStringFilter(remaining));
        }
        if (text == null || text.length() == 0 || text.startsWith("*")) {
            return Filters.trueFilter();
        }
        if (text.endsWith("*")) {
            final String prefix = text.substring(0, text.length() - 1);
            return new Filter<String>(){

                @Override
                public boolean matches(String s) {
                    return s.startsWith(prefix);
                }

                public String toString() {
                    return "StartsWith(" + prefix + ")";
                }
            };
        }
        return new Filter<String>(){

            @Override
            public boolean matches(String s) {
                return text.equals(s);
            }

            public String toString() {
                return "Equals(" + text + ")";
            }
        };
    }
}

