/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab;

import io.fabric8.fab.Content;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class EntryFilterEnumeration
implements Enumeration {
    private final List<Iterator<String>> m_enumerations;
    private final List<Content> m_jars;
    private int m_moduleIndex = 0;
    private final String m_path;
    private final List<String> m_filePattern;
    private final boolean m_recurse;
    private final boolean m_isURLValues;
    private final Set<String> m_dirEntries = new HashSet<String>();
    private final List<Object> m_nextEntries = new ArrayList<Object>(2);

    public EntryFilterEnumeration(List<Content> jars, String path, String filePattern, boolean recurse, boolean isURLValues) {
        this.m_jars = jars;
        this.m_enumerations = new ArrayList<Iterator<String>>(this.m_jars.size());
        for (int i = 0; i < this.m_jars.size(); ++i) {
            this.m_enumerations.add(this.m_jars.get(i).getEntries().iterator());
        }
        this.m_recurse = recurse;
        this.m_isURLValues = isURLValues;
        if (path == null) {
            throw new IllegalArgumentException("The path for findEntries() cannot be null.");
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (path.length() > 0 && path.charAt(path.length() - 1) != '/') {
            path = path + "/";
        }
        this.m_path = path;
        filePattern = filePattern == null ? "*" : filePattern;
        this.m_filePattern = EntryFilterEnumeration.parseSubstring(filePattern);
        this.findNext();
    }

    @Override
    public synchronized boolean hasMoreElements() {
        return !this.m_nextEntries.isEmpty();
    }

    public synchronized Object nextElement() {
        if (this.m_nextEntries.isEmpty()) {
            throw new NoSuchElementException("No more entries.");
        }
        Object last = this.m_nextEntries.remove(0);
        this.findNext();
        return last;
    }

    private void findNext() {
        if (this.m_enumerations == null) {
            return;
        }
        while (this.m_moduleIndex < this.m_enumerations.size() && this.m_nextEntries.isEmpty()) {
            while (this.m_enumerations.get(this.m_moduleIndex) != null && this.m_enumerations.get(this.m_moduleIndex).hasNext() && this.m_nextEntries.isEmpty()) {
                String entryName = this.m_enumerations.get(this.m_moduleIndex).next();
                if (entryName.equals(this.m_path) || !entryName.startsWith(this.m_path)) continue;
                URL entryURL = null;
                int dirSlashIdx = entryName.indexOf(47, this.m_path.length());
                if (dirSlashIdx >= 0) {
                    int subDirSlashIdx = dirSlashIdx;
                    do {
                        String dir;
                        if (!this.m_dirEntries.contains(dir = entryName.substring(0, subDirSlashIdx + 1))) {
                            this.m_dirEntries.add(dir);
                            if (entryName.length() != subDirSlashIdx + 1 && EntryFilterEnumeration.compareSubstring(this.m_filePattern, EntryFilterEnumeration.getLastPathElement(dir))) {
                                if (this.m_isURLValues) {
                                    try {
                                        entryURL = entryURL == null ? this.m_jars.get(this.m_moduleIndex).getURL(entryName) : entryURL;
                                        this.m_nextEntries.add(new URL(entryURL, "/" + dir));
                                    }
                                    catch (MalformedURLException ex) {}
                                } else {
                                    this.m_nextEntries.add(dir);
                                }
                            }
                        }
                        subDirSlashIdx = entryName.indexOf(47, dir.length());
                    } while (this.m_recurse && subDirSlashIdx >= 0);
                }
                if (!this.m_recurse && dirSlashIdx >= 0 && dirSlashIdx != entryName.length() - 1 || !EntryFilterEnumeration.compareSubstring(this.m_filePattern, EntryFilterEnumeration.getLastPathElement(entryName))) continue;
                if (this.m_isURLValues) {
                    try {
                        entryURL = entryURL == null ? this.m_jars.get(this.m_moduleIndex).getURL(entryName) : entryURL;
                        this.m_nextEntries.add(entryURL);
                    }
                    catch (MalformedURLException ex) {}
                    continue;
                }
                this.m_nextEntries.add(entryName);
            }
            if (!this.m_nextEntries.isEmpty()) continue;
            ++this.m_moduleIndex;
        }
    }

    private static String getLastPathElement(String entryName) {
        int endIdx = entryName.charAt(entryName.length() - 1) == '/' ? entryName.length() - 1 : entryName.length();
        int startIdx = entryName.charAt(entryName.length() - 1) == '/' ? entryName.lastIndexOf(47, endIdx - 1) + 1 : entryName.lastIndexOf(47, endIdx) + 1;
        return entryName.substring(startIdx, endIdx);
    }

    static List<String> parseSubstring(String value) {
        ArrayList<String> pieces = new ArrayList<String>();
        StringBuffer ss = new StringBuffer();
        boolean wasStar = false;
        boolean leftstar = false;
        boolean rightstar = false;
        int idx = 0;
        boolean escaped = false;
        while (true) {
            if (idx >= value.length()) {
                if (wasStar) {
                    rightstar = true;
                    break;
                }
                pieces.add(ss.toString());
                break;
            }
            char c = value.charAt(idx++);
            if (!(escaped || c != '(' && c != ')')) {
                throw new IllegalArgumentException("Illegal value: " + value);
            }
            if (!escaped && c == '*') {
                if (wasStar) {
                    throw new IllegalArgumentException("Invalid filter string: " + value);
                }
                if (ss.length() > 0) {
                    pieces.add(ss.toString());
                }
                ss.setLength(0);
                if (pieces.size() == 0) {
                    leftstar = true;
                }
                wasStar = true;
                continue;
            }
            if (!escaped && c == '\\') {
                escaped = true;
                continue;
            }
            escaped = false;
            wasStar = false;
            ss.append(c);
        }
        ss.setLength(0);
        if (leftstar || rightstar || pieces.size() > 1) {
            if (rightstar) {
                pieces.add("");
            }
            if (leftstar) {
                pieces.add(0, "");
            }
        }
        return pieces;
    }

    static boolean compareSubstring(List<String> pieces, String s) {
        boolean result = true;
        int len = pieces.size();
        if (len == 1) {
            return s.equals(pieces.get(0));
        }
        int index = 0;
        for (int i = 0; i < len; ++i) {
            String piece = pieces.get(i);
            if (i == 0 && !s.startsWith(piece)) {
                result = false;
                break;
            }
            if (i == len - 1) {
                if (s.endsWith(piece)) {
                    result = true;
                    break;
                }
                result = false;
                break;
            }
            if (i > 0 && i < len - 1 && (index = s.indexOf(piece, index)) < 0) {
                result = false;
                break;
            }
            index += piece.length();
        }
        return result;
    }
}

