/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.fab.osgi.internal;

import io.fabric8.fab.DependencyTree;
import io.fabric8.fab.MavenResolver;
import io.fabric8.fab.MavenResolverImpl;
import io.fabric8.fab.PomDetails;
import io.fabric8.fab.osgi.internal.Bundles;
import io.fabric8.fab.osgi.internal.FabFacade;
import java.io.File;
import java.io.IOException;
import org.osgi.framework.BundleContext;

public abstract class FabFacadeSupport
implements FabFacade {
    private PomDetails pomDetails;
    private MavenResolver resolver;
    private boolean includeSharedResources = true;

    @Override
    public PomDetails resolvePomDetails() throws IOException {
        PomDetails pomDetails = this.getPomDetails();
        if (pomDetails == null) {
            pomDetails = this.findPomDetails();
        }
        return pomDetails;
    }

    protected PomDetails findPomDetails() throws IOException {
        File fileJar = this.getJarFile();
        PomDetails pomDetails = this.getResolver().findPomFile(fileJar);
        return pomDetails;
    }

    @Override
    public boolean isIncludeSharedResources() {
        return this.includeSharedResources;
    }

    public void setIncludeSharedResources(boolean includeSharedResources) {
        this.includeSharedResources = includeSharedResources;
    }

    public PomDetails getPomDetails() {
        return this.pomDetails;
    }

    public void setPomDetails(PomDetails pomDetails) {
        this.pomDetails = pomDetails;
    }

    @Override
    public MavenResolver getResolver() {
        if (this.resolver == null) {
            this.resolver = new MavenResolverImpl();
        }
        return this.resolver;
    }

    public void setResolver(MavenResolver resolver) {
        this.resolver = resolver;
    }

    protected static boolean isInstalled(BundleContext context, DependencyTree tree) {
        if (context != null && tree.getVersion() != null && tree.getBundleSymbolicName() != null) {
            return Bundles.findBundle(context, tree.getBundleSymbolicName(), tree.getVersion()) != null;
        }
        return false;
    }
}

