/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.net.SocketFactory;
import org.apache.activemq.transport.amqp.AmqpHeader;
import org.apache.activemq.transport.amqp.AmqpSupport;
import org.apache.activemq.transport.nio.NIOOutputStream;
import org.apache.activemq.transport.nio.SelectorManager;
import org.apache.activemq.transport.nio.SelectorSelection;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.wireformat.WireFormat;
import org.fusesource.hawtbuf.Buffer;

public class AmqpNioTransport
extends TcpTransport {
    private DataInputStream amqpHeaderValue = new DataInputStream(new ByteArrayInputStream(new byte[]{65, 77, 81, 80}));
    private final Integer AMQP_HEADER_VALUE = this.amqpHeaderValue.readInt();
    private SocketChannel channel;
    private SelectorSelection selection;
    private ByteBuffer inputBuffer;
    boolean magicRead = false;

    public AmqpNioTransport(WireFormat wireFormat, SocketFactory socketFactory, URI remoteLocation, URI localLocation) throws UnknownHostException, IOException {
        super(wireFormat, socketFactory, remoteLocation, localLocation);
    }

    public AmqpNioTransport(WireFormat wireFormat, Socket socket) throws IOException {
        super(wireFormat, socket);
    }

    @Override
    protected void initializeStreams() throws IOException {
        this.channel = this.socket.getChannel();
        this.channel.configureBlocking(false);
        this.selection = SelectorManager.getInstance().register(this.channel, new SelectorManager.Listener(){

            @Override
            public void onSelect(SelectorSelection selection) {
                if (!AmqpNioTransport.this.isStopped()) {
                    AmqpNioTransport.this.serviceRead();
                }
            }

            @Override
            public void onError(SelectorSelection selection, Throwable error) {
                if (error instanceof IOException) {
                    AmqpNioTransport.this.onException((IOException)error);
                } else {
                    AmqpNioTransport.this.onException(IOExceptionSupport.create(error));
                }
            }
        });
        this.inputBuffer = ByteBuffer.allocate(8192);
        NIOOutputStream outPutStream = new NIOOutputStream(this.channel, 8192);
        this.dataOut = new DataOutputStream(outPutStream);
        this.buffOut = outPutStream;
    }

    private void serviceRead() {
        try {
            while (this.isStarted()) {
                int readSize = this.channel.read(this.inputBuffer);
                if (readSize == -1) {
                    this.onException(new EOFException());
                    this.selection.close();
                } else if (readSize != 0) {
                    this.receiveCounter += readSize;
                    this.inputBuffer.flip();
                    if (!this.magicRead) {
                        if (this.inputBuffer.remaining() >= 8) {
                            this.magicRead = true;
                            Buffer magic = new Buffer(8);
                            for (int i = 0; i < 8; ++i) {
                                magic.data[i] = this.inputBuffer.get();
                            }
                            this.doConsume(new AmqpHeader(magic));
                        } else {
                            this.inputBuffer.flip();
                            continue;
                        }
                    }
                    while (this.inputBuffer.position() < this.inputBuffer.limit()) {
                        this.inputBuffer.mark();
                        int commandSize = this.inputBuffer.getInt();
                        this.inputBuffer.reset();
                        if (commandSize == this.AMQP_HEADER_VALUE) {
                            this.doConsume(AmqpSupport.toBuffer(this.inputBuffer));
                            break;
                        }
                        byte[] bytes = new byte[commandSize];
                        ByteBuffer commandBuffer = ByteBuffer.allocate(commandSize);
                        this.inputBuffer.get(bytes, 0, commandSize);
                        commandBuffer.put(bytes);
                        commandBuffer.flip();
                        this.doConsume(AmqpSupport.toBuffer(commandBuffer));
                        commandBuffer.clear();
                    }
                    this.inputBuffer.clear();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.onException(e);
        }
        catch (Throwable e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.connect();
        this.selection.setInterestOps(1);
        this.selection.enable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
        try {
            if (this.selection != null) {
                this.selection.close();
            }
        }
        finally {
            super.doStop(stopper);
        }
    }
}

