/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.AbstractElement;
import org.apache.qpid.proton.codec.impl.ArrayElement;
import org.apache.qpid.proton.codec.impl.Element;

class MapElement
extends AbstractElement<Map<Object, Object>> {
    private Element _first;

    MapElement(Element parent, Element prev) {
        super(parent, prev);
    }

    public int count() {
        int count = 0;
        for (Element elt = this._first; elt != null; elt = elt.next()) {
            ++count;
        }
        return count;
    }

    @Override
    public int size() {
        int count = 0;
        int size2 = 0;
        for (Element elt = this._first; elt != null; elt = elt.next()) {
            ++count;
            size2 += elt.size();
        }
        if (this.isElementOfArray()) {
            ArrayElement parent = (ArrayElement)this.parent();
            if (parent.constructorType() == ArrayElement.SMALL) {
                if (count > 255 || size2 > 254) {
                    parent.setConstructorType(ArrayElement.ConstructorType.LARGE);
                    size2 += 8;
                } else {
                    size2 += 2;
                }
            }
            size2 += 8;
        } else {
            size2 = count <= 255 && size2 <= 254 ? (size2 += 3) : (size2 += 9);
        }
        return size2;
    }

    @Override
    public Map<Object, Object> getValue() {
        LinkedHashMap map2 = new LinkedHashMap();
        Element elt = this._first;
        while (elt != null) {
            Object value;
            Object key = elt.getValue();
            if ((elt = elt.next()) != null) {
                value = elt.getValue();
                elt = elt.next();
            } else {
                value = null;
            }
            map2.put(key, value);
        }
        return Collections.unmodifiableMap(map2);
    }

    @Override
    public Data.DataType getDataType() {
        return Data.DataType.MAP;
    }

    @Override
    public int encode(ByteBuffer b) {
        Element elt;
        int encodedSize = this.size();
        int count = 0;
        int size2 = 0;
        for (elt = this._first; elt != null; elt = elt.next()) {
            ++count;
            size2 += elt.size();
        }
        if (encodedSize > b.remaining()) {
            return 0;
        }
        if (this.isElementOfArray()) {
            switch (((ArrayElement)this.parent()).constructorType()) {
                case SMALL: {
                    b.put((byte)(size2 + 1));
                    b.put((byte)count);
                    break;
                }
                case LARGE: {
                    b.putInt(size2 + 4);
                    b.putInt(count);
                }
            }
        } else if (size2 <= 254 && count <= 255) {
            b.put((byte)-63);
            b.put((byte)(size2 + 1));
            b.put((byte)count);
        } else {
            b.put((byte)-47);
            b.putInt(size2 + 4);
            b.putInt(count);
        }
        for (elt = this._first; elt != null; elt = elt.next()) {
            elt.encode(b);
        }
        return encodedSize;
    }

    @Override
    public boolean canEnter() {
        return true;
    }

    @Override
    public Element child() {
        return this._first;
    }

    @Override
    public Element checkChild(Element element) {
        return element;
    }

    @Override
    public Element addChild(Element element) {
        this._first = element;
        return element;
    }
}

