/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.util.Arrays;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.impl.LinkImpl;
import org.apache.qpid.proton.engine.impl.ReceiverImpl;
import org.apache.qpid.proton.engine.impl.SenderImpl;
import org.apache.qpid.proton.engine.impl.TransportDelivery;

public class DeliveryImpl
implements Delivery {
    private DeliveryImpl _linkPrevious;
    private DeliveryImpl _linkNext;
    private DeliveryImpl _workNext;
    private DeliveryImpl _workPrev;
    boolean _work;
    private DeliveryImpl _transportWorkNext;
    private DeliveryImpl _transportWorkPrev;
    boolean _transportWork;
    private Object _context;
    private final byte[] _tag;
    private final LinkImpl _link;
    private DeliveryState _deliveryState;
    private boolean _settled;
    private boolean _remoteSettled;
    private DeliveryState _remoteDeliveryState;
    private static final int DELIVERY_STATE_CHANGED = 1;
    private static final int ABLE_TO_SEND = 2;
    private static final int IO_WORK = 4;
    private static final int DELIVERY_SETTLED = 8;
    private int _flags = 0;
    private TransportDelivery _transportDelivery;
    private byte[] _data;
    private int _dataSize;
    private boolean _complete;
    private boolean _updated;
    private boolean _done;
    private int _offset;

    DeliveryImpl(byte[] tag, LinkImpl link2, DeliveryImpl previous) {
        this._tag = tag;
        this._link = link2;
        this._link.incrementUnsettled();
        this._linkPrevious = previous;
        if (previous != null) {
            previous._linkNext = this;
        }
    }

    @Override
    public byte[] getTag() {
        return this._tag;
    }

    @Override
    public LinkImpl getLink() {
        return this._link;
    }

    @Override
    public DeliveryState getLocalState() {
        return this._deliveryState;
    }

    @Override
    public DeliveryState getRemoteState() {
        return this._remoteDeliveryState;
    }

    @Override
    public boolean remotelySettled() {
        return this._remoteSettled;
    }

    @Override
    public int getMessageFormat() {
        return 0;
    }

    @Override
    public void disposition(DeliveryState state) {
        this._deliveryState = state;
        if (!this._remoteSettled) {
            this.addToTransportWorkList();
        }
    }

    @Override
    public void settle() {
        if (this._settled) {
            return;
        }
        this._settled = true;
        this._link.decrementUnsettled();
        if (!this._remoteSettled) {
            this.addToTransportWorkList();
        } else {
            this._transportDelivery.settled();
        }
        if (this._link.current() == this) {
            this._link.advance();
        }
        this._link.remove(this);
        if (this._linkPrevious != null) {
            this._linkPrevious._linkNext = this._linkNext;
        }
        if (this._linkNext != null) {
            this._linkNext._linkPrevious = this._linkPrevious;
        }
        this.updateWork();
    }

    DeliveryImpl getLinkNext() {
        return this._linkNext;
    }

    @Override
    public void free() {
    }

    DeliveryImpl getLinkPrevious() {
        return this._linkPrevious;
    }

    @Override
    public DeliveryImpl getWorkNext() {
        if (this._workNext != null) {
            return this._workNext;
        }
        if (!this._work) {
            return this._link.getConnectionImpl().getWorkHead();
        }
        return null;
    }

    DeliveryImpl getWorkPrev() {
        return this._workPrev;
    }

    void setWorkNext(DeliveryImpl workNext) {
        this._workNext = workNext;
    }

    void setWorkPrev(DeliveryImpl workPrev) {
        this._workPrev = workPrev;
    }

    int recv(byte[] bytes, int offset, int size2) {
        int consumed;
        if (this._data != null) {
            consumed = Math.min(size2, this._dataSize);
            System.arraycopy(this._data, this._offset, bytes, offset, consumed);
            this._offset += consumed;
            this._dataSize -= consumed;
        } else {
            consumed = 0;
            this._dataSize = 0;
        }
        return this._complete && consumed == 0 ? -1 : consumed;
    }

    void updateWork() {
        this.getLink().getConnectionImpl().workUpdate(this);
    }

    DeliveryImpl clearTransportWork() {
        DeliveryImpl next = this._transportWorkNext;
        this.getLink().getConnectionImpl().removeTransportWork(this);
        return next;
    }

    void addToTransportWorkList() {
        this.getLink().getConnectionImpl().addTransportWork(this);
    }

    DeliveryImpl getTransportWorkNext() {
        return this._transportWorkNext;
    }

    DeliveryImpl getTransportWorkPrev() {
        return this._transportWorkPrev;
    }

    void setTransportWorkNext(DeliveryImpl transportWorkNext) {
        this._transportWorkNext = transportWorkNext;
    }

    void setTransportWorkPrev(DeliveryImpl transportWorkPrev) {
        this._transportWorkPrev = transportWorkPrev;
    }

    TransportDelivery getTransportDelivery() {
        return this._transportDelivery;
    }

    void setTransportDelivery(TransportDelivery transportDelivery) {
        this._transportDelivery = transportDelivery;
    }

    @Override
    public boolean isSettled() {
        return this._settled;
    }

    int send(byte[] bytes, int offset, int length) {
        if (this._data == null) {
            this._data = new byte[length];
        } else if (this._data.length - this._dataSize < length) {
            byte[] oldData = this._data;
            this._data = new byte[oldData.length + this._dataSize];
            System.arraycopy(oldData, this._offset, this._data, 0, this._dataSize);
            this._offset = 0;
        }
        System.arraycopy(bytes, offset, this._data, this._dataSize + this._offset, length);
        this._dataSize += length;
        this.addToTransportWorkList();
        return length;
    }

    byte[] getData() {
        return this._data;
    }

    int getDataOffset() {
        return this._offset;
    }

    int getDataLength() {
        return this._dataSize;
    }

    void setData(byte[] data) {
        this._data = data;
    }

    void setDataLength(int length) {
        this._dataSize = length;
    }

    public void setDataOffset(int arrayOffset) {
        this._offset = arrayOffset;
    }

    @Override
    public boolean isWritable() {
        return this.getLink() instanceof SenderImpl && this.getLink().current() == this && ((SenderImpl)this.getLink()).hasCredit();
    }

    @Override
    public boolean isReadable() {
        return this.getLink() instanceof ReceiverImpl && this.getLink().current() == this;
    }

    void setComplete() {
        this._complete = true;
    }

    @Override
    public boolean isPartial() {
        return !this._complete;
    }

    void setRemoteDeliveryState(DeliveryState remoteDeliveryState) {
        this._remoteDeliveryState = remoteDeliveryState;
        this._updated = true;
    }

    @Override
    public boolean isUpdated() {
        return this._updated;
    }

    @Override
    public void clear() {
        this._updated = false;
        this.getLink().getConnectionImpl().workUpdate(this);
    }

    void setDone() {
        this._done = true;
    }

    boolean isDone() {
        return this._done;
    }

    void setRemoteSettled(boolean remoteSettled) {
        this._remoteSettled = remoteSettled;
        this._updated = true;
    }

    @Override
    public boolean isBuffered() {
        if (this._remoteSettled) {
            return false;
        }
        if (this.getLink() instanceof SenderImpl) {
            if (this.isDone()) {
                return false;
            }
            return this._complete || this._dataSize > 0;
        }
        return false;
    }

    @Override
    public Object getContext() {
        return this._context;
    }

    @Override
    public void setContext(Object context) {
        this._context = context;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DeliveryImpl [_tag=").append(Arrays.toString(this._tag)).append(", _link=").append(this._link).append(", _deliveryState=").append(this._deliveryState).append(", _settled=").append(this._settled).append(", _remoteSettled=").append(this._remoteSettled).append(", _remoteDeliveryState=").append(this._remoteDeliveryState).append(", _flags=").append(this._flags).append(", _transportDelivery=").append(this._transportDelivery).append(", _dataSize=").append(this._dataSize).append(", _complete=").append(this._complete).append(", _updated=").append(this._updated).append(", _done=").append(this._done).append(", _offset=").append(this._offset).append("]");
        return builder.toString();
    }

    @Override
    public int pending() {
        return this._dataSize;
    }
}

