/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth;

import java.io.IOException;
import org.apache.sshd.client.UserAuth;
import org.apache.sshd.client.auth.AbstractUserAuth;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.util.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAuthPassword
extends AbstractUserAuth {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String password;

    public UserAuthPassword(ClientSessionImpl session, String service, String username, String password) {
        super(session, service, username);
        this.password = password;
    }

    public UserAuth.Result next(Buffer buffer) throws IOException {
        if (buffer == null) {
            this.log.info("Send SSH_MSG_USERAUTH_REQUEST for password");
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_USERAUTH_REQUEST, 0);
            buffer.putString(this.username);
            buffer.putString(this.service);
            buffer.putString("password");
            buffer.putByte((byte)0);
            buffer.putString(this.password);
            this.session.writePacket(buffer);
            return UserAuth.Result.Continued;
        }
        SshConstants.Message cmd = buffer.getCommand();
        this.log.info("Received {}", (Object)cmd);
        if (cmd == SshConstants.Message.SSH_MSG_USERAUTH_SUCCESS) {
            return UserAuth.Result.Success;
        }
        if (cmd == SshConstants.Message.SSH_MSG_USERAUTH_FAILURE) {
            return UserAuth.Result.Failure;
        }
        return UserAuth.Result.Continued;
    }
}

