/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.session;

import java.io.IOException;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.agent.common.AgentForwardSupport;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.KeyExchange;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.SshdSocketAddress;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.UserAuth;
import org.apache.sshd.server.channel.OpenChannelException;
import org.apache.sshd.server.x11.X11ForwardSupport;

public class ServerSession
extends AbstractSession {
    private Future authTimerFuture;
    private Future idleTimerFuture;
    private int maxAuthRequests = this.getIntProperty("max-auth-requests", this.maxAuthRequests);
    private int nbAuthRequests;
    private int authTimeout = this.getIntProperty("auth-timeout", this.authTimeout);
    private int idleTimeout = this.getIntProperty("idle-timeout", this.idleTimeout);
    private boolean allowMoreSessions = true;
    private final AgentForwardSupport agentForward = new AgentForwardSupport(this);
    private final X11ForwardSupport x11Forward = new X11ForwardSupport(this);
    private List<NamedFactory<UserAuth>> userAuthFactories;
    private List<List<String>> authMethods;
    private String authUserName;
    private String authMethod;
    private String authService;
    private UserAuth currentAuth;

    public ServerSession(ServerFactoryManager server, IoSession ioSession) throws Exception {
        super(server, ioSession);
        this.log.info("Session created from {}", (Object)ioSession.getRemoteAddress());
        this.sendServerIdentification();
        this.sendKexInit();
    }

    public CloseFuture close(boolean immediately) {
        this.unscheduleAuthTimer();
        this.unscheduleIdleTimer();
        this.agentForward.close();
        this.x11Forward.close();
        return super.close(immediately);
    }

    public String getNegociated(int index) {
        return this.negociated[index];
    }

    public KeyExchange getKex() {
        return this.kex;
    }

    public byte[] getSessionId() {
        return this.sessionId;
    }

    public ServerFactoryManager getServerFactoryManager() {
        return (ServerFactoryManager)this.factoryManager;
    }

    protected ScheduledExecutorService getScheduledExecutorService() {
        return this.getServerFactoryManager().getScheduledExecutorService();
    }

    public IoWriteFuture writePacket(Buffer buffer) throws IOException {
        boolean rescheduleIdleTimer;
        boolean bl = rescheduleIdleTimer = this.getState() == Session.State.Running;
        if (rescheduleIdleTimer) {
            this.unscheduleIdleTimer();
        }
        IoWriteFuture future = super.writePacket(buffer);
        if (rescheduleIdleTimer) {
            this.scheduleIdleTimer();
        }
        return future;
    }

    protected void handleMessage(Buffer buffer) throws Exception {
        SshConstants.Message cmd = buffer.getCommand();
        this.log.debug("Received packet {}", (Object)cmd);
        block0 : switch (cmd) {
            case SSH_MSG_DISCONNECT: {
                int code = buffer.getInt();
                String msg = buffer.getString();
                this.log.debug("Received SSH_MSG_DISCONNECT (reason={}, msg={})", (Object)code, (Object)msg);
                this.close(true);
                break;
            }
            case SSH_MSG_UNIMPLEMENTED: {
                int code = buffer.getInt();
                this.log.debug("Received SSH_MSG_UNIMPLEMENTED #{}", (Object)code);
                break;
            }
            case SSH_MSG_DEBUG: {
                boolean display = buffer.getBoolean();
                String msg = buffer.getString();
                this.log.debug("Received SSH_MSG_DEBUG (display={}) '{}'", (Object)display, (Object)msg);
                break;
            }
            case SSH_MSG_IGNORE: {
                this.log.debug("Received SSH_MSG_IGNORE");
                break;
            }
            default: {
                switch (this.getState()) {
                    case ReceiveKexInit: {
                        if (cmd != SshConstants.Message.SSH_MSG_KEXINIT) {
                            this.log.warn("Ignoring command " + (Object)((Object)cmd) + " while waiting for " + (Object)((Object)SshConstants.Message.SSH_MSG_KEXINIT));
                            break block0;
                        }
                        this.log.debug("Received SSH_MSG_KEXINIT");
                        this.receiveKexInit(buffer);
                        this.negociate();
                        this.kex = (KeyExchange)NamedFactory.Utils.create(this.factoryManager.getKeyExchangeFactories(), this.negociated[0]);
                        this.kex.init(this, this.serverVersion.getBytes(), this.clientVersion.getBytes(), this.I_S, this.I_C);
                        this.setState(Session.State.Kex);
                        break block0;
                    }
                    case Kex: {
                        buffer.rpos(buffer.rpos() - 1);
                        if (!this.kex.next(buffer)) break block0;
                        this.sendNewKeys();
                        this.setState(Session.State.ReceiveNewKeys);
                        break block0;
                    }
                    case ReceiveNewKeys: {
                        if (cmd != SshConstants.Message.SSH_MSG_NEWKEYS) {
                            this.disconnect(2, "Protocol error: expected packet " + (Object)((Object)SshConstants.Message.SSH_MSG_NEWKEYS) + ", got " + (Object)((Object)cmd));
                            return;
                        }
                        this.log.debug("Received SSH_MSG_NEWKEYS");
                        this.receiveNewKeys(true);
                        this.setState(Session.State.WaitForAuth);
                        this.scheduleAuthTimer();
                        break block0;
                    }
                    case WaitForAuth: {
                        if (cmd != SshConstants.Message.SSH_MSG_SERVICE_REQUEST) {
                            this.log.debug("Expecting a {}, but received {}", (Object)SshConstants.Message.SSH_MSG_SERVICE_REQUEST, (Object)cmd);
                            this.notImplemented();
                            break block0;
                        }
                        String request = buffer.getString();
                        this.log.debug("Received SSH_MSG_SERVICE_REQUEST '{}'", (Object)request);
                        if ("ssh-userauth".equals(request)) {
                            this.userAuth(buffer, null);
                            break block0;
                        }
                        this.disconnect(7, "Bad service request: " + request);
                        break block0;
                    }
                    case UserAuth: {
                        if (cmd != SshConstants.Message.SSH_MSG_USERAUTH_REQUEST && this.currentAuth == null) {
                            this.disconnect(2, "Protocol error: expected packet " + (Object)((Object)SshConstants.Message.SSH_MSG_USERAUTH_REQUEST) + ", got " + (Object)((Object)cmd));
                            return;
                        }
                        this.log.debug("Received " + (Object)((Object)cmd));
                        this.userAuth(buffer, cmd);
                        break block0;
                    }
                    case Running: {
                        this.unscheduleIdleTimer();
                        this.running(cmd, buffer);
                        this.scheduleIdleTimer();
                        break block0;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported state: " + (Object)((Object)this.getState()));
                    }
                }
            }
        }
    }

    private void running(SshConstants.Message cmd, Buffer buffer) throws Exception {
        switch (cmd) {
            case SSH_MSG_SERVICE_REQUEST: {
                this.serviceRequest(buffer);
                break;
            }
            case SSH_MSG_CHANNEL_OPEN: {
                this.channelOpen(buffer);
                break;
            }
            case SSH_MSG_CHANNEL_OPEN_CONFIRMATION: {
                this.channelOpenConfirmation(buffer);
                break;
            }
            case SSH_MSG_CHANNEL_OPEN_FAILURE: {
                this.channelOpenFailure(buffer);
                break;
            }
            case SSH_MSG_CHANNEL_REQUEST: {
                this.channelRequest(buffer);
                break;
            }
            case SSH_MSG_CHANNEL_DATA: {
                this.channelData(buffer);
                break;
            }
            case SSH_MSG_CHANNEL_EXTENDED_DATA: {
                this.channelExtendedData(buffer);
                break;
            }
            case SSH_MSG_CHANNEL_WINDOW_ADJUST: {
                this.channelWindowAdjust(buffer);
                break;
            }
            case SSH_MSG_CHANNEL_EOF: {
                this.channelEof(buffer);
                break;
            }
            case SSH_MSG_CHANNEL_CLOSE: {
                this.channelClose(buffer);
                break;
            }
            case SSH_MSG_GLOBAL_REQUEST: {
                this.globalRequest(buffer);
                break;
            }
            case SSH_MSG_KEXINIT: {
                this.receiveKexInit(buffer);
                this.sendKexInit();
                this.negociate();
                this.kex = (KeyExchange)NamedFactory.Utils.create(this.factoryManager.getKeyExchangeFactories(), this.negociated[0]);
                this.kex.init(this, this.serverVersion.getBytes(), this.clientVersion.getBytes(), this.I_S, this.I_C);
                break;
            }
            case SSH_MSG_KEXDH_INIT: {
                buffer.rpos(buffer.rpos() - 1);
                if (!this.kex.next(buffer)) break;
                this.sendNewKeys();
                break;
            }
            case SSH_MSG_NEWKEYS: {
                this.receiveNewKeys(true);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported command: " + (Object)((Object)cmd));
            }
        }
    }

    private void scheduleAuthTimer() {
        Runnable authTimerTask = new Runnable(){

            public void run() {
                try {
                    ServerSession.this.processAuthTimer();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        this.authTimerFuture = this.getScheduledExecutorService().schedule(authTimerTask, (long)this.authTimeout, TimeUnit.MILLISECONDS);
    }

    private void unscheduleAuthTimer() {
        if (this.authTimerFuture != null) {
            this.authTimerFuture.cancel(false);
            this.authTimerFuture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleIdleTimer() {
        if (this.idleTimeout < 1) {
            return;
        }
        ServerSession serverSession = this;
        synchronized (serverSession) {
            this.unscheduleIdleTimer();
            Runnable idleTimerTask = new Runnable(){

                public void run() {
                    try {
                        ServerSession.this.processIdleTimer();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            this.idleTimerFuture = this.getScheduledExecutorService().schedule(idleTimerTask, (long)this.idleTimeout, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unscheduleIdleTimer() {
        ServerSession serverSession = this;
        synchronized (serverSession) {
            if (this.idleTimerFuture != null) {
                this.idleTimerFuture.cancel(false);
                this.idleTimerFuture = null;
            }
        }
    }

    private void processAuthTimer() throws IOException {
        if (!this.authed) {
            this.disconnect(2, "User authentication has timed out");
        }
    }

    private void processIdleTimer() throws IOException {
        this.disconnect(2, "User session has timed out after being idled for " + this.idleTimeout + "ms.");
    }

    private void sendServerIdentification() {
        this.serverVersion = this.getFactoryManager().getProperties() != null && this.getFactoryManager().getProperties().get("server-identification") != null ? "SSH-2.0-" + this.getFactoryManager().getProperties().get("server-identification") : "SSH-2.0-" + this.getFactoryManager().getVersion();
        this.sendIdentification(this.serverVersion);
    }

    private void sendKexInit() throws IOException {
        this.serverProposal = this.createProposal(this.factoryManager.getKeyPairProvider().getKeyTypes());
        this.I_S = this.sendKexInit(this.serverProposal);
    }

    protected boolean readIdentification(Buffer buffer) throws IOException {
        this.clientVersion = this.doReadIdentification(buffer);
        if (this.clientVersion == null) {
            return false;
        }
        this.log.debug("Client version string: {}", (Object)this.clientVersion);
        if (!this.clientVersion.startsWith("SSH-2.0-")) {
            throw new SshException(8, "Unsupported protocol version: " + this.clientVersion);
        }
        return true;
    }

    private void receiveKexInit(Buffer buffer) throws IOException {
        this.clientProposal = new String[10];
        this.I_C = this.receiveKexInit(buffer, this.clientProposal);
    }

    private void serviceRequest(Buffer buffer) throws Exception {
        String request = buffer.getString();
        this.log.debug("Received SSH_MSG_SERVICE_REQUEST '{}'", (Object)request);
        this.disconnect(7, "Unsupported service request: " + request);
    }

    private void userAuth(Buffer buffer, SshConstants.Message cmd) throws Exception {
        if (this.getState() == Session.State.WaitForAuth) {
            this.log.debug("Accepting user authentication request");
            buffer = this.createBuffer(SshConstants.Message.SSH_MSG_SERVICE_ACCEPT, 0);
            buffer.putString("ssh-userauth");
            this.writePacket(buffer);
            this.userAuthFactories = new ArrayList<NamedFactory<UserAuth>>(this.getServerFactoryManager().getUserAuthFactories());
            this.authMethods = new ArrayList<List<String>>();
            String mths = this.getServerFactoryManager().getProperties().get("auth-methods");
            if (mths == null) {
                for (NamedFactory<UserAuth> namedFactory : this.getServerFactoryManager().getUserAuthFactories()) {
                    this.authMethods.add(new ArrayList<String>(Collections.singletonList(namedFactory.getName())));
                }
            } else {
                for (String mthl : mths.split("\\s")) {
                    this.authMethods.add(new ArrayList<String>(Arrays.asList(mthl.split(","))));
                }
            }
            for (List list : this.authMethods) {
                for (String m : list) {
                    if (NamedFactory.Utils.get(this.userAuthFactories, m) != null) continue;
                    throw new SshException("Configured method is not supported: " + m);
                }
            }
            this.log.debug("Authorized authentication methods: {}", (Object)NamedFactory.Utils.getNames(this.userAuthFactories));
            this.setState(Session.State.UserAuth);
        } else {
            Boolean authed = Boolean.FALSE;
            if (cmd == SshConstants.Message.SSH_MSG_USERAUTH_REQUEST) {
                if (this.currentAuth != null) {
                    this.currentAuth.destroy();
                    this.currentAuth = null;
                }
                String username = buffer.getString();
                String string = buffer.getString();
                String method = buffer.getString();
                if (this.authUserName == null || this.authService == null) {
                    this.authUserName = username;
                    this.authService = string;
                } else if (!this.authUserName.equals(username) || !this.authService.equals(string)) {
                    this.disconnect(2, "Change of username or service is not allowed (" + this.authUserName + ", " + this.authService + ") -> (" + username + ", " + string + ")");
                    return;
                }
                this.authMethod = method;
                if (this.nbAuthRequests++ > this.maxAuthRequests) {
                    this.disconnect(2, "Too may authentication failures");
                    return;
                }
                this.log.debug("Authenticating user '{}' with service '{}' and method '{}'", new Object[]{username, string, method});
                NamedFactory factory = NamedFactory.Utils.get(this.userAuthFactories, method);
                if (factory != null) {
                    this.currentAuth = (UserAuth)factory.create();
                    try {
                        authed = this.currentAuth.auth(this, username, string, buffer);
                    }
                    catch (Exception e) {
                        this.log.debug("Authentication failed: {}", (Object)e.getMessage());
                    }
                }
            } else {
                if (this.currentAuth == null) {
                    throw new IllegalStateException();
                }
                buffer.rpos(buffer.rpos() - 1);
                try {
                    authed = this.currentAuth.next(buffer);
                }
                catch (Exception e) {
                    this.log.debug("Authentication failed: {}", (Object)e.getMessage());
                }
            }
            if (authed == null) {
                this.log.debug("Authentication not finished");
            } else if (authed.booleanValue()) {
                this.log.debug("Authentication succeeded");
                this.username = this.currentAuth.getUserName();
                boolean success = false;
                for (List<String> l : this.authMethods) {
                    if (l.isEmpty() || !l.get(0).equals(this.authMethod)) continue;
                    l.remove(0);
                    success |= l.isEmpty();
                }
                if (success) {
                    String string;
                    String string2;
                    if (this.getFactoryManager().getProperties() != null && (string2 = this.getFactoryManager().getProperties().get("max-concurrent-sessions")) != null) {
                        int maxSessionCount = Integer.parseInt(string2);
                        int currentSessionCount = this.getActiveSessionCountForUser(this.username);
                        if (currentSessionCount >= maxSessionCount) {
                            this.disconnect(7, "Too many concurrent connections");
                            return;
                        }
                    }
                    if ((string = this.factoryManager.getProperties().get("welcome-banner")) != null) {
                        buffer = this.createBuffer(SshConstants.Message.SSH_MSG_USERAUTH_BANNER, 0);
                        buffer.putString(string);
                        buffer.putString("en");
                        this.writePacket(buffer);
                    }
                    buffer = this.createBuffer(SshConstants.Message.SSH_MSG_USERAUTH_SUCCESS, 0);
                    this.writePacket(buffer);
                    this.authed = true;
                    this.unscheduleAuthTimer();
                    this.setState(Session.State.Running);
                    this.scheduleIdleTimer();
                    this.log.info("Session {}@{} authenticated", (Object)this.getUsername(), (Object)this.getIoSession().getRemoteAddress());
                } else {
                    buffer = this.createBuffer(SshConstants.Message.SSH_MSG_USERAUTH_FAILURE, 0);
                    StringBuilder stringBuilder = new StringBuilder();
                    for (List<String> l : this.authMethods) {
                        if (l.isEmpty()) continue;
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append(l.get(0));
                    }
                    buffer.putString(stringBuilder.toString());
                    buffer.putByte((byte)1);
                    this.writePacket(buffer);
                }
                this.currentAuth.destroy();
                this.currentAuth = null;
            } else {
                this.log.debug("Authentication failed");
                buffer = this.createBuffer(SshConstants.Message.SSH_MSG_USERAUTH_FAILURE, 0);
                StringBuilder sb = new StringBuilder();
                for (List<String> l : this.authMethods) {
                    String m;
                    if (l.isEmpty() || "none".equals(m = l.get(0))) continue;
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(l.get(0));
                }
                buffer.putString(sb.toString());
                buffer.putByte((byte)1);
                this.writePacket(buffer);
                if (this.currentAuth != null) {
                    this.currentAuth.destroy();
                    this.currentAuth = null;
                }
            }
        }
    }

    public KeyPair getHostKey() {
        return this.factoryManager.getKeyPairProvider().loadKey(this.negociated[1]);
    }

    protected int getActiveSessionCountForUser(String userName) {
        int totalCount = 0;
        for (IoSession is : this.ioSession.getService().getManagedSessions().values()) {
            ServerSession session = (ServerSession)ServerSession.getSession(is, true);
            if (session == null || session.getUsername() == null || !session.getUsername().equals(userName)) continue;
            ++totalCount;
        }
        return totalCount;
    }

    private void channelOpen(Buffer buffer) throws Exception {
        String type = buffer.getString();
        final int id = buffer.getInt();
        int rwsize = buffer.getInt();
        int rmpsize = buffer.getInt();
        this.log.debug("Received SSH_MSG_CHANNEL_OPEN {}", (Object)type);
        if (this.closing) {
            Buffer buf = this.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_OPEN_FAILURE, 0);
            buf.putInt(id);
            buf.putInt(2L);
            buf.putString("SSH server is shutting down: " + type);
            buf.putString("");
            this.writePacket(buf);
            return;
        }
        if (!this.allowMoreSessions) {
            Buffer buf = this.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_OPEN_FAILURE, 0);
            buf.putInt(id);
            buf.putInt(2L);
            buf.putString("additional sessions disabled");
            buf.putString("");
            this.writePacket(buf);
            return;
        }
        final Channel channel = (Channel)NamedFactory.Utils.create(this.getServerFactoryManager().getChannelFactories(), type);
        if (channel == null) {
            Buffer buf = this.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_OPEN_FAILURE, 0);
            buf.putInt(id);
            buf.putInt(3L);
            buf.putString("Unsupported channel type: " + type);
            buf.putString("");
            this.writePacket(buf);
            return;
        }
        final int channelId = this.getNextChannelId();
        this.channels.put(channelId, channel);
        channel.init(this, channelId);
        channel.open(id, rwsize, rmpsize, buffer).addListener(new SshFutureListener<OpenFuture>(){

            @Override
            public void operationComplete(OpenFuture future) {
                try {
                    if (future.isOpened()) {
                        Buffer buf = ServerSession.this.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_OPEN_CONFIRMATION, 0);
                        buf.putInt(id);
                        buf.putInt(channelId);
                        buf.putInt(channel.getLocalWindow().getSize());
                        buf.putInt(channel.getLocalWindow().getPacketSize());
                        ServerSession.this.writePacket(buf);
                    } else if (future.getException() != null) {
                        Buffer buf = ServerSession.this.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_OPEN_FAILURE, 0);
                        buf.putInt(id);
                        if (future.getException() instanceof OpenChannelException) {
                            buf.putInt(((OpenChannelException)future.getException()).getReasonCode());
                            buf.putString(future.getException().getMessage());
                        } else {
                            buf.putInt(0L);
                            buf.putString("Error opening channel: " + future.getException().getMessage());
                        }
                        buf.putString("");
                        ServerSession.this.writePacket(buf);
                    }
                }
                catch (IOException e) {
                    ServerSession.this.exceptionCaught(e);
                }
            }
        });
    }

    private void globalRequest(Buffer buffer) throws Exception {
        String req = buffer.getString();
        boolean wantReply = buffer.getBoolean();
        this.log.debug("Received global request {}", (Object)req);
        if (!req.startsWith("keepalive@")) {
            if (req.equals("no-more-sessions@openssh.com")) {
                this.allowMoreSessions = false;
            } else {
                if (req.equals("tcpip-forward")) {
                    block10: {
                        String address = buffer.getString();
                        int port = buffer.getInt();
                        try {
                            SshdSocketAddress bound = this.getTcpipForwarder().localPortForwardingRequested(new SshdSocketAddress(address, port));
                            port = bound.getPort();
                            if (wantReply) {
                                buffer = this.createBuffer(SshConstants.Message.SSH_MSG_REQUEST_SUCCESS, 0);
                                buffer.putInt(port);
                                this.writePacket(buffer);
                            }
                        }
                        catch (Exception e) {
                            this.log.debug("Error starting tcpip forward", (Throwable)e);
                            if (!wantReply) break block10;
                            buffer = this.createBuffer(SshConstants.Message.SSH_MSG_REQUEST_FAILURE, 0);
                            this.writePacket(buffer);
                        }
                    }
                    return;
                }
                if (req.equals("cancel-tcpip-forward")) {
                    String address = buffer.getString();
                    int port = buffer.getInt();
                    this.getTcpipForwarder().localPortForwardingCancelled(new SshdSocketAddress(address, port));
                    if (wantReply) {
                        buffer = this.createBuffer(SshConstants.Message.SSH_MSG_REQUEST_SUCCESS, 0);
                        this.writePacket(buffer);
                    }
                    return;
                }
                this.log.debug("Received SSH_MSG_GLOBAL_REQUEST {}", (Object)req);
                this.log.warn("Unknown global request: {}", (Object)req);
            }
        }
        if (wantReply) {
            buffer = this.createBuffer(SshConstants.Message.SSH_MSG_REQUEST_FAILURE, 0);
            this.writePacket(buffer);
        }
    }

    public String initAgentForward() throws IOException {
        return this.agentForward.initialize();
    }

    public String createX11Display(boolean singleConnection, String authenticationProtocol, String authenticationCookie, int screen) throws IOException {
        return this.x11Forward.createDisplay(singleConnection, authenticationProtocol, authenticationCookie, screen);
    }

    public long getId() {
        return this.ioSession.getId();
    }
}

