/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.refresh;

import java.io.IOException;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequest;
import org.elasticsearch.action.support.broadcast.BroadcastOperationThreading;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class RefreshRequest
extends BroadcastOperationRequest<RefreshRequest> {
    private boolean waitForOperations = true;

    RefreshRequest() {
    }

    public RefreshRequest(String ... indices) {
        super(indices);
        this.operationThreading(BroadcastOperationThreading.THREAD_PER_SHARD);
    }

    public boolean waitForOperations() {
        return this.waitForOperations;
    }

    public RefreshRequest waitForOperations(boolean waitForOperations) {
        this.waitForOperations = waitForOperations;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.waitForOperations = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.waitForOperations);
    }
}

