/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.delete;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Required;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.VersionType;

public class DeleteRequest
extends ShardReplicationOperationRequest<DeleteRequest> {
    private String type;
    private String id;
    @Nullable
    private String routing;
    private boolean refresh;
    private long version;
    private VersionType versionType = VersionType.INTERNAL;

    public DeleteRequest(String index) {
        this.index = index;
    }

    public DeleteRequest(String index, String type, String id) {
        this.index = index;
        this.type = type;
        this.id = id;
    }

    public DeleteRequest(DeleteRequest request) {
        super(request);
        this.type = request.type();
        this.id = request.id();
        this.routing = request.routing();
        this.refresh = request.refresh();
        this.version = request.version();
        this.versionType = request.versionType();
    }

    public DeleteRequest() {
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.type == null) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (this.id == null) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        return validationException;
    }

    public String type() {
        return this.type;
    }

    @Required
    public DeleteRequest type(String type) {
        this.type = type;
        return this;
    }

    public String id() {
        return this.id;
    }

    @Required
    public DeleteRequest id(String id) {
        this.id = id;
        return this;
    }

    public DeleteRequest parent(String parent) {
        if (this.routing == null) {
            this.routing = parent;
        }
        return this;
    }

    public DeleteRequest routing(String routing) {
        this.routing = routing != null && routing.length() == 0 ? null : routing;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public DeleteRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public DeleteRequest version(long version) {
        this.version = version;
        return this;
    }

    public long version() {
        return this.version;
    }

    public DeleteRequest versionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    public VersionType versionType() {
        return this.versionType;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.type = in.readString();
        this.id = in.readString();
        this.routing = in.readOptionalString();
        this.refresh = in.readBoolean();
        this.version = in.readLong();
        this.versionType = VersionType.fromValue(in.readByte());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.type);
        out.writeString(this.id);
        out.writeOptionalString(this.routing());
        out.writeBoolean(this.refresh);
        out.writeLong(this.version);
        out.writeByte(this.versionType.getValue());
    }

    public String toString() {
        return "delete {[" + this.index + "][" + this.type + "][" + this.id + "]}";
    }
}

