/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.settings.NodeSettingsService;

public class DisableAllocationDecider
extends AllocationDecider {
    private volatile boolean disableNewAllocation;
    private volatile boolean disableAllocation;
    private volatile boolean disableReplicaAllocation;

    @Inject
    public DisableAllocationDecider(Settings settings, NodeSettingsService nodeSettingsService) {
        super(settings);
        this.disableNewAllocation = settings.getAsBoolean("cluster.routing.allocation.disable_new_allocation", false);
        this.disableAllocation = settings.getAsBoolean("cluster.routing.allocation.disable_allocation", false);
        this.disableReplicaAllocation = settings.getAsBoolean("cluster.routing.allocation.disable_replica_allocation", false);
        nodeSettingsService.addListener(new ApplySettings());
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (shardRouting.primary() && !allocation.routingNodes().routingTable().index(shardRouting.index()).shard(shardRouting.id()).primaryAllocatedPostApi()) {
            return allocation.ignoreDisable() ? Decision.YES : (this.disableNewAllocation ? Decision.NO : Decision.YES);
        }
        if (this.disableAllocation) {
            return allocation.ignoreDisable() ? Decision.YES : Decision.NO;
        }
        if (this.disableReplicaAllocation) {
            return shardRouting.primary() ? Decision.YES : (allocation.ignoreDisable() ? Decision.YES : Decision.NO);
        }
        return Decision.YES;
    }

    static {
        MetaData.addDynamicSettings("cluster.routing.allocation.disable_new_allocation", "cluster.routing.allocation.disable_allocation", "cluster.routing.allocation.disable_replica_allocation");
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            boolean disableReplicaAllocation;
            boolean disableAllocation;
            boolean disableNewAllocation = settings.getAsBoolean("cluster.routing.allocation.disable_new_allocation", DisableAllocationDecider.this.disableNewAllocation);
            if (disableNewAllocation != DisableAllocationDecider.this.disableNewAllocation) {
                DisableAllocationDecider.this.logger.info("updating [cluster.routing.allocation.disable_new_allocation] from [{}] to [{}]", DisableAllocationDecider.this.disableNewAllocation, disableNewAllocation);
                DisableAllocationDecider.this.disableNewAllocation = disableNewAllocation;
            }
            if ((disableAllocation = settings.getAsBoolean("cluster.routing.allocation.disable_allocation", DisableAllocationDecider.this.disableAllocation).booleanValue()) != DisableAllocationDecider.this.disableAllocation) {
                DisableAllocationDecider.this.logger.info("updating [cluster.routing.allocation.disable_allocation] from [{}] to [{}]", DisableAllocationDecider.this.disableAllocation, disableAllocation);
                DisableAllocationDecider.this.disableAllocation = disableAllocation;
            }
            if ((disableReplicaAllocation = settings.getAsBoolean("cluster.routing.allocation.disable_replica_allocation", DisableAllocationDecider.this.disableReplicaAllocation).booleanValue()) != DisableAllocationDecider.this.disableReplicaAllocation) {
                DisableAllocationDecider.this.logger.info("updating [cluster.routing.allocation.disable_replica_allocation] from [{}] to [{}]", DisableAllocationDecider.this.disableReplicaAllocation, disableReplicaAllocation);
                DisableAllocationDecider.this.disableReplicaAllocation = disableReplicaAllocation;
            }
        }
    }
}

