/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.TimeoutClusterStateListener;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.operation.OperationRouting;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoveryService;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class InternalClusterService
extends AbstractLifecycleComponent<ClusterService>
implements ClusterService {
    private final ThreadPool threadPool;
    private final DiscoveryService discoveryService;
    private final OperationRouting operationRouting;
    private final TransportService transportService;
    private final NodeSettingsService nodeSettingsService;
    private final TimeValue reconnectInterval;
    private volatile ExecutorService updateTasksExecutor;
    private final List<ClusterStateListener> priorityClusterStateListeners = new CopyOnWriteArrayList<ClusterStateListener>();
    private final List<ClusterStateListener> clusterStateListeners = new CopyOnWriteArrayList<ClusterStateListener>();
    private final List<ClusterStateListener> lastClusterStateListeners = new CopyOnWriteArrayList<ClusterStateListener>();
    private final LocalNodeMasterListeners localNodeMasterListeners;
    private final Queue<NotifyTimeout> onGoingTimeouts = ConcurrentCollections.newQueue();
    private volatile ClusterState clusterState = ClusterState.newClusterStateBuilder().build();
    private final ClusterBlocks.Builder initialBlocks = ClusterBlocks.builder().addGlobalBlock(Discovery.NO_MASTER_BLOCK);
    private volatile ScheduledFuture reconnectToNodes;

    @Inject
    public InternalClusterService(Settings settings, DiscoveryService discoveryService, OperationRouting operationRouting, TransportService transportService, NodeSettingsService nodeSettingsService, ThreadPool threadPool) {
        super(settings);
        this.operationRouting = operationRouting;
        this.transportService = transportService;
        this.discoveryService = discoveryService;
        this.threadPool = threadPool;
        this.nodeSettingsService = nodeSettingsService;
        this.nodeSettingsService.setClusterService(this);
        this.reconnectInterval = this.componentSettings.getAsTime("reconnect_interval", TimeValue.timeValueSeconds(10L));
        this.localNodeMasterListeners = new LocalNodeMasterListeners(threadPool);
    }

    public NodeSettingsService settingsService() {
        return this.nodeSettingsService;
    }

    @Override
    public void addInitialStateBlock(ClusterBlock block) throws ElasticSearchIllegalStateException {
        if (this.lifecycle.started()) {
            throw new ElasticSearchIllegalStateException("can't set initial block when started");
        }
        this.initialBlocks.addGlobalBlock(block);
    }

    @Override
    protected void doStart() throws ElasticSearchException {
        this.add(this.localNodeMasterListeners);
        this.clusterState = ClusterState.newClusterStateBuilder().blocks(this.initialBlocks).build();
        this.updateTasksExecutor = Executors.newSingleThreadExecutor(EsExecutors.daemonThreadFactory(this.settings, "clusterService#updateTask"));
        this.reconnectToNodes = this.threadPool.schedule(this.reconnectInterval, "generic", new ReconnectToNodes());
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        this.reconnectToNodes.cancel(true);
        for (NotifyTimeout onGoingTimeout : this.onGoingTimeouts) {
            onGoingTimeout.cancel();
            onGoingTimeout.listener.onClose();
        }
        this.updateTasksExecutor.shutdown();
        try {
            this.updateTasksExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.remove(this.localNodeMasterListeners);
    }

    @Override
    protected void doClose() throws ElasticSearchException {
    }

    @Override
    public DiscoveryNode localNode() {
        return this.discoveryService.localNode();
    }

    @Override
    public OperationRouting operationRouting() {
        return this.operationRouting;
    }

    @Override
    public ClusterState state() {
        return this.clusterState;
    }

    @Override
    public void addFirst(ClusterStateListener listener) {
        this.priorityClusterStateListeners.add(listener);
    }

    @Override
    public void addLast(ClusterStateListener listener) {
        this.lastClusterStateListeners.add(listener);
    }

    @Override
    public void add(ClusterStateListener listener) {
        this.clusterStateListeners.add(listener);
    }

    @Override
    public void remove(ClusterStateListener listener) {
        this.clusterStateListeners.remove(listener);
        this.priorityClusterStateListeners.remove(listener);
        this.lastClusterStateListeners.remove(listener);
        Iterator it = this.onGoingTimeouts.iterator();
        while (it.hasNext()) {
            NotifyTimeout timeout = (NotifyTimeout)it.next();
            if (!timeout.listener.equals(listener)) continue;
            timeout.cancel();
            it.remove();
        }
    }

    @Override
    public void add(LocalNodeMasterListener listener) {
        this.localNodeMasterListeners.add(listener);
    }

    @Override
    public void remove(LocalNodeMasterListener listener) {
        this.localNodeMasterListeners.remove(listener);
    }

    @Override
    public void add(TimeValue timeout, final TimeoutClusterStateListener listener) {
        if (this.lifecycle.stoppedOrClosed()) {
            listener.onClose();
            return;
        }
        NotifyTimeout notifyTimeout = new NotifyTimeout(listener, timeout);
        notifyTimeout.future = this.threadPool.schedule(timeout, "generic", notifyTimeout);
        this.onGoingTimeouts.add(notifyTimeout);
        this.clusterStateListeners.add(listener);
        this.updateTasksExecutor.execute(new Runnable(){

            @Override
            public void run() {
                listener.postAdded();
            }
        });
    }

    @Override
    public void submitStateUpdateTask(final String source, final ClusterStateUpdateTask updateTask) {
        if (!this.lifecycle.started()) {
            return;
        }
        this.updateTasksExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ClusterState newClusterState;
                if (!InternalClusterService.this.lifecycle.started()) {
                    InternalClusterService.this.logger.debug("processing [{}]: ignoring, cluster_service not started", source);
                    return;
                }
                InternalClusterService.this.logger.debug("processing [{}]: execute", source);
                ClusterState previousClusterState = InternalClusterService.this.clusterState;
                try {
                    newClusterState = updateTask.execute(previousClusterState);
                }
                catch (Exception e) {
                    StringBuilder sb = new StringBuilder("failed to execute cluster state update, state:\nversion [").append(previousClusterState.version()).append("], source [").append(source).append("]\n");
                    sb.append(previousClusterState.nodes().prettyPrint());
                    sb.append(previousClusterState.routingTable().prettyPrint());
                    sb.append(previousClusterState.readOnlyRoutingNodes().prettyPrint());
                    InternalClusterService.this.logger.warn(sb.toString(), e, new Object[0]);
                    return;
                }
                if (previousClusterState == newClusterState) {
                    InternalClusterService.this.logger.debug("processing [{}]: no change in cluster_state", source);
                    if (updateTask instanceof ProcessedClusterStateUpdateTask) {
                        ((ProcessedClusterStateUpdateTask)updateTask).clusterStateProcessed(newClusterState);
                    }
                    return;
                }
                try {
                    String summary;
                    ClusterState.Builder builder;
                    if (newClusterState.nodes().localNodeMaster()) {
                        builder = ClusterState.builder().state(newClusterState).version(newClusterState.version() + 1L);
                        if (previousClusterState.routingTable() != newClusterState.routingTable()) {
                            builder.routingTable(RoutingTable.builder().routingTable(newClusterState.routingTable()).version(newClusterState.routingTable().version() + 1L));
                        }
                        if (previousClusterState.metaData() != newClusterState.metaData()) {
                            builder.metaData(MetaData.builder().metaData(newClusterState.metaData()).version(newClusterState.metaData().version() + 1L));
                        }
                        newClusterState = builder.build();
                    } else if (previousClusterState.blocks().hasGlobalBlock(Discovery.NO_MASTER_BLOCK) && !newClusterState.blocks().hasGlobalBlock(Discovery.NO_MASTER_BLOCK)) {
                        builder = ClusterState.builder().state(newClusterState);
                        builder.routingTable(RoutingTable.builder().routingTable(newClusterState.routingTable()));
                        builder.metaData(MetaData.builder().metaData(newClusterState.metaData()));
                        newClusterState = builder.build();
                        InternalClusterService.this.logger.debug("got first state from fresh master [{}]", newClusterState.nodes().masterNodeId());
                    } else if (newClusterState.version() < previousClusterState.version()) {
                        InternalClusterService.this.logger.debug("got old cluster state [" + newClusterState.version() + "<" + previousClusterState.version() + "] from source [" + source + "], ignoring", new Object[0]);
                        return;
                    }
                    if (InternalClusterService.this.logger.isTraceEnabled()) {
                        StringBuilder sb = new StringBuilder("cluster state updated:\nversion [").append(newClusterState.version()).append("], source [").append(source).append("]\n");
                        sb.append(newClusterState.nodes().prettyPrint());
                        sb.append(newClusterState.routingTable().prettyPrint());
                        sb.append(newClusterState.readOnlyRoutingNodes().prettyPrint());
                        InternalClusterService.this.logger.trace(sb.toString(), new Object[0]);
                    } else if (InternalClusterService.this.logger.isDebugEnabled()) {
                        InternalClusterService.this.logger.debug("cluster state updated, version [{}], source [{}]", newClusterState.version(), source);
                    }
                    ClusterChangedEvent clusterChangedEvent = new ClusterChangedEvent(source, newClusterState, previousClusterState);
                    final DiscoveryNodes.Delta nodesDelta = clusterChangedEvent.nodesDelta();
                    if (nodesDelta.hasChanges() && InternalClusterService.this.logger.isInfoEnabled() && (summary = nodesDelta.shortSummary()).length() > 0) {
                        InternalClusterService.this.logger.info("{}, reason: {}", summary, source);
                    }
                    for (DiscoveryNode node : nodesDelta.addedNodes()) {
                        if (!InternalClusterService.this.nodeRequiresConnection(node)) continue;
                        try {
                            InternalClusterService.this.transportService.connectToNode(node);
                        }
                        catch (Exception e) {
                            InternalClusterService.this.logger.warn("failed to connect to node [" + node + "]", e, new Object[0]);
                        }
                    }
                    if (newClusterState.nodes().localNodeMaster()) {
                        InternalClusterService.this.discoveryService.publish(newClusterState);
                    }
                    InternalClusterService.this.clusterState = newClusterState;
                    for (ClusterStateListener listener : InternalClusterService.this.priorityClusterStateListeners) {
                        listener.clusterChanged(clusterChangedEvent);
                    }
                    for (ClusterStateListener listener : InternalClusterService.this.clusterStateListeners) {
                        listener.clusterChanged(clusterChangedEvent);
                    }
                    for (ClusterStateListener listener : InternalClusterService.this.lastClusterStateListeners) {
                        listener.clusterChanged(clusterChangedEvent);
                    }
                    if (!nodesDelta.removedNodes().isEmpty()) {
                        InternalClusterService.this.threadPool.generic().execute(new Runnable(){

                            @Override
                            public void run() {
                                for (DiscoveryNode node : nodesDelta.removedNodes()) {
                                    InternalClusterService.this.transportService.disconnectFromNode(node);
                                }
                            }
                        });
                    }
                    if (updateTask instanceof ProcessedClusterStateUpdateTask) {
                        ((ProcessedClusterStateUpdateTask)updateTask).clusterStateProcessed(newClusterState);
                    }
                    InternalClusterService.this.logger.debug("processing [{}]: done applying updated cluster_state", source);
                }
                catch (Exception e) {
                    StringBuilder sb = new StringBuilder("failed to apply updated cluster state:\nversion [").append(newClusterState.version()).append("], source [").append(source).append("]\n");
                    sb.append(newClusterState.nodes().prettyPrint());
                    sb.append(newClusterState.routingTable().prettyPrint());
                    sb.append(newClusterState.readOnlyRoutingNodes().prettyPrint());
                    InternalClusterService.this.logger.warn(sb.toString(), e, new Object[0]);
                }
            }
        });
    }

    private boolean nodeRequiresConnection(DiscoveryNode node) {
        return this.localNode().shouldConnectTo(node);
    }

    private static class OffMasterRunnable
    implements Runnable {
        private final LocalNodeMasterListener listener;

        private OffMasterRunnable(LocalNodeMasterListener listener) {
            this.listener = listener;
        }

        @Override
        public void run() {
            this.listener.offMaster();
        }
    }

    private static class OnMasterRunnable
    implements Runnable {
        private final LocalNodeMasterListener listener;

        private OnMasterRunnable(LocalNodeMasterListener listener) {
            this.listener = listener;
        }

        @Override
        public void run() {
            this.listener.onMaster();
        }
    }

    private static class LocalNodeMasterListeners
    implements ClusterStateListener {
        private final List<LocalNodeMasterListener> listeners = new CopyOnWriteArrayList<LocalNodeMasterListener>();
        private final ThreadPool threadPool;
        private volatile boolean master = false;

        private LocalNodeMasterListeners(ThreadPool threadPool) {
            this.threadPool = threadPool;
        }

        @Override
        public void clusterChanged(ClusterChangedEvent event) {
            if (!this.master && event.localNodeMaster()) {
                this.master = true;
                for (LocalNodeMasterListener listener : this.listeners) {
                    Executor executor = this.threadPool.executor(listener.executorName());
                    executor.execute(new OnMasterRunnable(listener));
                }
                return;
            }
            if (this.master && !event.localNodeMaster()) {
                this.master = false;
                for (LocalNodeMasterListener listener : this.listeners) {
                    Executor executor = this.threadPool.executor(listener.executorName());
                    executor.execute(new OffMasterRunnable(listener));
                }
            }
        }

        private void add(LocalNodeMasterListener listener) {
            this.listeners.add(listener);
        }

        private void remove(LocalNodeMasterListener listener) {
            this.listeners.remove(listener);
        }

        private void clear() {
            this.listeners.clear();
        }
    }

    private class ReconnectToNodes
    implements Runnable {
        private ConcurrentMap<DiscoveryNode, Integer> failureCount = ConcurrentCollections.newConcurrentMap();

        private ReconnectToNodes() {
        }

        @Override
        public void run() {
            for (DiscoveryNode node : InternalClusterService.this.clusterState.nodes()) {
                if (InternalClusterService.this.lifecycle.stoppedOrClosed()) {
                    return;
                }
                if (!InternalClusterService.this.nodeRequiresConnection(node) || !InternalClusterService.this.clusterState.nodes().nodeExists(node.id()) || InternalClusterService.this.transportService.nodeConnected(node)) continue;
                try {
                    InternalClusterService.this.transportService.connectToNode(node);
                }
                catch (Exception e) {
                    if (InternalClusterService.this.lifecycle.stoppedOrClosed()) {
                        return;
                    }
                    if (!InternalClusterService.this.clusterState.nodes().nodeExists(node.id())) continue;
                    Integer nodeFailureCount = (Integer)this.failureCount.get(node);
                    nodeFailureCount = nodeFailureCount == null ? Integer.valueOf(1) : Integer.valueOf(nodeFailureCount + 1);
                    if (nodeFailureCount % 6 == 0) {
                        nodeFailureCount = 0;
                        InternalClusterService.this.logger.warn("failed to reconnect to node {}", e, node);
                    }
                    this.failureCount.put(node, nodeFailureCount);
                }
            }
            DiscoveryNodes nodes = InternalClusterService.this.clusterState.nodes();
            Iterator failedNodesIt = this.failureCount.keySet().iterator();
            while (failedNodesIt.hasNext()) {
                DiscoveryNode failedNode = (DiscoveryNode)failedNodesIt.next();
                if (nodes.nodeExists(failedNode.id())) continue;
                failedNodesIt.remove();
            }
            if (InternalClusterService.this.lifecycle.started()) {
                InternalClusterService.this.reconnectToNodes = InternalClusterService.this.threadPool.schedule(InternalClusterService.this.reconnectInterval, "generic", this);
            }
        }
    }

    class NotifyTimeout
    implements Runnable {
        final TimeoutClusterStateListener listener;
        final TimeValue timeout;
        ScheduledFuture future;

        NotifyTimeout(TimeoutClusterStateListener listener, TimeValue timeout) {
            this.listener = listener;
            this.timeout = timeout;
        }

        public void cancel() {
            this.future.cancel(false);
        }

        @Override
        public void run() {
            if (this.future.isCancelled()) {
                return;
            }
            if (InternalClusterService.this.lifecycle.stoppedOrClosed()) {
                this.listener.onClose();
            } else {
                this.listener.onTimeout(this.timeout);
            }
        }
    }
}

