/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.common.Bytes;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.BytesStream;
import org.elasticsearch.common.io.stream.StreamOutput;

public class BytesStreamOutput
extends StreamOutput
implements BytesStream {
    protected byte[] buf;
    protected int count;

    public BytesStreamOutput() {
        this(1024);
    }

    public BytesStreamOutput(int size) {
        this.buf = new byte[size];
    }

    @Override
    public boolean seekPositionSupported() {
        return true;
    }

    @Override
    public long position() throws IOException {
        return this.count;
    }

    @Override
    public void seek(long position) throws IOException {
        if (position > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException();
        }
        this.count = (int)position;
    }

    @Override
    public void writeByte(byte b) throws IOException {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Bytes.oversize(newcount, 1));
        }
        this.buf[this.count] = b;
        this.count = newcount;
    }

    public void skip(int length) {
        int newcount = this.count + length;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Bytes.oversize(newcount, 1));
        }
        this.count = newcount;
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        int newcount = this.count + length;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Bytes.oversize(newcount, 1));
        }
        System.arraycopy(b, offset, this.buf, this.count, length);
        this.count = newcount;
    }

    public void seek(int seekTo) {
        this.count = seekTo;
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public BytesReference bytes() {
        return new BytesArray(this.buf, 0, this.count);
    }

    public int size() {
        return this.count;
    }
}

