/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.network;

import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.os.OsUtils;

public abstract class NetworkUtils {
    private static final ESLogger logger = Loggers.getLogger(NetworkUtils.class);
    public static final String IPv4_SETTING = "java.net.preferIPv4Stack";
    public static final String IPv6_SETTING = "java.net.preferIPv6Addresses";
    public static final String NON_LOOPBACK_ADDRESS = "non_loopback_address";
    private static final InetAddress localAddress;

    public static Boolean defaultReuseAddress() {
        return OsUtils.WINDOWS ? null : Boolean.valueOf(true);
    }

    public static boolean isIPv4() {
        return System.getProperty(IPv4_SETTING) != null && System.getProperty(IPv4_SETTING).equals("true");
    }

    public static InetAddress getIPv4Localhost() throws UnknownHostException {
        return NetworkUtils.getLocalhost(StackType.IPv4);
    }

    public static InetAddress getIPv6Localhost() throws UnknownHostException {
        return NetworkUtils.getLocalhost(StackType.IPv6);
    }

    public static InetAddress getLocalAddress() {
        return localAddress;
    }

    public static InetAddress getLocalhost(StackType ip_version) throws UnknownHostException {
        if (ip_version == StackType.IPv4) {
            return InetAddress.getByName("127.0.0.1");
        }
        return InetAddress.getByName("::1");
    }

    public static boolean canBindToMcastAddress() {
        return OsUtils.LINUX || OsUtils.SOLARIS || OsUtils.HP;
    }

    public static InetAddress getFirstNonLoopbackAddress(StackType ip_version) throws SocketException {
        InetAddress address = null;
        Enumeration<NetworkInterface> intfs = NetworkInterface.getNetworkInterfaces();
        ArrayList<NetworkInterface> intfsList = Lists.newArrayList();
        while (intfs.hasMoreElements()) {
            intfsList.add(intfs.nextElement());
        }
        try {
            final Method getIndexMethod = NetworkInterface.class.getDeclaredMethod("getIndex", new Class[0]);
            getIndexMethod.setAccessible(true);
            Collections.sort(intfsList, new Comparator<NetworkInterface>(){

                @Override
                public int compare(NetworkInterface o1, NetworkInterface o2) {
                    try {
                        return (Integer)getIndexMethod.invoke((Object)o1, new Object[0]) - (Integer)getIndexMethod.invoke((Object)o2, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new ElasticSearchIllegalStateException("failed to fetch index of network interface");
                    }
                }
            });
        }
        catch (Exception e) {
            // empty catch block
        }
        for (NetworkInterface intf : intfsList) {
            try {
                if (!intf.isUp()) continue;
                if (intf.isLoopback()) {
                }
            }
            catch (Exception e) {}
            continue;
            address = NetworkUtils.getFirstNonLoopbackAddress(intf, ip_version);
            if (address == null) continue;
            return address;
        }
        return null;
    }

    public static InetAddress getFirstNonLoopbackAddress(NetworkInterface intf, StackType ipVersion) throws SocketException {
        if (intf == null) {
            throw new IllegalArgumentException("Network interface pointer is null");
        }
        Enumeration<InetAddress> addresses = intf.getInetAddresses();
        while (addresses.hasMoreElements()) {
            InetAddress address = addresses.nextElement();
            if (address.isLoopbackAddress() || (!(address instanceof Inet4Address) || ipVersion != StackType.IPv4) && (!(address instanceof Inet6Address) || ipVersion != StackType.IPv6)) continue;
            return address;
        }
        return null;
    }

    public static boolean interfaceHasIPAddresses(NetworkInterface intf, StackType ipVersion) throws SocketException, UnknownHostException {
        boolean supportsVersion = false;
        if (intf != null) {
            Enumeration<InetAddress> addresses = intf.getInetAddresses();
            while (addresses != null && addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if ((!(address instanceof Inet4Address) || ipVersion != StackType.IPv4) && (!(address instanceof Inet6Address) || ipVersion != StackType.IPv6)) continue;
                supportsVersion = true;
                break;
            }
        } else {
            throw new UnknownHostException("network interface not found");
        }
        return supportsVersion;
    }

    public static StackType getIpStackType() {
        boolean isIPv4StackAvailable = NetworkUtils.isStackAvailable(true);
        boolean isIPv6StackAvailable = NetworkUtils.isStackAvailable(false);
        if (isIPv4StackAvailable && !isIPv6StackAvailable) {
            return StackType.IPv4;
        }
        if (isIPv6StackAvailable && !isIPv4StackAvailable) {
            return StackType.IPv6;
        }
        if (isIPv4StackAvailable && isIPv6StackAvailable) {
            if (Boolean.getBoolean(IPv4_SETTING)) {
                return StackType.IPv4;
            }
            if (Boolean.getBoolean(IPv6_SETTING)) {
                return StackType.IPv6;
            }
            return StackType.IPv6;
        }
        return StackType.Unknown;
    }

    public static boolean isStackAvailable(boolean ipv4) {
        Collection<InetAddress> allAddrs = NetworkUtils.getAllAvailableAddresses();
        for (InetAddress addr : allAddrs) {
            if ((!ipv4 || !(addr instanceof Inet4Address)) && (ipv4 || !(addr instanceof Inet6Address))) continue;
            return true;
        }
        return false;
    }

    public static List<NetworkInterface> getAllAvailableInterfaces() throws SocketException {
        ArrayList<NetworkInterface> allInterfaces = new ArrayList<NetworkInterface>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface intf = interfaces.nextElement();
            allInterfaces.add(intf);
            Enumeration<NetworkInterface> subInterfaces = intf.getSubInterfaces();
            if (subInterfaces == null || !subInterfaces.hasMoreElements()) continue;
            while (subInterfaces.hasMoreElements()) {
                allInterfaces.add(subInterfaces.nextElement());
            }
        }
        return allInterfaces;
    }

    public static Collection<InetAddress> getAllAvailableAddresses() {
        HashSet<InetAddress> retval = new HashSet<InetAddress>();
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            if (en == null) {
                return retval;
            }
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> addrs = intf.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    retval.add(addrs.nextElement());
                }
            }
        }
        catch (SocketException e) {
            logger.warn("Failed to derive all available interfaces", e, new Object[0]);
        }
        return retval;
    }

    private NetworkUtils() {
    }

    static {
        InetAddress localAddressX = null;
        try {
            localAddressX = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            logger.trace("Failed to find local host", e, new Object[0]);
        }
        localAddress = localAddressX;
    }

    public static enum StackType {
        IPv4,
        IPv6,
        Unknown;

    }
}

