/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen.membership;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.zen.DiscoveryNodesProvider;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.FutureTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class MembershipAction
extends AbstractComponent {
    private final TransportService transportService;
    private final DiscoveryNodesProvider nodesProvider;
    private final MembershipListener listener;

    public MembershipAction(Settings settings, TransportService transportService, DiscoveryNodesProvider nodesProvider, MembershipListener listener) {
        super(settings);
        this.transportService = transportService;
        this.nodesProvider = nodesProvider;
        this.listener = listener;
        transportService.registerHandler("discovery/zen/join", new JoinRequestRequestHandler());
        transportService.registerHandler("discovery/zen/join/validate", new ValidateJoinRequestRequestHandler());
        transportService.registerHandler("discovery/zen/leave", new LeaveRequestRequestHandler());
    }

    public void close() {
        this.transportService.removeHandler("discovery/zen/join");
        this.transportService.removeHandler("discovery/zen/join/validate");
        this.transportService.removeHandler("discovery/zen/leave");
    }

    public void sendLeaveRequest(DiscoveryNode masterNode, DiscoveryNode node) {
        this.transportService.sendRequest(node, "discovery/zen/leave", new LeaveRequest(masterNode), EmptyTransportResponseHandler.INSTANCE_SAME);
    }

    public void sendLeaveRequestBlocking(DiscoveryNode masterNode, DiscoveryNode node, TimeValue timeout) throws ElasticSearchException {
        this.transportService.submitRequest(masterNode, "discovery/zen/leave", new LeaveRequest(node), EmptyTransportResponseHandler.INSTANCE_SAME).txGet(timeout.millis(), TimeUnit.MILLISECONDS);
    }

    public void sendJoinRequest(DiscoveryNode masterNode, DiscoveryNode node) {
        this.transportService.sendRequest(masterNode, "discovery/zen/join", new JoinRequest(node, false), EmptyTransportResponseHandler.INSTANCE_SAME);
    }

    public ClusterState sendJoinRequestBlocking(DiscoveryNode masterNode, DiscoveryNode node, TimeValue timeout) throws ElasticSearchException {
        return this.transportService.submitRequest((DiscoveryNode)masterNode, (String)"discovery/zen/join", (TransportRequest)new JoinRequest((DiscoveryNode)node, (boolean)true), new FutureTransportResponseHandler<JoinResponse>(){

            @Override
            public JoinResponse newInstance() {
                return new JoinResponse();
            }
        }).txGet((long)timeout.millis(), (TimeUnit)TimeUnit.MILLISECONDS).clusterState;
    }

    public void sendValidateJoinRequestBlocking(DiscoveryNode node, ClusterState clusterState, TimeValue timeout) throws ElasticSearchException {
        this.transportService.submitRequest(node, "discovery/zen/join/validate", new ValidateJoinRequest(clusterState), EmptyTransportResponseHandler.INSTANCE_SAME).txGet(timeout.millis(), TimeUnit.MILLISECONDS);
    }

    private class LeaveRequestRequestHandler
    extends BaseTransportRequestHandler<LeaveRequest> {
        static final String ACTION = "discovery/zen/leave";

        private LeaveRequestRequestHandler() {
        }

        @Override
        public LeaveRequest newInstance() {
            return new LeaveRequest();
        }

        @Override
        public void messageReceived(LeaveRequest request, TransportChannel channel) throws Exception {
            MembershipAction.this.listener.onLeave(request.node);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }

        @Override
        public String executor() {
            return "generic";
        }
    }

    static class LeaveRequest
    extends TransportRequest {
        private DiscoveryNode node;

        private LeaveRequest() {
        }

        private LeaveRequest(DiscoveryNode node) {
            this.node = node;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.node = DiscoveryNode.readNode(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.node.writeTo(out);
        }
    }

    private class ValidateJoinRequestRequestHandler
    extends BaseTransportRequestHandler<ValidateJoinRequest> {
        static final String ACTION = "discovery/zen/join/validate";

        private ValidateJoinRequestRequestHandler() {
        }

        @Override
        public ValidateJoinRequest newInstance() {
            return new ValidateJoinRequest();
        }

        @Override
        public void messageReceived(ValidateJoinRequest request, TransportChannel channel) throws Exception {
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }

        @Override
        public String executor() {
            return "generic";
        }
    }

    class ValidateJoinRequest
    extends TransportRequest {
        ClusterState clusterState;

        ValidateJoinRequest() {
        }

        ValidateJoinRequest(ClusterState clusterState) {
            this.clusterState = clusterState;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.clusterState = ClusterState.Builder.readFrom(in, MembershipAction.this.nodesProvider.nodes().localNode());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            ClusterState.Builder.writeTo(this.clusterState, out);
        }
    }

    private class JoinRequestRequestHandler
    extends BaseTransportRequestHandler<JoinRequest> {
        static final String ACTION = "discovery/zen/join";

        private JoinRequestRequestHandler() {
        }

        @Override
        public JoinRequest newInstance() {
            return new JoinRequest();
        }

        @Override
        public void messageReceived(JoinRequest request, TransportChannel channel) throws Exception {
            ClusterState clusterState = MembershipAction.this.listener.onJoin(request.node);
            if (request.withClusterState) {
                channel.sendResponse(new JoinResponse(clusterState));
            } else {
                channel.sendResponse(TransportResponse.Empty.INSTANCE);
            }
        }

        @Override
        public String executor() {
            return "generic";
        }
    }

    class JoinResponse
    extends TransportResponse {
        ClusterState clusterState;

        JoinResponse() {
        }

        JoinResponse(ClusterState clusterState) {
            this.clusterState = clusterState;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.clusterState = ClusterState.Builder.readFrom(in, MembershipAction.this.nodesProvider.nodes().localNode());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            ClusterState.Builder.writeTo(this.clusterState, out);
        }
    }

    static class JoinRequest
    extends TransportRequest {
        DiscoveryNode node;
        boolean withClusterState;

        private JoinRequest() {
        }

        private JoinRequest(DiscoveryNode node, boolean withClusterState) {
            this.node = node;
            this.withClusterState = withClusterState;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.node = DiscoveryNode.readNode(in);
            this.withClusterState = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.node.writeTo(out);
            out.writeBoolean(this.withClusterState);
        }
    }

    public static interface MembershipListener {
        public ClusterState onJoin(DiscoveryNode var1);

        public void onLeave(DiscoveryNode var1);
    }
}

