/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen.ping.multicast;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.CachedStreamInput;
import org.elasticsearch.common.io.stream.CachedStreamOutput;
import org.elasticsearch.common.io.stream.HandlesStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.discovery.zen.DiscoveryNodesProvider;
import org.elasticsearch.discovery.zen.ping.ZenPing;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class MulticastZenPing
extends AbstractLifecycleComponent<ZenPing>
implements ZenPing {
    private static final byte[] INTERNAL_HEADER = new byte[]{1, 9, 8, 4};
    private final String address;
    private final int port;
    private final String group;
    private final int bufferSize;
    private final int ttl;
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final ClusterName clusterName;
    private final NetworkService networkService;
    private final boolean pingEnabled;
    private volatile DiscoveryNodesProvider nodesProvider;
    private volatile Receiver receiver;
    private volatile Thread receiverThread;
    private MulticastSocket multicastSocket;
    private DatagramPacket datagramPacketSend;
    private DatagramPacket datagramPacketReceive;
    private final AtomicInteger pingIdGenerator = new AtomicInteger();
    private final Map<Integer, ConcurrentMap<DiscoveryNode, ZenPing.PingResponse>> receivedResponses = ConcurrentCollections.newConcurrentMap();
    private final Object sendMutex = new Object();
    private final Object receiveMutex = new Object();

    public MulticastZenPing(ThreadPool threadPool, TransportService transportService, ClusterName clusterName) {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS, threadPool, transportService, clusterName, new NetworkService(ImmutableSettings.Builder.EMPTY_SETTINGS));
    }

    public MulticastZenPing(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterName clusterName, NetworkService networkService) {
        super(settings);
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.clusterName = clusterName;
        this.networkService = networkService;
        this.address = this.componentSettings.get("address");
        this.port = this.componentSettings.getAsInt("port", 54328);
        this.group = this.componentSettings.get("group", "224.2.2.4");
        this.bufferSize = this.componentSettings.getAsInt("buffer_size", 2048);
        this.ttl = this.componentSettings.getAsInt("ttl", 3);
        this.pingEnabled = this.componentSettings.getAsBoolean("ping.enabled", true);
        this.logger.debug("using group [{}], with port [{}], ttl [{}], and address [{}]", this.group, this.port, this.ttl, this.address);
        this.transportService.registerHandler("discovery/zen/multicast", new MulticastPingResponseRequestHandler());
    }

    @Override
    public void setNodesProvider(DiscoveryNodesProvider nodesProvider) {
        if (this.lifecycle.started()) {
            throw new ElasticSearchIllegalStateException("Can't set nodes provider when started");
        }
        this.nodesProvider = nodesProvider;
    }

    @Override
    protected void doStart() throws ElasticSearchException {
        block6: {
            try {
                this.datagramPacketReceive = new DatagramPacket(new byte[this.bufferSize], this.bufferSize);
                this.datagramPacketSend = new DatagramPacket(new byte[this.bufferSize], this.bufferSize, InetAddress.getByName(this.group), this.port);
            }
            catch (Exception e) {
                this.logger.warn("disabled, failed to setup multicast (datagram) discovery : {}", e.getMessage());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("disabled, failed to setup multicast (datagram) discovery", e, new Object[0]);
                }
                return;
            }
            InetAddress multicastInterface = null;
            try {
                MulticastSocket multicastSocket = new MulticastSocket(this.port);
                multicastSocket.setTimeToLive(this.ttl);
                multicastInterface = this.networkService.resolvePublishHostAddress(this.address);
                multicastSocket.setInterface(multicastInterface);
                multicastSocket.joinGroup(InetAddress.getByName(this.group));
                multicastSocket.setReceiveBufferSize(this.bufferSize);
                multicastSocket.setSendBufferSize(this.bufferSize);
                multicastSocket.setSoTimeout(60000);
                this.multicastSocket = multicastSocket;
                this.receiver = new Receiver();
                this.receiverThread = EsExecutors.daemonThreadFactory(this.settings, "discovery#multicast#receiver").newThread(this.receiver);
                this.receiverThread.start();
            }
            catch (Exception e) {
                this.datagramPacketReceive = null;
                this.datagramPacketSend = null;
                if (this.multicastSocket != null) {
                    this.multicastSocket.close();
                    this.multicastSocket = null;
                }
                this.logger.warn("disabled, failed to setup multicast discovery on port [{}], [{}]: {}", this.port, multicastInterface, e.getMessage());
                if (!this.logger.isDebugEnabled()) break block6;
                this.logger.debug("disabled, failed to setup multicast discovery on {}", e, multicastInterface);
            }
        }
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        if (this.receiver != null) {
            this.receiver.stop();
        }
        if (this.receiverThread != null) {
            this.receiverThread.interrupt();
        }
        if (this.multicastSocket != null) {
            this.multicastSocket.close();
            this.multicastSocket = null;
        }
    }

    @Override
    protected void doClose() throws ElasticSearchException {
    }

    public ZenPing.PingResponse[] pingAndWait(TimeValue timeout) {
        final AtomicReference response = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        this.ping(new ZenPing.PingListener(){

            @Override
            public void onPing(ZenPing.PingResponse[] pings) {
                response.set(pings);
                latch.countDown();
            }
        }, timeout);
        try {
            latch.await();
            return (ZenPing.PingResponse[])response.get();
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public void ping(final ZenPing.PingListener listener, TimeValue timeout) {
        if (!this.pingEnabled) {
            this.threadPool.generic().execute(new Runnable(){

                @Override
                public void run() {
                    listener.onPing(new ZenPing.PingResponse[0]);
                }
            });
            return;
        }
        final int id = this.pingIdGenerator.incrementAndGet();
        this.receivedResponses.put(id, ConcurrentCollections.newConcurrentMap());
        this.sendPingRequest(id);
        this.threadPool.schedule(TimeValue.timeValueMillis(timeout.millis() / 2L), "generic", new Runnable(){

            @Override
            public void run() {
                try {
                    MulticastZenPing.this.sendPingRequest(id);
                }
                catch (Exception e) {
                    MulticastZenPing.this.logger.warn("[{}] failed to send second ping request", e, id);
                }
            }
        });
        this.threadPool.schedule(timeout, "generic", new Runnable(){

            @Override
            public void run() {
                ConcurrentMap responses = (ConcurrentMap)MulticastZenPing.this.receivedResponses.remove(id);
                listener.onPing(responses.values().toArray(new ZenPing.PingResponse[responses.size()]));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPingRequest(int id) {
        if (this.multicastSocket == null) {
            return;
        }
        Object object = this.sendMutex;
        synchronized (object) {
            CachedStreamOutput.Entry cachedEntry = CachedStreamOutput.popEntry();
            try {
                StreamOutput out = cachedEntry.handles();
                out.writeBytes(INTERNAL_HEADER);
                Version.writeVersion(Version.CURRENT, out);
                out.writeInt(id);
                this.clusterName.writeTo(out);
                this.nodesProvider.nodes().localNode().writeTo(out);
                out.close();
                this.datagramPacketSend.setData(cachedEntry.bytes().bytes().copyBytesArray().toBytes());
                this.multicastSocket.send(this.datagramPacketSend);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("[{}] sending ping request", id);
                }
            }
            catch (Exception e) {
                if (this.lifecycle.stoppedOrClosed()) {
                    return;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("failed to send multicast ping request", e, new Object[0]);
                } else {
                    this.logger.warn("failed to send multicast ping request: {}", ExceptionsHelper.detailedMessage(e));
                }
            }
            finally {
                CachedStreamOutput.pushEntry(cachedEntry);
            }
        }
    }

    private class Receiver
    implements Runnable {
        private volatile boolean running = true;

        private Receiver() {
        }

        public void stop() {
            this.running = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                try {
                    int id = -1;
                    DiscoveryNode requestingNodeX = null;
                    ClusterName clusterName = null;
                    Map<String, Object> externalPingData = null;
                    XContentType xContentType = null;
                    Object object = MulticastZenPing.this.receiveMutex;
                    synchronized (object) {
                        block18: {
                            try {
                                MulticastZenPing.this.multicastSocket.receive(MulticastZenPing.this.datagramPacketReceive);
                            }
                            catch (SocketTimeoutException ignore) {
                                continue;
                            }
                            catch (Exception e) {
                                if (this.running) {
                                    MulticastZenPing.this.logger.warn("failed to receive packet", e, new Object[0]);
                                }
                                continue;
                            }
                            try {
                                boolean internal = false;
                                if (MulticastZenPing.this.datagramPacketReceive.getLength() > 4) {
                                    int counter;
                                    for (counter = 0; counter < INTERNAL_HEADER.length && MulticastZenPing.this.datagramPacketReceive.getData()[MulticastZenPing.this.datagramPacketReceive.getOffset() + counter] == INTERNAL_HEADER[counter]; ++counter) {
                                    }
                                    if (counter == INTERNAL_HEADER.length) {
                                        internal = true;
                                    }
                                }
                                if (internal) {
                                    HandlesStreamInput input = CachedStreamInput.cachedHandles(new BytesStreamInput(MulticastZenPing.this.datagramPacketReceive.getData(), MulticastZenPing.this.datagramPacketReceive.getOffset() + INTERNAL_HEADER.length, MulticastZenPing.this.datagramPacketReceive.getLength(), true));
                                    Version version = Version.readVersion(input);
                                    ((StreamInput)input).setVersion(version);
                                    id = ((StreamInput)input).readInt();
                                    clusterName = ClusterName.readClusterName(input);
                                    requestingNodeX = DiscoveryNode.readNode(input);
                                    break block18;
                                }
                                xContentType = XContentFactory.xContentType(MulticastZenPing.this.datagramPacketReceive.getData(), MulticastZenPing.this.datagramPacketReceive.getOffset(), MulticastZenPing.this.datagramPacketReceive.getLength());
                                if (xContentType != null) {
                                    externalPingData = XContentFactory.xContent(xContentType).createParser(MulticastZenPing.this.datagramPacketReceive.getData(), MulticastZenPing.this.datagramPacketReceive.getOffset(), MulticastZenPing.this.datagramPacketReceive.getLength()).mapAndClose();
                                    break block18;
                                }
                                throw new ElasticSearchIllegalStateException("failed multicast message, probably message from previous version");
                            }
                            catch (Exception e) {
                                MulticastZenPing.this.logger.warn("failed to read requesting data from {}", e, MulticastZenPing.this.datagramPacketReceive.getSocketAddress());
                                continue;
                            }
                        }
                    }
                    if (externalPingData != null) {
                        this.handleExternalPingRequest(externalPingData, xContentType, MulticastZenPing.this.datagramPacketReceive.getSocketAddress());
                        continue;
                    }
                    this.handleNodePingRequest(id, requestingNodeX, clusterName);
                }
                catch (Exception e) {
                    MulticastZenPing.this.logger.warn("unexpected exception in multicast receiver", e, new Object[0]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleExternalPingRequest(Map<String, Object> externalPingData, XContentType contentType, SocketAddress remoteAddress) {
            String clusterName;
            if (externalPingData.containsKey("response")) {
                MulticastZenPing.this.logger.trace("got an external ping response (ignoring) from {}, content {}", remoteAddress, externalPingData);
                return;
            }
            if (MulticastZenPing.this.multicastSocket == null) {
                MulticastZenPing.this.logger.debug("can't send ping response, no socket, from {}, content {}", remoteAddress, externalPingData);
                return;
            }
            Map request = (Map)externalPingData.get("request");
            if (request == null) {
                MulticastZenPing.this.logger.warn("malformed external ping request, no 'request' element from {}, content {}", remoteAddress, externalPingData);
                return;
            }
            String string = request.containsKey("cluster_name") ? request.get("cluster_name").toString() : (clusterName = request.containsKey("clusterName") ? request.get("clusterName").toString() : null);
            if (clusterName == null) {
                MulticastZenPing.this.logger.warn("malformed external ping request, missing 'cluster_name' element within request, from {}, content {}", remoteAddress, externalPingData);
                return;
            }
            if (!clusterName.equals(MulticastZenPing.this.clusterName.value())) {
                MulticastZenPing.this.logger.trace("got request for cluster_name {}, but our cluster_name is {}, from {}, content {}", clusterName, MulticastZenPing.this.clusterName.value(), remoteAddress, externalPingData);
                return;
            }
            if (MulticastZenPing.this.logger.isTraceEnabled()) {
                MulticastZenPing.this.logger.trace("got external ping request from {}, content {}", remoteAddress, externalPingData);
            }
            try {
                DiscoveryNode localNode = MulticastZenPing.this.nodesProvider.nodes().localNode();
                XContentBuilder builder = XContentFactory.contentBuilder(contentType);
                builder.startObject().startObject("response");
                builder.field("cluster_name", MulticastZenPing.this.clusterName.value());
                builder.startObject("version").field("number", Version.CURRENT.number()).field("snapshot_build", (Object)Version.CURRENT.snapshot).endObject();
                builder.field("transport_address", localNode.address().toString());
                if (MulticastZenPing.this.nodesProvider.nodeService() != null) {
                    for (Map.Entry attr : MulticastZenPing.this.nodesProvider.nodeService().attributes().entrySet()) {
                        builder.field((String)attr.getKey(), (String)attr.getValue());
                    }
                }
                builder.startObject("attributes");
                for (Map.Entry attr : localNode.attributes().entrySet()) {
                    builder.field((String)attr.getKey(), (String)attr.getValue());
                }
                builder.endObject();
                builder.endObject().endObject();
                Object object = MulticastZenPing.this.sendMutex;
                synchronized (object) {
                    BytesReference bytes = builder.bytes();
                    MulticastZenPing.this.datagramPacketSend.setData(bytes.array(), bytes.arrayOffset(), bytes.length());
                    MulticastZenPing.this.multicastSocket.send(MulticastZenPing.this.datagramPacketSend);
                    if (MulticastZenPing.this.logger.isTraceEnabled()) {
                        MulticastZenPing.this.logger.trace("sending external ping response {}", builder.string());
                    }
                }
            }
            catch (Exception e) {
                MulticastZenPing.this.logger.warn("failed to send external multicast response", e, new Object[0]);
            }
        }

        private void handleNodePingRequest(int id, DiscoveryNode requestingNodeX, ClusterName clusterName) {
            if (!MulticastZenPing.this.pingEnabled) {
                return;
            }
            DiscoveryNodes discoveryNodes = MulticastZenPing.this.nodesProvider.nodes();
            final DiscoveryNode requestingNode = requestingNodeX;
            if (requestingNode.id().equals(discoveryNodes.localNodeId())) {
                return;
            }
            if (!clusterName.equals(MulticastZenPing.this.clusterName)) {
                if (MulticastZenPing.this.logger.isTraceEnabled()) {
                    MulticastZenPing.this.logger.trace("[{}] received ping_request from [{}], but wrong cluster_name [{}], expected [{}], ignoring", id, requestingNode, clusterName, MulticastZenPing.this.clusterName);
                }
                return;
            }
            if (!discoveryNodes.localNode().shouldConnectTo(requestingNode)) {
                if (MulticastZenPing.this.logger.isTraceEnabled()) {
                    MulticastZenPing.this.logger.trace("[{}] received ping_request from [{}], both are client nodes, ignoring", id, requestingNode, clusterName);
                }
                return;
            }
            final MulticastPingResponse multicastPingResponse = new MulticastPingResponse();
            multicastPingResponse.id = id;
            multicastPingResponse.pingResponse = new ZenPing.PingResponse(discoveryNodes.localNode(), discoveryNodes.masterNode(), clusterName);
            if (MulticastZenPing.this.logger.isTraceEnabled()) {
                MulticastZenPing.this.logger.trace("[{}] received ping_request from [{}], sending {}", id, requestingNode, multicastPingResponse.pingResponse);
            }
            if (!MulticastZenPing.this.transportService.nodeConnected(requestingNode)) {
                MulticastZenPing.this.threadPool.generic().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MulticastZenPing.this.transportService.connectToNode(requestingNode);
                            MulticastZenPing.this.transportService.sendRequest(requestingNode, "discovery/zen/multicast", multicastPingResponse, new EmptyTransportResponseHandler("same"){

                                @Override
                                public void handleException(TransportException exp) {
                                    MulticastZenPing.this.logger.warn("failed to receive confirmation on sent ping response to [{}]", exp, requestingNode);
                                }
                            });
                        }
                        catch (Exception e) {
                            MulticastZenPing.this.logger.warn("failed to connect to requesting node {}", e, requestingNode);
                        }
                    }
                });
            } else {
                MulticastZenPing.this.transportService.sendRequest(requestingNode, "discovery/zen/multicast", multicastPingResponse, new EmptyTransportResponseHandler("same"){

                    @Override
                    public void handleException(TransportException exp) {
                        MulticastZenPing.this.logger.warn("failed to receive confirmation on sent ping response to [{}]", exp, requestingNode);
                    }
                });
            }
        }
    }

    static class MulticastPingResponse
    extends TransportRequest {
        int id;
        ZenPing.PingResponse pingResponse;

        MulticastPingResponse() {
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.id = in.readInt();
            this.pingResponse = ZenPing.PingResponse.readPingResponse(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeInt(this.id);
            this.pingResponse.writeTo(out);
        }
    }

    class MulticastPingResponseRequestHandler
    extends BaseTransportRequestHandler<MulticastPingResponse> {
        static final String ACTION = "discovery/zen/multicast";

        MulticastPingResponseRequestHandler() {
        }

        @Override
        public MulticastPingResponse newInstance() {
            return new MulticastPingResponse();
        }

        @Override
        public void messageReceived(MulticastPingResponse request, TransportChannel channel) throws Exception {
            ConcurrentMap responses;
            if (MulticastZenPing.this.logger.isTraceEnabled()) {
                MulticastZenPing.this.logger.trace("[{}] received {}", request.id, request.pingResponse);
            }
            if ((responses = (ConcurrentMap)MulticastZenPing.this.receivedResponses.get(request.id)) == null) {
                MulticastZenPing.this.logger.warn("received ping response {} with no matching id [{}]", request.pingResponse, request.id);
            } else {
                responses.put(request.pingResponse.target(), request.pingResponse);
            }
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }
}

