/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.query.parser.resident;

import java.util.concurrent.TimeUnit;
import org.apache.lucene.queryParser.QueryParserSettings;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.query.parser.QueryParserCache;
import org.elasticsearch.index.settings.IndexSettings;

public class ResidentQueryParserCache
extends AbstractIndexComponent
implements QueryParserCache {
    private final Cache<QueryParserSettings, Query> cache;
    private volatile int maxSize;
    private volatile TimeValue expire;

    @Inject
    public ResidentQueryParserCache(Index index, @IndexSettings Settings indexSettings) {
        super(index, indexSettings);
        this.maxSize = indexSettings.getAsInt("index.cache.field.max_size", this.componentSettings.getAsInt("max_size", 100));
        this.expire = indexSettings.getAsTime("index.cache.field.expire", this.componentSettings.getAsTime("expire", null));
        this.logger.debug("using [resident] query cache with max_size [{}], expire [{}]", this.maxSize, this.expire);
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder().maximumSize(this.maxSize);
        if (this.expire != null) {
            cacheBuilder.expireAfterAccess(this.expire.nanos(), TimeUnit.NANOSECONDS);
        }
        this.cache = cacheBuilder.build();
    }

    @Override
    public Query get(QueryParserSettings queryString) {
        return this.cache.getIfPresent(queryString);
    }

    @Override
    public void put(QueryParserSettings queryString, Query query) {
        this.cache.put(queryString, query);
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }

    @Override
    public void close() throws ElasticSearchException {
        this.cache.invalidateAll();
    }
}

