/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.strings;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparator;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.FieldDataType;

public class StringValFieldDataComparator
extends FieldComparator {
    private final String fieldName;
    protected final FieldDataCache fieldDataCache;
    protected FieldData currentFieldData;
    private String[] values;
    private String bottom;

    public StringValFieldDataComparator(int numHits, String fieldName, FieldDataCache fieldDataCache) {
        this.fieldName = fieldName;
        this.fieldDataCache = fieldDataCache;
        this.values = new String[numHits];
    }

    @Override
    public int compare(int slot1, int slot2) {
        String val1 = this.values[slot1];
        String val2 = this.values[slot2];
        if (val1 == null) {
            if (val2 == null) {
                return 0;
            }
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        return val1.compareTo(val2);
    }

    @Override
    public int compareBottom(int doc) {
        String val2 = this.currentFieldData.stringValue(doc);
        if (this.bottom == null) {
            if (val2 == null) {
                return 0;
            }
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        return this.bottom.compareTo(val2);
    }

    @Override
    public void copy(int slot, int doc) {
        this.values[slot] = this.currentFieldData.stringValue(doc);
    }

    @Override
    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.currentFieldData = this.fieldDataCache.cache(FieldDataType.DefaultTypes.STRING, reader, this.fieldName);
    }

    @Override
    public void setBottom(int bottom) {
        this.bottom = this.values[bottom];
    }

    public Comparable value(int slot) {
        return this.values[slot];
    }
}

