/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Arrays;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.elasticsearch.common.bytes.BytesReference;

public class ParsedDocument {
    private final String uid;
    private final String id;
    private final String type;
    private final String routing;
    private final long timestamp;
    private final long ttl;
    private final List<Document> documents;
    private final Analyzer analyzer;
    private final BytesReference source;
    private boolean mappingsModified;
    private String parent;

    public ParsedDocument(String uid, String id, String type, String routing, long timestamp, long ttl, Document document, Analyzer analyzer, BytesReference source, boolean mappingsModified) {
        this(uid, id, type, routing, timestamp, ttl, Arrays.asList(document), analyzer, source, mappingsModified);
    }

    public ParsedDocument(String uid, String id, String type, String routing, long timestamp, long ttl, List<Document> documents, Analyzer analyzer, BytesReference source, boolean mappingsModified) {
        this.uid = uid;
        this.id = id;
        this.type = type;
        this.routing = routing;
        this.timestamp = timestamp;
        this.ttl = ttl;
        this.documents = documents;
        this.source = source;
        this.analyzer = analyzer;
        this.mappingsModified = mappingsModified;
    }

    public String uid() {
        return this.uid;
    }

    public String id() {
        return this.id;
    }

    public String type() {
        return this.type;
    }

    public String routing() {
        return this.routing;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public long ttl() {
        return this.ttl;
    }

    public Document rootDoc() {
        return this.documents.get(this.documents.size() - 1);
    }

    public List<Document> docs() {
        return this.documents;
    }

    public Analyzer analyzer() {
        return this.analyzer;
    }

    public BytesReference source() {
        return this.source;
    }

    public ParsedDocument parent(String parent) {
        this.parent = parent;
        return this;
    }

    public String parent() {
        return this.parent;
    }

    public boolean mappingsModified() {
        return this.mappingsModified;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Document ").append("uid[").append(this.uid).append("] doc [").append(this.documents).append("]");
        return sb.toString();
    }
}

