/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.NumericTokenStream;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.internal.AllFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;

public abstract class NumberFieldMapper<T extends Number>
extends AbstractFieldMapper<T>
implements AllFieldMapper.IncludeInAll {
    protected int precisionStep;
    protected String fuzzyFactor;
    protected double dFuzzyFactor;
    protected Boolean includeInAll;
    protected Explicit<Boolean> ignoreMalformed;
    private ThreadLocal<NumericTokenStream> tokenStream = new ThreadLocal<NumericTokenStream>(){

        @Override
        protected NumericTokenStream initialValue() {
            return new NumericTokenStream(NumberFieldMapper.this.precisionStep);
        }
    };

    protected NumberFieldMapper(FieldMapper.Names names, int precisionStep, @Nullable String fuzzyFactor, Field.Index index, Field.Store store, float boost, boolean omitNorms, FieldInfo.IndexOptions indexOptions, Explicit<Boolean> ignoreMalformed, NamedAnalyzer indexAnalyzer, NamedAnalyzer searchAnalyzer) {
        super(names, index, store, Field.TermVector.NO, boost, boost != 1.0f || omitNorms, indexOptions, indexAnalyzer, searchAnalyzer);
        this.precisionStep = precisionStep <= 0 || precisionStep >= this.maxPrecisionStep() ? Integer.MAX_VALUE : precisionStep;
        this.fuzzyFactor = fuzzyFactor;
        this.dFuzzyFactor = this.parseFuzzyFactor(fuzzyFactor);
        this.ignoreMalformed = ignoreMalformed;
    }

    protected double parseFuzzyFactor(String fuzzyFactor) {
        if (fuzzyFactor == null) {
            return 1.0;
        }
        return Double.parseDouble(fuzzyFactor);
    }

    @Override
    public void includeInAll(Boolean includeInAll) {
        if (includeInAll != null) {
            this.includeInAll = includeInAll;
        }
    }

    @Override
    public void includeInAllIfNotSet(Boolean includeInAll) {
        if (includeInAll != null && this.includeInAll == null) {
            this.includeInAll = includeInAll;
        }
    }

    protected abstract int maxPrecisionStep();

    public int precisionStep() {
        return this.precisionStep;
    }

    @Override
    protected Fieldable parseCreateField(ParseContext context) throws IOException {
        RuntimeException e;
        try {
            return this.innerParseCreateField(context);
        }
        catch (IllegalArgumentException e1) {
            e = e1;
        }
        catch (MapperParsingException e2) {
            e = e2;
        }
        if (this.ignoreMalformed.value().booleanValue()) {
            return null;
        }
        throw e;
    }

    protected abstract Fieldable innerParseCreateField(ParseContext var1) throws IOException;

    @Override
    public boolean useFieldQueryWithQueryString() {
        return true;
    }

    @Override
    public Query fieldQuery(String value, @Nullable QueryParseContext context) {
        return this.rangeQuery(value, value, true, true, context);
    }

    @Override
    public abstract Query fuzzyQuery(String var1, String var2, int var3, int var4);

    @Override
    public abstract Query fuzzyQuery(String var1, double var2, int var4, int var5);

    @Override
    public Filter fieldFilter(String value, @Nullable QueryParseContext context) {
        return this.rangeFilter(value, value, true, true, context);
    }

    @Override
    public abstract Query rangeQuery(String var1, String var2, boolean var3, boolean var4, @Nullable QueryParseContext var5);

    @Override
    public abstract Filter rangeFilter(String var1, String var2, boolean var3, boolean var4, @Nullable QueryParseContext var5);

    public abstract Filter rangeFilter(FieldDataCache var1, String var2, String var3, boolean var4, boolean var5, @Nullable QueryParseContext var6);

    @Override
    public Object valueForSearch(Fieldable field) {
        return this.value(field);
    }

    @Override
    public String valueAsString(Fieldable field) {
        Number num = (Number)this.value(field);
        return num == null ? null : num.toString();
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            NumberFieldMapper nfmMergeWith = (NumberFieldMapper)mergeWith;
            this.precisionStep = nfmMergeWith.precisionStep;
            this.includeInAll = nfmMergeWith.includeInAll;
            this.fuzzyFactor = nfmMergeWith.fuzzyFactor;
            this.dFuzzyFactor = this.parseFuzzyFactor(nfmMergeWith.fuzzyFactor);
            if (nfmMergeWith.ignoreMalformed.explicit()) {
                this.ignoreMalformed = nfmMergeWith.ignoreMalformed;
            }
        }
    }

    @Override
    public void close() {
        this.tokenStream.remove();
    }

    @Override
    public abstract FieldDataType fieldDataType();

    protected NumericTokenStream popCachedStream() {
        return this.tokenStream.get();
    }

    @Override
    protected void doXContentBody(XContentBuilder builder) throws IOException {
        super.doXContentBody(builder);
        if (this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", (Object)this.ignoreMalformed.value());
        }
    }

    public static abstract class CustomNumericField
    extends AbstractField {
        protected final NumberFieldMapper mapper;

        public CustomNumericField(NumberFieldMapper mapper, byte[] value) {
            this.mapper = mapper;
            this.name = mapper.names().indexName();
            this.fieldsData = value;
            this.isIndexed = mapper.indexed();
            this.isTokenized = mapper.indexed();
            this.indexOptions = FieldInfo.IndexOptions.DOCS_ONLY;
            this.omitNorms = mapper.omitNorms();
            if (value != null) {
                this.isStored = true;
                this.isBinary = true;
                this.binaryLength = value.length;
                this.binaryOffset = 0;
            }
            this.setStoreTermVector(Field.TermVector.NO);
        }

        @Override
        public String stringValue() {
            return null;
        }

        @Override
        public Reader readerValue() {
            return null;
        }

        public abstract String numericAsString();
    }

    public static abstract class Builder<T extends Builder, Y extends NumberFieldMapper>
    extends AbstractFieldMapper.Builder<T, Y> {
        protected int precisionStep = 4;
        protected String fuzzyFactor = Defaults.FUZZY_FACTOR;
        private Boolean ignoreMalformed;

        public Builder(String name) {
            super(name);
            this.index = Defaults.INDEX;
            this.omitNorms = true;
            this.indexOptions = Defaults.INDEX_OPTIONS;
        }

        @Override
        public T store(Field.Store store) {
            return (T)((Builder)super.store(store));
        }

        @Override
        public T boost(float boost) {
            return (T)((Builder)super.boost(boost));
        }

        @Override
        public T indexName(String indexName) {
            return (T)((Builder)super.indexName(indexName));
        }

        @Override
        public T includeInAll(Boolean includeInAll) {
            return (T)((Builder)super.includeInAll(includeInAll));
        }

        public T precisionStep(int precisionStep) {
            this.precisionStep = precisionStep;
            return (T)((Builder)this.builder);
        }

        public T fuzzyFactor(String fuzzyFactor) {
            this.fuzzyFactor = fuzzyFactor;
            return (T)((Builder)this.builder);
        }

        public T ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return (T)((Builder)this.builder);
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(context.indexSettings().getAsBoolean("index.mapping.ignore_malformed", Defaults.IGNORE_MALFORMED.value()), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final int PRECISION_STEP = 4;
        public static final Field.Index INDEX = Field.Index.NOT_ANALYZED;
        public static final boolean OMIT_NORMS = true;
        public static final FieldInfo.IndexOptions INDEX_OPTIONS = FieldInfo.IndexOptions.DOCS_ONLY;
        public static final String FUZZY_FACTOR = null;
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit<Boolean>(false, false);
    }
}

