/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.object;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.Filter;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.lucene.search.TermFilter;
import org.elasticsearch.common.lucene.uid.UidField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapperListener;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ObjectMapperListener;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StrictDynamicMappingException;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.internal.AllFieldMapper;
import org.elasticsearch.index.mapper.internal.TypeFieldMapper;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.mapper.multifield.MultiFieldMapper;
import org.elasticsearch.index.mapper.object.ArrayValueMapperParser;
import org.elasticsearch.index.mapper.object.RootObjectMapper;

public class ObjectMapper
implements Mapper,
AllFieldMapper.IncludeInAll {
    public static final String CONTENT_TYPE = "object";
    public static final String NESTED_CONTENT_TYPE = "nested";
    private final String name;
    private final String fullPath;
    private final boolean enabled;
    private final Nested nested;
    private final String nestedTypePath;
    private final Filter nestedTypeFilter;
    private final Dynamic dynamic;
    private final ContentPath.Type pathType;
    private Boolean includeInAll;
    private volatile ImmutableMap<String, Mapper> mappers = ImmutableMap.of();
    private final Object mutex = new Object();

    ObjectMapper(String name, String fullPath, boolean enabled, Nested nested, Dynamic dynamic, ContentPath.Type pathType, Map<String, Mapper> mappers) {
        this.name = name;
        this.fullPath = fullPath;
        this.enabled = enabled;
        this.nested = nested;
        this.dynamic = dynamic;
        this.pathType = pathType;
        if (mappers != null) {
            this.mappers = ImmutableMap.copyOf(mappers);
        }
        this.nestedTypePath = "__" + fullPath;
        this.nestedTypeFilter = new TermFilter(TypeFieldMapper.TERM_FACTORY.createTerm(this.nestedTypePath));
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void includeInAll(Boolean includeInAll) {
        if (includeInAll == null) {
            return;
        }
        this.includeInAll = includeInAll;
        for (Mapper mapper : this.mappers.values()) {
            if (!(mapper instanceof AllFieldMapper.IncludeInAll)) continue;
            ((AllFieldMapper.IncludeInAll)mapper).includeInAll(includeInAll);
        }
    }

    @Override
    public void includeInAllIfNotSet(Boolean includeInAll) {
        if (this.includeInAll == null) {
            this.includeInAll = includeInAll;
        }
        for (Mapper mapper : this.mappers.values()) {
            if (!(mapper instanceof AllFieldMapper.IncludeInAll)) continue;
            ((AllFieldMapper.IncludeInAll)mapper).includeInAllIfNotSet(includeInAll);
        }
    }

    public Nested nested() {
        return this.nested;
    }

    public Filter nestedTypeFilter() {
        return this.nestedTypeFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMapper putMapper(Mapper mapper) {
        if (mapper instanceof AllFieldMapper.IncludeInAll) {
            ((AllFieldMapper.IncludeInAll)mapper).includeInAllIfNotSet(this.includeInAll);
        }
        Object object = this.mutex;
        synchronized (object) {
            this.mappers = MapBuilder.newMapBuilder(this.mappers).put(mapper.name(), mapper).immutableMap();
        }
        return this;
    }

    @Override
    public void traverse(FieldMapperListener fieldMapperListener) {
        for (Mapper mapper : this.mappers.values()) {
            mapper.traverse(fieldMapperListener);
        }
    }

    @Override
    public void traverse(ObjectMapperListener objectMapperListener) {
        objectMapperListener.objectMapper(this);
        for (Mapper mapper : this.mappers.values()) {
            mapper.traverse(objectMapperListener);
        }
    }

    public String fullPath() {
        return this.fullPath;
    }

    public String nestedTypePath() {
        return this.nestedTypePath;
    }

    public final Dynamic dynamic() {
        return this.dynamic;
    }

    protected boolean allowValue() {
        return true;
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        if (!this.enabled) {
            context.parser().skipChildren();
            return;
        }
        XContentParser parser = context.parser();
        String currentFieldName = parser.currentName();
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_NULL) {
            return;
        }
        if (token.isValue() && !this.allowValue()) {
            throw new MapperParsingException("object mapping for [" + this.name + "] tried to parse as object, but found a concrete value");
        }
        Document restoreDoc = null;
        if (this.nested.isNested()) {
            Document nestedDoc = new Document();
            Fieldable uidField = context.doc().getFieldable(UidFieldMapper.NAME);
            if (uidField != null) {
                if (uidField.stringValue() != null) {
                    nestedDoc.add(new Field(UidFieldMapper.NAME, uidField.stringValue(), Field.Store.NO, Field.Index.NOT_ANALYZED));
                } else {
                    nestedDoc.add(new Field(UidFieldMapper.NAME, ((UidField)uidField).uid(), Field.Store.NO, Field.Index.NOT_ANALYZED));
                }
            }
            nestedDoc.add(new Field("_type", this.nestedTypePath, Field.Store.NO, Field.Index.NOT_ANALYZED));
            restoreDoc = context.switchDoc(nestedDoc);
            context.addDoc(nestedDoc);
        }
        ContentPath.Type origPathType = context.path().pathType();
        context.path().pathType(this.pathType);
        if (token == XContentParser.Token.END_OBJECT) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.START_OBJECT) {
            token = parser.nextToken();
        }
        while (token != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.START_OBJECT) {
                this.serializeObject(context, currentFieldName);
            } else if (token == XContentParser.Token.START_ARRAY) {
                this.serializeArray(context, currentFieldName);
            } else if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
            } else if (token == XContentParser.Token.VALUE_NULL) {
                this.serializeNullValue(context, currentFieldName);
            } else {
                if (token == null) {
                    throw new MapperParsingException("object mapping for [" + this.name + "] tried to parse as object, but got EOF, has a concrete value been provided to it?");
                }
                if (token.isValue()) {
                    this.serializeValue(context, currentFieldName, token);
                }
            }
            token = parser.nextToken();
        }
        context.path().pathType(origPathType);
        if (this.nested.isNested()) {
            Document nestedDoc = context.switchDoc(restoreDoc);
            if (this.nested.isIncludeInParent()) {
                for (Fieldable field : nestedDoc.getFields()) {
                    if (field.name().equals(UidFieldMapper.NAME) || field.name().equals("_type")) continue;
                    context.doc().add(field);
                }
            }
            if (this.nested.isIncludeInRoot() && (!this.nested.isIncludeInParent() || context.doc() != context.rootDoc())) {
                for (Fieldable field : nestedDoc.getFields()) {
                    if (field.name().equals(UidFieldMapper.NAME) || field.name().equals("_type")) continue;
                    context.rootDoc().add(field);
                }
            }
        }
    }

    private void serializeNullValue(ParseContext context, String lastFieldName) throws IOException {
        Mapper mapper = this.mappers.get(lastFieldName);
        if (mapper != null) {
            mapper.parse(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeObject(ParseContext context, String currentFieldName) throws IOException {
        if (currentFieldName == null) {
            throw new MapperParsingException("object mapping [" + this.name + "] trying to serialize an object with no field associated with it, current value [" + context.parser().textOrNull() + "]");
        }
        context.path().add(currentFieldName);
        Mapper objectMapper = this.mappers.get(currentFieldName);
        if (objectMapper != null) {
            objectMapper.parse(context);
        } else {
            Dynamic dynamic = this.dynamic;
            if (dynamic == null) {
                dynamic = context.root().dynamic();
            }
            if (dynamic == Dynamic.STRICT) {
                throw new StrictDynamicMappingException(this.fullPath, currentFieldName);
            }
            if (dynamic == Dynamic.TRUE) {
                boolean newMapper = false;
                Object object = this.mutex;
                synchronized (object) {
                    objectMapper = this.mappers.get(currentFieldName);
                    if (objectMapper == null) {
                        newMapper = true;
                        context.path().remove();
                        Mapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, CONTENT_TYPE);
                        if (builder == null) {
                            builder = ((Builder)((Builder)MapperBuilders.object(currentFieldName).enabled(true)).dynamic(dynamic)).pathType(this.pathType);
                        }
                        Mapper.BuilderContext builderContext = new Mapper.BuilderContext(context.indexSettings(), context.path());
                        objectMapper = builder.build(builderContext);
                        this.putMapper(objectMapper);
                        context.path().add(currentFieldName);
                        context.setMappingsModified();
                    }
                }
                if (newMapper) {
                    objectMapper.traverse(context.newFieldMappers());
                    objectMapper.traverse(context.newObjectMappers());
                }
                objectMapper.parse(context);
            } else {
                context.parser().skipChildren();
            }
        }
        context.path().remove();
    }

    private void serializeArray(ParseContext context, String lastFieldName) throws IOException {
        String arrayFieldName = lastFieldName;
        Mapper mapper = this.mappers.get(lastFieldName);
        if (mapper != null && mapper instanceof ArrayValueMapperParser) {
            mapper.parse(context);
        } else {
            XContentParser.Token token;
            XContentParser parser = context.parser();
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                if (token == XContentParser.Token.START_OBJECT) {
                    this.serializeObject(context, lastFieldName);
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    this.serializeArray(context, lastFieldName);
                    continue;
                }
                if (token == XContentParser.Token.FIELD_NAME) {
                    lastFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.VALUE_NULL) {
                    this.serializeNullValue(context, lastFieldName);
                    continue;
                }
                if (token == null) {
                    throw new MapperParsingException("object mapping for [" + this.name + "] with array for [" + arrayFieldName + "] tried to parse as array, but got EOF, is there a mismatch in types for the same field?");
                }
                this.serializeValue(context, lastFieldName, token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeValue(ParseContext context, String currentFieldName, XContentParser.Token token) throws IOException {
        if (currentFieldName == null) {
            throw new MapperParsingException("object mapping [" + this.name + "] trying to serialize a value with no field associated with it, current value [" + context.parser().textOrNull() + "]");
        }
        Mapper mapper = this.mappers.get(currentFieldName);
        if (mapper != null) {
            mapper.parse(context);
            return;
        }
        Dynamic dynamic = this.dynamic;
        if (dynamic == null) {
            dynamic = context.root().dynamic();
        }
        if (dynamic == Dynamic.STRICT) {
            throw new StrictDynamicMappingException(this.fullPath, currentFieldName);
        }
        if (dynamic == Dynamic.FALSE) {
            return;
        }
        boolean newMapper = false;
        Object object = this.mutex;
        synchronized (object) {
            mapper = this.mappers.get(currentFieldName);
            if (mapper == null) {
                newMapper = true;
                Mapper.BuilderContext builderContext = new Mapper.BuilderContext(context.indexSettings(), context.path());
                if (token == XContentParser.Token.VALUE_STRING) {
                    String text;
                    Mapper.Builder builder;
                    boolean resolved = false;
                    if (!resolved && (builder = context.root().findTemplateBuilder(context, currentFieldName, "string", null)) != null) {
                        mapper = builder.build(builderContext);
                        resolved = true;
                    }
                    if (!resolved && context.parser().textLength() == 0) {
                        return;
                    }
                    if (!resolved && context.root().dateDetection() && ((text = context.parser().text()).contains(":") || text.contains("-") || text.contains("/"))) {
                        for (FormatDateTimeFormatter dateTimeFormatter : context.root().dynamicDateTimeFormatters()) {
                            try {
                                dateTimeFormatter.parser().parseMillis(text);
                                Mapper.Builder builder2 = context.root().findTemplateBuilder(context, currentFieldName, "date");
                                if (builder2 == null) {
                                    builder2 = MapperBuilders.dateField(currentFieldName).dateTimeFormatter(dateTimeFormatter);
                                }
                                mapper = builder2.build(builderContext);
                                resolved = true;
                                break;
                            }
                            catch (Exception e) {
                            }
                        }
                    }
                    if (!resolved && context.root().numericDetection()) {
                        Mapper.Builder builder3;
                        text = context.parser().text();
                        try {
                            Long.parseLong(text);
                            builder3 = context.root().findTemplateBuilder(context, currentFieldName, "long");
                            if (builder3 == null) {
                                builder3 = MapperBuilders.longField(currentFieldName);
                            }
                            mapper = builder3.build(builderContext);
                            resolved = true;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (!resolved) {
                            try {
                                Double.parseDouble(text);
                                builder3 = context.root().findTemplateBuilder(context, currentFieldName, "double");
                                if (builder3 == null) {
                                    builder3 = MapperBuilders.doubleField(currentFieldName);
                                }
                                mapper = builder3.build(builderContext);
                                resolved = true;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                    if (!resolved) {
                        builder = context.root().findTemplateBuilder(context, currentFieldName, "string");
                        if (builder == null) {
                            builder = MapperBuilders.stringField(currentFieldName);
                        }
                        mapper = builder.build(builderContext);
                    }
                } else if (token == XContentParser.Token.VALUE_NUMBER) {
                    XContentParser.NumberType numberType = context.parser().numberType();
                    if (numberType == XContentParser.NumberType.INT) {
                        if (context.parser().estimatedNumberType()) {
                            Mapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, "long");
                            if (builder == null) {
                                builder = MapperBuilders.longField(currentFieldName);
                            }
                            mapper = builder.build(builderContext);
                        } else {
                            Mapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, "integer");
                            if (builder == null) {
                                builder = MapperBuilders.integerField(currentFieldName);
                            }
                            mapper = builder.build(builderContext);
                        }
                    } else if (numberType == XContentParser.NumberType.LONG) {
                        Mapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, "long");
                        if (builder == null) {
                            builder = MapperBuilders.longField(currentFieldName);
                        }
                        mapper = builder.build(builderContext);
                    } else if (numberType == XContentParser.NumberType.FLOAT) {
                        if (context.parser().estimatedNumberType()) {
                            Mapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, "double");
                            if (builder == null) {
                                builder = MapperBuilders.doubleField(currentFieldName);
                            }
                            mapper = builder.build(builderContext);
                        } else {
                            Mapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, "float");
                            if (builder == null) {
                                builder = MapperBuilders.floatField(currentFieldName);
                            }
                            mapper = builder.build(builderContext);
                        }
                    } else if (numberType == XContentParser.NumberType.DOUBLE) {
                        Mapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, "double");
                        if (builder == null) {
                            builder = MapperBuilders.doubleField(currentFieldName);
                        }
                        mapper = builder.build(builderContext);
                    }
                } else if (token == XContentParser.Token.VALUE_BOOLEAN) {
                    Mapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, "boolean");
                    if (builder == null) {
                        builder = MapperBuilders.booleanField(currentFieldName);
                    }
                    mapper = builder.build(builderContext);
                } else if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                    Mapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, "binary");
                    if (builder == null) {
                        builder = MapperBuilders.binaryField(currentFieldName);
                    }
                    mapper = builder.build(builderContext);
                } else {
                    Mapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, null);
                    if (builder != null) {
                        mapper = builder.build(builderContext);
                    } else {
                        throw new ElasticSearchIllegalStateException("Can't handle serializing a dynamic type with content token [" + (Object)((Object)token) + "] and field name [" + currentFieldName + "]");
                    }
                }
                this.putMapper(mapper);
                context.setMappingsModified();
            }
        }
        if (newMapper) {
            mapper.traverse(context.newFieldMappers());
        }
        mapper.parse(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        if (!(mergeWith instanceof ObjectMapper)) {
            mergeContext.addConflict("Can't merge a non object mapping [" + mergeWith.name() + "] with an object mapping [" + this.name() + "]");
            return;
        }
        ObjectMapper mergeWithObject = (ObjectMapper)mergeWith;
        this.doMerge(mergeWithObject, mergeContext);
        ArrayList<Mapper> mappersToTraverse = new ArrayList<Mapper>();
        Object object = this.mutex;
        synchronized (object) {
            for (Mapper mergeWithMapper : mergeWithObject.mappers.values()) {
                Mapper mergeIntoMapper = this.mappers.get(mergeWithMapper.name());
                if (mergeIntoMapper == null) {
                    if (mergeContext.mergeFlags().simulate()) continue;
                    this.putMapper(mergeWithMapper);
                    mappersToTraverse.add(mergeWithMapper);
                    continue;
                }
                if (mergeWithMapper instanceof MultiFieldMapper && !(mergeIntoMapper instanceof MultiFieldMapper)) {
                    MultiFieldMapper mergeWithMultiField = (MultiFieldMapper)mergeWithMapper;
                    mergeWithMultiField.merge(mergeIntoMapper, mergeContext);
                    if (mergeContext.mergeFlags().simulate()) continue;
                    this.putMapper(mergeWithMultiField);
                    for (Mapper mapper : mergeWithMultiField.mappers().values()) {
                        mappersToTraverse.add(mapper);
                    }
                    continue;
                }
                mergeIntoMapper.merge(mergeWithMapper, mergeContext);
            }
        }
        for (Mapper mapper : mappersToTraverse) {
            mapper.traverse(mergeContext.newFieldMappers());
            mapper.traverse(mergeContext.newObjectMappers());
        }
    }

    protected void doMerge(ObjectMapper mergeWith, MergeContext mergeContext) {
    }

    @Override
    public void close() {
        for (Mapper mapper : this.mappers.values()) {
            mapper.close();
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.toXContent(builder, params, null, Mapper.EMPTY_ARRAY);
        return builder;
    }

    public void toXContent(XContentBuilder builder, ToXContent.Params params, ToXContent custom, Mapper ... additionalMappers) throws IOException {
        builder.startObject(this.name);
        if (this.nested.isNested()) {
            builder.field("type", NESTED_CONTENT_TYPE);
            if (this.nested.isIncludeInParent()) {
                builder.field("include_in_parent", true);
            }
            if (this.nested.isIncludeInRoot()) {
                builder.field("include_in_root", true);
            }
        } else if (this.mappers.isEmpty()) {
            builder.field("type", CONTENT_TYPE);
        }
        if (this instanceof RootObjectMapper) {
            if (this.dynamic != Dynamic.TRUE) {
                builder.field("dynamic", this.dynamic.name().toLowerCase());
            }
        } else if (this.dynamic != Defaults.DYNAMIC) {
            builder.field("dynamic", this.dynamic.name().toLowerCase());
        }
        if (!this.enabled) {
            builder.field("enabled", this.enabled);
        }
        if (this.pathType != Defaults.PATH_TYPE) {
            builder.field("path", this.pathType.name().toLowerCase());
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        }
        if (custom != null) {
            custom.toXContent(builder, params);
        }
        this.doXContent(builder, params);
        TreeMap<String, Mapper> sortedMappers = new TreeMap<String, Mapper>(this.mappers);
        for (Mapper mapper : sortedMappers.values()) {
            if (!(mapper instanceof InternalMapper)) continue;
            mapper.toXContent(builder, params);
        }
        if (additionalMappers != null && additionalMappers.length > 0) {
            TreeMap<String, Mapper> additionalSortedMappers = new TreeMap<String, Mapper>();
            for (Mapper mapper : additionalMappers) {
                additionalSortedMappers.put(mapper.name(), mapper);
            }
            for (Mapper mapper : additionalSortedMappers.values()) {
                mapper.toXContent(builder, params);
            }
        }
        if (!this.mappers.isEmpty()) {
            builder.startObject("properties");
            for (Mapper mapper : sortedMappers.values()) {
                if (mapper instanceof InternalMapper) continue;
                mapper.toXContent(builder, params);
            }
            builder.endObject();
        }
        builder.endObject();
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Map<String, Object> objectNode = node;
            Builder builder = this.createBuilder(name);
            boolean nested = false;
            boolean nestedIncludeInParent = false;
            boolean nestedIncludeInRoot = false;
            for (Map.Entry<String, Object> entry : objectNode.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("dynamic")) {
                    String value = fieldNode.toString();
                    if (value.equalsIgnoreCase("strict")) {
                        builder.dynamic(Dynamic.STRICT);
                        continue;
                    }
                    builder.dynamic(XContentMapValues.nodeBooleanValue(fieldNode) ? Dynamic.TRUE : Dynamic.FALSE);
                    continue;
                }
                if (fieldName.equals("type")) {
                    String type = fieldNode.toString();
                    if (type.equals(ObjectMapper.CONTENT_TYPE)) {
                        builder.nested = Nested.NO;
                        continue;
                    }
                    if (type.equals(ObjectMapper.NESTED_CONTENT_TYPE)) {
                        nested = true;
                        continue;
                    }
                    throw new MapperParsingException("Trying to parse an object but has a different type [" + type + "] for [" + name + "]");
                }
                if (fieldName.equals("include_in_parent")) {
                    nestedIncludeInParent = XContentMapValues.nodeBooleanValue(fieldNode);
                    continue;
                }
                if (fieldName.equals("include_in_root")) {
                    nestedIncludeInRoot = XContentMapValues.nodeBooleanValue(fieldNode);
                    continue;
                }
                if (fieldName.equals("enabled")) {
                    builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode));
                    continue;
                }
                if (fieldName.equals("path")) {
                    builder.pathType(TypeParsers.parsePathType(name, fieldNode.toString()));
                    continue;
                }
                if (fieldName.equals("properties")) {
                    this.parseProperties(builder, (Map)fieldNode, parserContext);
                    continue;
                }
                if (fieldName.equals("include_in_all")) {
                    builder.includeInAll(XContentMapValues.nodeBooleanValue(fieldNode));
                    continue;
                }
                this.processField(builder, fieldName, fieldNode);
            }
            if (nested) {
                builder.nested = Nested.newNested(nestedIncludeInParent, nestedIncludeInRoot);
            }
            return builder;
        }

        private void parseProperties(Builder objBuilder, Map<String, Object> propsNode, Mapper.TypeParser.ParserContext parserContext) {
            for (Map.Entry<String, Object> entry : propsNode.entrySet()) {
                String type;
                String propName = entry.getKey();
                Map propNode = (Map)entry.getValue();
                Object typeNode = propNode.get("type");
                if (typeNode != null) {
                    type = typeNode.toString();
                } else if (propNode.get("properties") != null) {
                    type = ObjectMapper.CONTENT_TYPE;
                } else if (propNode.get("fields") != null) {
                    type = "multi_field";
                } else if (propNode.size() == 1 && propNode.get("enabled") != null) {
                    type = ObjectMapper.CONTENT_TYPE;
                } else {
                    throw new MapperParsingException("No type specified for property [" + propName + "]");
                }
                Mapper.TypeParser typeParser = parserContext.typeParser(type);
                if (typeParser == null) {
                    throw new MapperParsingException("No handler for type [" + type + "] declared on field [" + propName + "]");
                }
                objBuilder.add(typeParser.parse(propName, propNode, parserContext));
            }
        }

        protected Builder createBuilder(String name) {
            return MapperBuilders.object(name);
        }

        protected void processField(Builder builder, String fieldName, Object fieldNode) {
        }
    }

    public static class Builder<T extends Builder, Y extends ObjectMapper>
    extends Mapper.Builder<T, Y> {
        protected boolean enabled = true;
        protected Nested nested = Defaults.NESTED;
        protected Dynamic dynamic = Defaults.DYNAMIC;
        protected ContentPath.Type pathType = Defaults.PATH_TYPE;
        protected Boolean includeInAll;
        protected final List<Mapper.Builder> mappersBuilders = Lists.newArrayList();

        public Builder(String name) {
            super(name);
            this.builder = this;
        }

        public T enabled(boolean enabled) {
            this.enabled = enabled;
            return (T)((Builder)this.builder);
        }

        public T dynamic(Dynamic dynamic) {
            this.dynamic = dynamic;
            return (T)((Builder)this.builder);
        }

        public T nested(Nested nested) {
            this.nested = nested;
            return (T)((Builder)this.builder);
        }

        public T pathType(ContentPath.Type pathType) {
            this.pathType = pathType;
            return (T)((Builder)this.builder);
        }

        public T includeInAll(boolean includeInAll) {
            this.includeInAll = includeInAll;
            return (T)((Builder)this.builder);
        }

        public T add(Mapper.Builder builder) {
            this.mappersBuilders.add(builder);
            return (T)((Builder)this.builder);
        }

        @Override
        public Y build(Mapper.BuilderContext context) {
            ContentPath.Type origPathType = context.path().pathType();
            context.path().pathType(this.pathType);
            context.path().add(this.name);
            HashMap<String, Mapper> mappers = new HashMap<String, Mapper>();
            for (Mapper.Builder builder : this.mappersBuilders) {
                Object mapper = builder.build(context);
                mappers.put(mapper.name(), (Mapper)mapper);
            }
            context.path().pathType(origPathType);
            context.path().remove();
            ObjectMapper objectMapper = this.createMapper(this.name, context.path().fullPathAsText(this.name), this.enabled, this.nested, this.dynamic, this.pathType, mappers);
            objectMapper.includeInAllIfNotSet(this.includeInAll);
            return (Y)objectMapper;
        }

        protected ObjectMapper createMapper(String name, String fullPath, boolean enabled, Nested nested, Dynamic dynamic, ContentPath.Type pathType, Map<String, Mapper> mappers) {
            return new ObjectMapper(name, fullPath, enabled, nested, dynamic, pathType, mappers);
        }
    }

    public static class Nested {
        public static final Nested NO = new Nested(false, false, false);
        private final boolean nested;
        private final boolean includeInParent;
        private final boolean includeInRoot;

        public static Nested newNested(boolean includeInParent, boolean includeInRoot) {
            return new Nested(true, includeInParent, includeInRoot);
        }

        private Nested(boolean nested, boolean includeInParent, boolean includeInRoot) {
            this.nested = nested;
            this.includeInParent = includeInParent;
            this.includeInRoot = includeInRoot;
        }

        public boolean isNested() {
            return this.nested;
        }

        public boolean isIncludeInParent() {
            return this.includeInParent;
        }

        public boolean isIncludeInRoot() {
            return this.includeInRoot;
        }
    }

    public static enum Dynamic {
        TRUE,
        FALSE,
        STRICT;

    }

    public static class Defaults {
        public static final boolean ENABLED = true;
        public static final Nested NESTED = Nested.NO;
        public static final Dynamic DYNAMIC = null;
        public static final ContentPath.Type PATH_TYPE = ContentPath.Type.FULL;
    }
}

