/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilderException;

public abstract class BaseQueryBuilder
implements QueryBuilder {
    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.prettyPrint();
            this.toXContent(builder, EMPTY_PARAMS);
            return builder.string();
        }
        catch (Exception e) {
            throw new QueryBuilderException("Failed to build query", e);
        }
    }

    @Override
    public BytesReference buildAsBytes() throws QueryBuilderException {
        return this.buildAsBytes(XContentType.JSON);
    }

    @Override
    public BytesReference buildAsBytes(XContentType contentType) throws QueryBuilderException {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            this.toXContent(builder, EMPTY_PARAMS);
            return builder.bytes();
        }
        catch (Exception e) {
            throw new QueryBuilderException("Failed to build query", e);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.doXContent(builder, params);
        builder.endObject();
        return builder;
    }

    protected abstract void doXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;
}

