/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.XTermsFilter;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.AndFilter;
import org.elasticsearch.common.lucene.search.OrFilter;
import org.elasticsearch.common.lucene.search.TermFilter;
import org.elasticsearch.common.lucene.search.XBooleanFilter;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;

public class TermsFilterParser
implements FilterParser {
    public static final String NAME = "terms";

    @Inject
    public TermsFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "in"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Filter filter;
        block66: {
            XContentParser.Token token;
            XContentParser parser = parseContext.parser();
            MapperService.SmartNameFieldMappers smartNameFieldMappers = null;
            Boolean cache = null;
            String filterName = null;
            String currentFieldName = null;
            CacheKeyFilter.Key cacheKey = null;
            String execution = "plain";
            ArrayList<String> terms = Lists.newArrayList();
            String fieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    fieldName = currentFieldName;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String value = parser.text();
                        if (value == null) {
                            throw new QueryParsingException(parseContext.index(), "No value specified for term filter");
                        }
                        terms.add(value);
                    }
                    continue;
                }
                if (!token.isValue()) continue;
                if ("execution".equals(currentFieldName)) {
                    execution = parser.text();
                    continue;
                }
                if ("_name".equals(currentFieldName)) {
                    filterName = parser.text();
                    continue;
                }
                if ("_cache".equals(currentFieldName)) {
                    cache = parser.booleanValue();
                    continue;
                }
                if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                    cacheKey = new CacheKeyFilter.Key(parser.text());
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[terms] filter does not support [" + currentFieldName + "]");
            }
            if (fieldName == null) {
                throw new QueryParsingException(parseContext.index(), "bool filter requires a field name, followed by array of terms");
            }
            FieldMapper fieldMapper = null;
            smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
            String[] previousTypes = null;
            if (smartNameFieldMappers != null) {
                if (smartNameFieldMappers.hasMapper()) {
                    fieldMapper = smartNameFieldMappers.mapper();
                    fieldName = fieldMapper.names().indexName();
                }
                if (smartNameFieldMappers.explicitTypeInNameWithDocMapper()) {
                    previousTypes = QueryParseContext.setTypesWithPrevious(new String[]{smartNameFieldMappers.docMapper().type()});
                }
            }
            try {
                ArrayList<Filter> filters;
                XBooleanFilter boolFiler;
                Filter filter2;
                if ("plain".equals(execution)) {
                    Term[] filterTerms = new Term[terms.size()];
                    if (fieldMapper != null) {
                        for (int i = 0; i < filterTerms.length; ++i) {
                            filterTerms[i] = fieldMapper.names().createIndexNameTerm(fieldMapper.indexedValue((String)terms.get(i)));
                        }
                    } else {
                        for (int i = 0; i < filterTerms.length; ++i) {
                            filterTerms[i] = new Term(fieldName, (String)terms.get(i));
                        }
                    }
                    filter2 = new XTermsFilter(filterTerms);
                    if (cache == null || cache.booleanValue()) {
                        filter2 = parseContext.cacheFilter(filter2, cacheKey);
                    }
                } else if ("bool".equals(execution)) {
                    boolFiler = new XBooleanFilter();
                    if (fieldMapper != null) {
                        for (String term : terms) {
                            boolFiler.addShould(parseContext.cacheFilter(fieldMapper.fieldFilter(term, parseContext), null));
                        }
                    } else {
                        for (String term : terms) {
                            boolFiler.addShould(parseContext.cacheFilter(new TermFilter(new Term(fieldName, term)), null));
                        }
                    }
                    filter2 = boolFiler;
                    if (cache != null && cache.booleanValue()) {
                        filter2 = parseContext.cacheFilter(filter2, cacheKey);
                    }
                } else if ("bool_nocache".equals(execution)) {
                    boolFiler = new XBooleanFilter();
                    if (fieldMapper != null) {
                        for (String term : terms) {
                            boolFiler.addShould(fieldMapper.fieldFilter(term, parseContext));
                        }
                    } else {
                        for (String term : terms) {
                            boolFiler.addShould(new TermFilter(new Term(fieldName, term)));
                        }
                    }
                    filter2 = boolFiler;
                    if (cache == null || cache.booleanValue()) {
                        filter2 = parseContext.cacheFilter(filter2, cacheKey);
                    }
                } else if ("and".equals(execution)) {
                    filters = Lists.newArrayList();
                    if (fieldMapper != null) {
                        for (String term : terms) {
                            filters.add(parseContext.cacheFilter(fieldMapper.fieldFilter(term, parseContext), null));
                        }
                    } else {
                        for (String term : terms) {
                            filters.add(parseContext.cacheFilter(new TermFilter(new Term(fieldName, term)), null));
                        }
                    }
                    filter2 = new AndFilter(filters);
                    if (cache != null && cache.booleanValue()) {
                        filter2 = parseContext.cacheFilter(filter2, cacheKey);
                    }
                } else if ("and_nocache".equals(execution)) {
                    filters = Lists.newArrayList();
                    if (fieldMapper != null) {
                        for (String term : terms) {
                            filters.add(fieldMapper.fieldFilter(term, parseContext));
                        }
                    } else {
                        for (String term : terms) {
                            filters.add(new TermFilter(new Term(fieldName, term)));
                        }
                    }
                    filter2 = new AndFilter(filters);
                    if (cache == null || cache.booleanValue()) {
                        filter2 = parseContext.cacheFilter(filter2, cacheKey);
                    }
                } else if ("or".equals(execution)) {
                    filters = Lists.newArrayList();
                    if (fieldMapper != null) {
                        for (String term : terms) {
                            filters.add(parseContext.cacheFilter(fieldMapper.fieldFilter(term, parseContext), null));
                        }
                    } else {
                        for (String term : terms) {
                            filters.add(parseContext.cacheFilter(new TermFilter(new Term(fieldName, term)), null));
                        }
                    }
                    filter2 = new OrFilter(filters);
                    if (cache != null && cache.booleanValue()) {
                        filter2 = parseContext.cacheFilter(filter2, cacheKey);
                    }
                } else if ("or_nocache".equals(execution)) {
                    filters = Lists.newArrayList();
                    if (fieldMapper != null) {
                        for (String term : terms) {
                            filters.add(fieldMapper.fieldFilter(term, parseContext));
                        }
                    } else {
                        for (String term : terms) {
                            filters.add(new TermFilter(new Term(fieldName, term)));
                        }
                    }
                    filter2 = new OrFilter(filters);
                    if (cache == null || cache.booleanValue()) {
                        filter2 = parseContext.cacheFilter(filter2, cacheKey);
                    }
                } else {
                    throw new QueryParsingException(parseContext.index(), "bool filter execution value [" + execution + "] not supported");
                }
                filter2 = QueryParsers.wrapSmartNameFilter(filter2, smartNameFieldMappers, parseContext);
                if (filterName != null) {
                    parseContext.addNamedFilter(filterName, filter2);
                }
                filter = filter2;
                if (smartNameFieldMappers == null || !smartNameFieldMappers.explicitTypeInNameWithDocMapper()) break block66;
            }
            catch (Throwable throwable) {
                if (smartNameFieldMappers != null && smartNameFieldMappers.explicitTypeInNameWithDocMapper()) {
                    QueryParseContext.setTypes(previousTypes);
                }
                throw throwable;
            }
            QueryParseContext.setTypes(previousTypes);
        }
        return filter;
    }
}

