/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.lucene.docset.DocSets;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;
import org.elasticsearch.index.search.geo.Point;

public class IndexedGeoBoundingBoxFilter {
    public static Filter create(Point topLeft, Point bottomRight, GeoPointFieldMapper fieldMapper) {
        if (!fieldMapper.isEnableLatLon()) {
            throw new ElasticSearchIllegalArgumentException("lat/lon is not enabled (indexed) for field [" + fieldMapper.name() + "], can't use indexed filter on it");
        }
        if (topLeft.lon > bottomRight.lon) {
            return new LeftGeoBoundingBoxFilter(topLeft, bottomRight, fieldMapper);
        }
        return new RightGeoBoundingBoxFilter(topLeft, bottomRight, fieldMapper);
    }

    static class RightGeoBoundingBoxFilter
    extends Filter {
        final Filter lonFilter;
        final Filter latFilter;

        public RightGeoBoundingBoxFilter(Point topLeft, Point bottomRight, GeoPointFieldMapper fieldMapper) {
            this.lonFilter = fieldMapper.lonMapper().rangeFilter(topLeft.lon, bottomRight.lon, true, true);
            this.latFilter = fieldMapper.latMapper().rangeFilter(bottomRight.lat, topLeft.lat, true, true);
        }

        @Override
        public FixedBitSet getDocIdSet(IndexReader reader) throws IOException {
            DocIdSet set = this.lonFilter.getDocIdSet(reader);
            if (set == null || set == DocIdSet.EMPTY_DOCIDSET) {
                return null;
            }
            FixedBitSet main = (FixedBitSet)set;
            set = this.latFilter.getDocIdSet(reader);
            if (set == null || set == DocIdSet.EMPTY_DOCIDSET) {
                return null;
            }
            DocSets.and(main, set);
            return main;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RightGeoBoundingBoxFilter that = (RightGeoBoundingBoxFilter)o;
            if (this.latFilter != null ? !this.latFilter.equals(that.latFilter) : that.latFilter != null) {
                return false;
            }
            return !(this.lonFilter != null ? !this.lonFilter.equals(that.lonFilter) : that.lonFilter != null);
        }

        public int hashCode() {
            int result = this.lonFilter != null ? this.lonFilter.hashCode() : 0;
            result = 31 * result + (this.latFilter != null ? this.latFilter.hashCode() : 0);
            return result;
        }
    }

    static class LeftGeoBoundingBoxFilter
    extends Filter {
        final Filter lonFilter1;
        final Filter lonFilter2;
        final Filter latFilter;

        public LeftGeoBoundingBoxFilter(Point topLeft, Point bottomRight, GeoPointFieldMapper fieldMapper) {
            this.lonFilter1 = fieldMapper.lonMapper().rangeFilter(null, bottomRight.lon, true, true);
            this.lonFilter2 = fieldMapper.lonMapper().rangeFilter(topLeft.lon, null, true, true);
            this.latFilter = fieldMapper.latMapper().rangeFilter(bottomRight.lat, topLeft.lat, true, true);
        }

        @Override
        public FixedBitSet getDocIdSet(IndexReader reader) throws IOException {
            DocIdSet set = this.lonFilter1.getDocIdSet(reader);
            FixedBitSet main = set == null || set == DocIdSet.EMPTY_DOCIDSET ? null : (FixedBitSet)set;
            set = this.lonFilter2.getDocIdSet(reader);
            if (set == null || set == DocIdSet.EMPTY_DOCIDSET) {
                if (main == null) {
                    return null;
                }
            } else if (main == null) {
                main = (FixedBitSet)set;
            } else {
                main.or((FixedBitSet)set);
            }
            if ((set = this.latFilter.getDocIdSet(reader)) == null || set == DocIdSet.EMPTY_DOCIDSET) {
                return null;
            }
            DocSets.and(main, set);
            return main;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LeftGeoBoundingBoxFilter that = (LeftGeoBoundingBoxFilter)o;
            if (this.latFilter != null ? !this.latFilter.equals(that.latFilter) : that.latFilter != null) {
                return false;
            }
            if (this.lonFilter1 != null ? !this.lonFilter1.equals(that.lonFilter1) : that.lonFilter1 != null) {
                return false;
            }
            return !(this.lonFilter2 != null ? !this.lonFilter2.equals(that.lonFilter2) : that.lonFilter2 != null);
        }

        public int hashCode() {
            int result = this.lonFilter1 != null ? this.lonFilter1.hashCode() : 0;
            result = 31 * result + (this.lonFilter2 != null ? this.lonFilter2.hashCode() : 0);
            result = 31 * result + (this.latFilter != null ? this.latFilter.hashCode() : 0);
            return result;
        }
    }
}

