/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.settings;

import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsProvider;
import org.elasticsearch.index.settings.IndexSettingsService;

public class IndexSettingsModule
extends AbstractModule {
    private final Index index;
    private final Settings settings;

    public IndexSettingsModule(Index index, Settings settings) {
        this.index = index;
        this.settings = settings;
    }

    @Override
    protected void configure() {
        IndexSettingsService indexSettingsService = new IndexSettingsService(this.index, this.settings);
        this.bind(IndexSettingsService.class).toInstance(indexSettingsService);
        this.bind(Settings.class).annotatedWith(IndexSettings.class).toProvider(new IndexSettingsProvider(indexSettingsService));
    }
}

