/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.support;

import java.io.IOException;
import org.apache.lucene.store.StoreRateLimiting;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.indices.store.IndicesStore;

public abstract class AbstractIndexStore
extends AbstractIndexComponent
implements IndexStore {
    protected final IndexService indexService;
    protected final IndicesStore indicesStore;
    private volatile String rateLimitingType;
    private volatile ByteSizeValue rateLimitingThrottle;
    private volatile boolean nodeRateLimiting;
    private final StoreRateLimiting rateLimiting = new StoreRateLimiting();
    private final ApplySettings applySettings = new ApplySettings();

    protected AbstractIndexStore(Index index, @IndexSettings Settings indexSettings, IndexService indexService, IndicesStore indicesStore) {
        super(index, indexSettings);
        this.indexService = indexService;
        this.indicesStore = indicesStore;
        this.rateLimitingType = indexSettings.get("index.store.throttle.type", "node");
        if (this.rateLimitingType.equalsIgnoreCase("node")) {
            this.nodeRateLimiting = true;
        } else {
            this.nodeRateLimiting = false;
            this.rateLimiting.setType(this.rateLimitingType);
        }
        this.rateLimitingThrottle = indexSettings.getAsBytesSize("index.store.throttle.max_bytes_per_sec", new ByteSizeValue(0L));
        this.rateLimiting.setMaxRate(this.rateLimitingThrottle);
        this.logger.debug("using index.store.throttle.type [{}], with index.store.throttle.max_bytes_per_sec [{}]", this.rateLimitingType, this.rateLimitingThrottle);
        indexService.settingsService().addListener(this.applySettings);
    }

    @Override
    public void close(boolean delete) throws ElasticSearchException {
        this.indexService.settingsService().removeListener(this.applySettings);
    }

    @Override
    public boolean canDeleteUnallocated(ShardId shardId) {
        return false;
    }

    @Override
    public void deleteUnallocated(ShardId shardId) throws IOException {
    }

    @Override
    public IndicesStore indicesStore() {
        return this.indicesStore;
    }

    @Override
    public StoreRateLimiting rateLimiting() {
        return this.nodeRateLimiting ? this.indicesStore.rateLimiting() : this.rateLimiting;
    }

    static {
        IndexMetaData.addDynamicSettings("index.store.throttle.type", "index.store.throttle.max_bytes_per_sec");
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            ByteSizeValue rateLimitingThrottle;
            String rateLimitingType = AbstractIndexStore.this.indexSettings.get("index.store.throttle.type", AbstractIndexStore.this.rateLimitingType);
            if (!rateLimitingType.equals(AbstractIndexStore.this.rateLimitingType)) {
                AbstractIndexStore.this.logger.info("updating index.store.throttle.type from [{}] to [{}]", AbstractIndexStore.this.rateLimitingType, rateLimitingType);
                if (rateLimitingType.equalsIgnoreCase("node")) {
                    AbstractIndexStore.this.rateLimitingType = rateLimitingType;
                    AbstractIndexStore.this.nodeRateLimiting = true;
                } else {
                    StoreRateLimiting.Type.fromString(rateLimitingType);
                    AbstractIndexStore.this.rateLimitingType = rateLimitingType;
                    AbstractIndexStore.this.nodeRateLimiting = false;
                    AbstractIndexStore.this.rateLimiting.setType(rateLimitingType);
                }
            }
            if (!(rateLimitingThrottle = settings.getAsBytesSize("index.store.throttle.max_bytes_per_sec", AbstractIndexStore.this.rateLimitingThrottle)).equals(AbstractIndexStore.this.rateLimitingThrottle)) {
                AbstractIndexStore.this.logger.info("updating index.store.throttle.max_bytes_per_sec from [{}] to [{}], note, type is [{}]", AbstractIndexStore.this.rateLimitingThrottle, rateLimitingThrottle, AbstractIndexStore.this.rateLimitingType);
                AbstractIndexStore.this.rateLimitingThrottle = rateLimitingThrottle;
                AbstractIndexStore.this.rateLimiting.setMaxRate(rateLimitingThrottle);
            }
        }
    }
}

