/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.dfs;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.transport.TransportResponse;

public class DfsSearchResult
extends TransportResponse
implements SearchPhaseResult {
    private static Term[] EMPTY_TERMS = new Term[0];
    private static int[] EMPTY_FREQS = new int[0];
    private SearchShardTarget shardTarget;
    private long id;
    private Term[] terms;
    private int[] freqs;
    private int maxDoc;

    public DfsSearchResult() {
    }

    public DfsSearchResult(long id, SearchShardTarget shardTarget) {
        this.id = id;
        this.shardTarget = shardTarget;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public SearchShardTarget shardTarget() {
        return this.shardTarget;
    }

    @Override
    public void shardTarget(SearchShardTarget shardTarget) {
        this.shardTarget = shardTarget;
    }

    public DfsSearchResult maxDoc(int maxDoc) {
        this.maxDoc = maxDoc;
        return this;
    }

    public int maxDoc() {
        return this.maxDoc;
    }

    public DfsSearchResult termsAndFreqs(Term[] terms, int[] freqs) {
        this.terms = terms;
        this.freqs = freqs;
        return this;
    }

    public Term[] terms() {
        return this.terms;
    }

    public int[] freqs() {
        return this.freqs;
    }

    public static DfsSearchResult readDfsSearchResult(StreamInput in) throws IOException, ClassNotFoundException {
        DfsSearchResult result = new DfsSearchResult();
        result.readFrom(in);
        return result;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readLong();
        int termsSize = in.readVInt();
        if (termsSize == 0) {
            this.terms = EMPTY_TERMS;
        } else {
            this.terms = new Term[termsSize];
            for (int i = 0; i < this.terms.length; ++i) {
                this.terms[i] = new Term(in.readUTF(), in.readUTF());
            }
        }
        int freqsSize = in.readVInt();
        if (freqsSize == 0) {
            this.freqs = EMPTY_FREQS;
        } else {
            this.freqs = new int[freqsSize];
            for (int i = 0; i < this.freqs.length; ++i) {
                this.freqs[i] = in.readVInt();
            }
        }
        this.maxDoc = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.id);
        out.writeVInt(this.terms.length);
        for (Term term : this.terms) {
            out.writeUTF(term.field());
            out.writeUTF(term.text());
        }
        out.writeVInt(this.freqs.length);
        for (int freq : this.freqs) {
            out.writeVInt(freq);
        }
        out.writeVInt(this.maxDoc);
    }
}

