/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.SubExpressionInfo;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ElementCreator;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComputedElement
extends ElementCreator {
    private Expression elementName;
    private Expression namespace = null;
    private NamespaceResolver nsContext;
    private boolean allowNameAsQName;
    private ItemType itemType;

    public ComputedElement(Expression elementName, Expression namespace, NamespaceResolver nsContext, SchemaType schemaType, int validation, boolean inheritNamespaces, boolean allowQName) {
        this.elementName = elementName;
        this.namespace = namespace;
        this.nsContext = nsContext;
        this.setValidationAction(validation, schemaType);
        this.preservingTypes = schemaType == null && validation == 3;
        this.inheritNamespaces = inheritNamespaces;
        this.allowNameAsQName = allowQName;
        this.adoptChildExpression(elementName);
        this.adoptChildExpression(namespace);
    }

    public Expression getNameExpression() {
        return this.elementName;
    }

    public Expression getNamespaceExpression() {
        return this.namespace;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.nsContext;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.elementName = visitor.simplify(this.elementName);
        this.namespace = visitor.simplify(this.namespace);
        Configuration config = visitor.getConfiguration();
        this.setLazyConstruction(config.getBooleanProperty("http://saxon.sf.net/feature/lazyConstructionMode"));
        boolean schemaAware = visitor.getExecutable().isSchemaAware();
        this.preservingTypes |= !schemaAware;
        SchemaType schemaType = this.getSchemaType();
        if (schemaType != null) {
            this.itemType = new ContentTypeTest(1, schemaType, config, false);
            schemaType.analyzeContentExpression(this.content, 1, visitor.getStaticContext());
        } else {
            this.itemType = this.getValidationAction() == 4 || !schemaAware ? new ContentTypeTest(1, Untyped.getInstance(), config, false) : NodeKindTest.ELEMENT;
        }
        return super.simplify(visitor);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        TypeHierarchy th;
        this.elementName = visitor.typeCheck(this.elementName, contextItemType);
        RoleLocator role = new RoleLocator(4, "element/name", 0);
        if (this.allowNameAsQName) {
            ItemType supplied;
            this.elementName = TypeChecker.staticTypeCheck(this.elementName, SequenceType.SINGLE_ATOMIC, false, role, visitor);
            th = visitor.getConfiguration().getTypeHierarchy();
            if (th.relationship(supplied = this.elementName.getItemType(th), BuiltInAtomicType.STRING) == 4 && th.relationship(supplied, BuiltInAtomicType.UNTYPED_ATOMIC) == 4 && th.relationship(supplied, BuiltInAtomicType.QNAME) == 4) {
                XPathException de = new XPathException("The name of a constructed element must be a string, QName, or untypedAtomic");
                de.setErrorCode("XPTY0004");
                de.setIsTypeError(true);
                de.setLocator(this);
                throw de;
            }
        } else {
            th = visitor.getConfiguration().getTypeHierarchy();
            if (!th.isSubType(this.elementName.getItemType(th), BuiltInAtomicType.STRING)) {
                this.elementName = SystemFunctionCall.makeSystemFunction("string", new Expression[]{this.elementName});
            }
        }
        if (this.namespace != null) {
            this.namespace = visitor.typeCheck(this.namespace, contextItemType);
            role = new RoleLocator(4, "element/namespace", 0);
            this.namespace = TypeChecker.staticTypeCheck(this.namespace, SequenceType.SINGLE_STRING, false, role, visitor);
        }
        if (Literal.isAtomic(this.elementName)) {
            try {
                AtomicValue val = (AtomicValue)((Literal)this.elementName).getValue();
                if (val instanceof StringValue) {
                    String[] parts = visitor.getConfiguration().getNameChecker().checkQNameParts(val.getStringValueCS());
                    if (this.namespace == null) {
                        String prefix = parts[0];
                        String uri = this.getNamespaceResolver().getURIForPrefix(prefix, true);
                        if (uri == null) {
                            XPathException se = new XPathException("Prefix " + prefix + " has not been declared");
                            se.setErrorCode("XPST0081");
                            se.setIsStaticError(true);
                            throw se;
                        }
                        this.namespace = new StringLiteral(uri);
                    }
                }
            }
            catch (XPathException e) {
                String code = e.getErrorCodeLocalPart();
                if (code == null || code.equals("FORG0001")) {
                    e.setErrorCode(this.isXSLT() ? "XTDE0820" : "XQDY0074");
                } else if (code.equals("XPST0081")) {
                    e.setErrorCode(this.isXSLT() ? "XTDE0830" : "XQDY0074");
                }
                e.maybeSetLocation(this);
                e.setIsStaticError(true);
                throw e;
            }
        }
        return super.typeCheck(visitor, contextItemType);
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.elementName = visitor.optimize(this.elementName, contextItemType);
        return super.optimize(visitor, contextItemType);
    }

    @Override
    public Expression copy() {
        ComputedElement ce = new ComputedElement(this.elementName.copy(), this.namespace == null ? null : this.namespace.copy(), this.getNamespaceResolver(), this.getSchemaType(), this.getValidationAction(), this.inheritNamespaces, this.allowNameAsQName);
        ce.setContentExpression(this.content.copy());
        return ce;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        if (this.itemType == null) {
            return super.getItemType(th);
        }
        return this.itemType;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        ArrayList<Expression> list = new ArrayList<Expression>(3);
        list.add(this.content);
        list.add(this.elementName);
        if (this.namespace != null) {
            list.add(this.namespace);
        }
        return list.iterator();
    }

    @Override
    public Iterator<SubExpressionInfo> iterateSubExpressionInfo() {
        ArrayList<SubExpressionInfo> list = new ArrayList<SubExpressionInfo>(3);
        list.add(new SubExpressionInfo(this.content, true, false, 1));
        list.add(new SubExpressionInfo(this.elementName, true, false, 1));
        if (this.namespace != null) {
            list.add(new SubExpressionInfo(this.namespace, true, false, 1));
        }
        if (this.getOnEmpty() != null) {
            list.add(new SubExpressionInfo(this.onEmpty, true, false, 0));
        }
        return list.iterator();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.content == original) {
            this.content = replacement;
            found = true;
        }
        if (this.elementName == original) {
            this.elementName = replacement;
            found = true;
        }
        if (this.namespace == original) {
            this.namespace = replacement;
            found = true;
        }
        return found;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.elementName = this.doPromotion(this.elementName, offer);
        if (this.namespace != null) {
            this.namespace = this.doPromotion(this.namespace, offer);
        }
        super.promoteInst(offer);
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        if (parentType instanceof SimpleType || ((ComplexType)parentType).isSimpleContent()) {
            String msg = "Elements are not permitted here: the containing element ";
            msg = parentType instanceof SimpleType ? (parentType.isAnonymousType() ? msg + "is defined to have a simple type" : msg + "is of simple type " + parentType.getDescription()) : msg + "has a complex type with simple content";
            XPathException err = new XPathException(msg);
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
    }

    @Override
    public NodeName getElementName(XPathContext context, NodeInfo copiedNode) throws XPathException {
        XPathException err;
        String localName;
        String prefix;
        Controller controller = context.getController();
        assert (controller != null);
        String uri = null;
        AtomicValue nameValue = (AtomicValue)this.elementName.evaluateItem(context);
        if (nameValue == null) {
            XPathException err1 = new XPathException("Invalid element name (empty sequence)", this);
            err1.setErrorCode(this.isXSLT() ? "XTDE0820" : "XPTY0004");
            err1.setXPathContext(context);
            throw ComputedElement.dynamicError(this, err1, context);
        }
        if (nameValue instanceof StringValue) {
            CharSequence rawName = nameValue.getStringValueCS();
            rawName = Whitespace.trimWhitespace(rawName);
            try {
                String[] parts = controller.getConfiguration().getNameChecker().getQNameParts(rawName);
                prefix = parts[0];
                localName = parts[1];
            }
            catch (QNameException err2) {
                String message = "Invalid element name. " + err2.getMessage();
                if (rawName.length() == 0) {
                    message = "Supplied element name is a zero-length string";
                }
                XPathException err1 = new XPathException(message, this);
                err1.setErrorCode(this.isXSLT() ? "XTDE0820" : "XQDY0074");
                err1.setXPathContext(context);
                throw ComputedElement.dynamicError(this, err1, context);
            }
        } else if (nameValue instanceof QNameValue && this.allowNameAsQName) {
            localName = ((QNameValue)nameValue).getLocalName();
            uri = ((QNameValue)nameValue).getNamespaceURI();
            prefix = ((QNameValue)nameValue).getPrefix();
            if (prefix.equals("xmlns")) {
                XPathException err3 = new XPathException("Computed element name has prefix xmlns");
                err3.setErrorCode("XQDY0096");
                err3.setXPathContext(context);
                throw ComputedElement.dynamicError(this, err3, context);
            }
        } else {
            XPathException err4 = new XPathException("Computed element name has incorrect type");
            err4.setErrorCode(this.isXSLT() ? "XTDE0820" : "XPTY0004");
            err4.setIsTypeError(true);
            err4.setXPathContext(context);
            throw ComputedElement.dynamicError(this, err4, context);
        }
        if (this.namespace == null && uri == null) {
            uri = this.nsContext.getURIForPrefix(prefix, true);
            if (uri == null) {
                err = new XPathException("Undeclared prefix in element name: " + prefix, this);
                err.setErrorCode(this.isXSLT() ? "XTDE0830" : (prefix.equals("xmlns") ? "XQDY0096" : "XQDY0074"));
                err.setXPathContext(context);
                throw ComputedElement.dynamicError(this, err, context);
            }
        } else {
            if (uri == null) {
                if (this.namespace instanceof StringLiteral) {
                    uri = ((StringLiteral)this.namespace).getStringValue();
                } else {
                    uri = ((Object)this.namespace.evaluateAsString(context)).toString();
                    if (!StandardURIChecker.getInstance().isValidURI(uri)) {
                        XPathException de = new XPathException("The value of the namespace attribute must be a valid URI");
                        de.setErrorCode("XTDE0835");
                        de.setXPathContext(context);
                        de.setLocator(this);
                        throw de;
                    }
                }
            }
            if (uri.length() == 0) {
                prefix = "";
            }
            if (prefix.equals("xmlns")) {
                prefix = "x-xmlns";
            }
        }
        if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            err = new XPathException("Cannot create element in namespace " + uri, this);
            err.setErrorCode(this.isXSLT() ? "XTDE0835" : "XQDY0096");
            err.setXPathContext(context);
            throw ComputedElement.dynamicError(this, err, context);
        }
        if (uri.equals("http://www.w3.org/XML/1998/namespace") != prefix.equals("xml")) {
            String message = prefix.equals("xml") ? "When the prefix is 'xml', the namespace URI must be http://www.w3.org/XML/1998/namespace" : "When the namespace URI is http://www.w3.org/XML/1998/namespace, the prefix must be 'xml'";
            XPathException err5 = new XPathException(message, this);
            err5.setErrorCode(this.isXSLT() ? "XTDE0835" : "XQDY0096");
            err5.setXPathContext(context);
            throw ComputedElement.dynamicError(this, err5, context);
        }
        return new FingerprintedQName(prefix, uri, localName);
    }

    public boolean isAllowNameAsQName() {
        return this.allowNameAsQName;
    }

    @Override
    public String getNewBaseURI(XPathContext context, NodeInfo copiedNode) {
        return this.getBaseURI();
    }

    @Override
    public void outputNamespaceNodes(XPathContext context, Receiver out, NodeName nameCode, NodeInfo copiedNode) throws XPathException {
    }

    @Override
    public int getInstructionNameCode() {
        return 147;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("computedElement");
        out.emitAttribute("validation", Validation.toString(this.getValidationAction()));
        SchemaType schemaType = this.getSchemaType();
        if (schemaType != null) {
            out.emitAttribute("type", schemaType.getDescription());
        }
        out.startSubsidiaryElement("name");
        this.elementName.explain(out);
        out.endSubsidiaryElement();
        if (this.namespace != null) {
            out.startSubsidiaryElement("namespace");
            this.namespace.explain(out);
            out.endSubsidiaryElement();
        }
        out.startSubsidiaryElement("content");
        this.content.explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }
}

