/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.ComparisonKey;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupAdjacentIterator
implements GroupIterator,
LookaheadIterator {
    private SequenceIterator population;
    private Expression keyExpression;
    private StringCollator collator;
    private AtomicComparer comparer;
    private XPathContext baseContext;
    private XPathContext runningContext;
    private List<ComparisonKey> currentComparisonKey;
    private AtomicSequence currentKey;
    private AtomicSequence currentKeyItems;
    private List<Item> currentMembers;
    private List<ComparisonKey> nextComparisonKey;
    private List<AtomicValue> nextKey = null;
    private Item next;
    private Item current = null;
    private int position = 0;
    private int groupSlot = -1;
    private int keySlot = -1;
    private boolean composite = false;

    public GroupAdjacentIterator(SequenceIterator population, Expression keyExpression, XPathContext baseContext, AtomicComparer comparer, boolean composite) throws XPathException {
        this.population = population;
        this.keyExpression = keyExpression;
        this.baseContext = baseContext;
        this.runningContext = baseContext.newMinorContext();
        this.runningContext.setCurrentIterator(population);
        this.comparer = comparer;
        this.composite = composite;
        this.next = population.next();
        if (this.next != null) {
            this.nextKey = this.getKey(this.runningContext);
            this.nextComparisonKey = this.getComparisonKey(this.nextKey);
        }
    }

    private List<AtomicValue> getKey(XPathContext context) throws XPathException {
        AtomicValue val;
        ArrayList<AtomicValue> key = new ArrayList<AtomicValue>();
        SequenceIterator<? extends Item> iter = this.keyExpression.iterate(context);
        while ((val = (AtomicValue)iter.next()) != null) {
            key.add(val);
        }
        return key;
    }

    private List<ComparisonKey> getComparisonKey(List<AtomicValue> key) throws XPathException {
        ArrayList<ComparisonKey> ckey = new ArrayList<ComparisonKey>(key.size());
        for (AtomicValue aKey : key) {
            ckey.add(this.comparer.getComparisonKey(aKey));
        }
        return ckey;
    }

    @Override
    public void setGroupSlot(int groupSlot) {
        this.groupSlot = groupSlot;
    }

    @Override
    public void setKeySlot(int keySlot) {
        this.keySlot = keySlot;
    }

    private void advance() throws XPathException {
        Object nextCandidate;
        this.currentMembers = new ArrayList<Item>(20);
        this.currentMembers.add(this.current);
        while ((nextCandidate = this.population.next()) != null) {
            List<AtomicValue> newKey = this.getKey(this.runningContext);
            List<ComparisonKey> newComparisonKey = this.getComparisonKey(newKey);
            try {
                if (((Object)this.currentComparisonKey).equals(newComparisonKey)) {
                    this.currentMembers.add((Item)nextCandidate);
                    continue;
                }
                this.next = nextCandidate;
                this.nextComparisonKey = newComparisonKey;
                this.nextKey = newKey;
                return;
            }
            catch (ClassCastException e) {
                String t2;
                String t1;
                String message = "Grouping key values are of non-comparable types";
                if (this.currentKeyItems.getLength() != 0 && !newKey.isEmpty() && !(t1 = Type.displayTypeName(this.currentKeyItems.itemAt(0))).equals(t2 = Type.displayTypeName(newKey.get(0)))) {
                    message = message + " (" + t1 + " and " + t2 + ")";
                }
                XPathException err = new XPathException(message);
                err.setIsTypeError(true);
                err.setXPathContext(this.runningContext);
                throw err;
            }
        }
        this.next = null;
        this.nextKey = null;
    }

    @Override
    public AtomicSequence getCurrentGroupingKey() {
        return this.currentKey;
    }

    public SequenceIterator iterateCurrentGroup() {
        return new ListIterator<Item>(this.currentMembers);
    }

    @Override
    public boolean hasCurrentGroup() {
        return this.groupSlot < 0;
    }

    @Override
    public boolean hasCurrentGroupingKey() {
        return this.keySlot < 0;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Item next() throws XPathException {
        if (this.next == null) {
            this.current = null;
            this.position = -1;
            return null;
        }
        this.current = this.next;
        this.currentKey = this.nextKey.size() == 1 ? (AtomicSequence)this.nextKey.get(0) : new AtomicArray(this.nextKey.toArray(new AtomicValue[this.nextKey.size()]));
        this.currentComparisonKey = this.nextComparisonKey;
        ++this.position;
        this.advance();
        if (this.groupSlot >= 0) {
            this.runningContext.setLocalVariable(this.groupSlot, new SequenceExtent<Item>(this.currentMembers));
        }
        if (this.keySlot >= 0) {
            this.runningContext.setLocalVariable(this.keySlot, this.currentKey);
        }
        return this.current;
    }

    @Override
    public Item current() {
        return this.current;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void close() {
        this.population.close();
    }

    @Override
    public SequenceIterator getAnother() throws XPathException {
        return new GroupAdjacentIterator(this.population.getAnother(), this.keyExpression, this.baseContext, this.comparer, this.composite);
    }

    @Override
    public int getProperties() {
        return 4;
    }
}

