/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SavedNamespaceContext;
import net.sf.saxon.expr.number.Alphanumeric;
import net.sf.saxon.expr.number.NamedTimeZone;
import net.sf.saxon.expr.number.Numberer_en;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.Whitespace;

public class FormatDate
extends SystemFunctionCall
implements Callable {
    static String[] knownCalendars = new String[]{"AD", "AH", "AME", "AM", "AP", "AS", "BE", "CB", "CE", "CL", "CS", "EE", "FE", "ISO", "JE", "KE", "KY", "ME", "MS", "NS", "OS", "RS", "SE", "SH", "SS", "TE", "VE", "VS"};
    private NamespaceResolver nsContext = null;
    private boolean is30 = false;
    private static Pattern componentPattern = Pattern.compile("([YMDdWwFHhmsfZzPCE])\\s*(.*)");
    private static Pattern formatPattern = Pattern.compile("([^,]*)(,.*)?");
    private static Pattern widthPattern = Pattern.compile(",(\\*|[0-9]+)(\\-(\\*|[0-9]+))?");
    private static Pattern alphanumericPattern = Pattern.compile("([A-Za-z0-9]|\\p{L}|\\p{N})*");
    private static Pattern digitsPattern = Pattern.compile("\\p{Nd}*");

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        int numArgs = this.argument.length;
        if (numArgs != 2 && numArgs != 5) {
            throw new XPathException("Function " + this.getDisplayName() + " must have either two or five arguments", this);
        }
        super.checkArguments(visitor);
    }

    public void bindStaticContext(StaticContext env) throws XPathException {
        this.is30 = env.getXPathLanguageLevel().equals(DecimalValue.THREE);
        if (this.nsContext == null && this.getNumberOfArguments() > 2) {
            this.nsContext = new SavedNamespaceContext(env.getNamespaceResolver());
        }
    }

    public StringValue evaluateItem(XPathContext context) throws XPathException {
        CalendarValue value = (CalendarValue)this.argument[0].evaluateItem(context);
        if (value == null) {
            return null;
        }
        String format = this.argument[1].evaluateItem(context).getStringValue();
        StringValue calendarVal = null;
        AtomicValue countryVal = null;
        AtomicValue languageVal = null;
        if (this.argument.length > 2) {
            languageVal = (StringValue)this.argument[2].evaluateItem(context);
            calendarVal = (StringValue)this.argument[3].evaluateItem(context);
            countryVal = (StringValue)this.argument[4].evaluateItem(context);
        }
        String language = languageVal == null ? null : languageVal.getStringValue();
        String country = countryVal == null ? null : countryVal.getStringValue();
        CharSequence result = FormatDate.formatDate(value, format, language, country, context);
        if (calendarVal != null) {
            result = this.adjustCalendar(calendarVal, result, context);
        }
        return new StringValue(result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CharSequence adjustCalendar(StringValue calendarVal, CharSequence result, XPathContext context) throws XPathException {
        StructuredQName cal;
        try {
            cal = StructuredQName.fromLexicalQName(calendarVal.getStringValue(), false, this.is30, context.getConfiguration().getNameChecker(), this.nsContext);
        }
        catch (XPathException e) {
            XPathException err = new XPathException("Invalid calendar name. " + e.getMessage());
            err.setErrorCode("FOFD1340");
            err.setLocator(this);
            err.setXPathContext(context);
            throw err;
        }
        if (!cal.getURI().equals("")) return "[Calendar: AD]" + ((Object)result).toString();
        String calLocal = cal.getLocalPart();
        if (calLocal.equals("AD")) return result;
        if (calLocal.equals("ISO")) return result;
        if (Arrays.binarySearch(knownCalendars, calLocal) >= 0) {
            return "[Calendar: AD]" + ((Object)result).toString();
        }
        XPathException err = new XPathException("Unknown no-namespace calendar: " + calLocal);
        err.setErrorCode("FOFD1340");
        err.setLocator(this);
        err.setXPathContext(context);
        throw err;
    }

    private static CharSequence formatDate(CalendarValue value, String format, String language, String country, XPathContext context) throws XPathException {
        boolean languageDefaulted;
        Configuration config = context.getConfiguration();
        boolean bl = languageDefaulted = language == null;
        if (language == null) {
            language = config.getDefaultLanguage();
        }
        if (country == null) {
            country = config.getDefaultCountry();
        }
        Numberer numberer = config.makeNumberer(language, country);
        FastStringBuffer sb = new FastStringBuffer(64);
        if (numberer.getClass() == Numberer_en.class && !"en".equals(language) && !languageDefaulted) {
            sb.append("[Language: en]");
        }
        int i = 0;
        while (true) {
            int close;
            if (i < format.length() && format.charAt(i) != '[') {
                sb.append(format.charAt(i));
                if (format.charAt(i) == ']' && (++i == format.length() || format.charAt(i) != ']')) {
                    XPathException e = new XPathException("Closing ']' in date picture must be written as ']]'");
                    e.setErrorCode("XTDE1340");
                    e.setXPathContext(context);
                    throw e;
                }
                ++i;
                continue;
            }
            if (i == format.length()) break;
            if (++i < format.length() && format.charAt(i) == '[') {
                sb.append('[');
                ++i;
                continue;
            }
            int n = close = i < format.length() ? format.indexOf("]", i) : -1;
            if (close == -1) {
                XPathException e = new XPathException("Date format contains a '[' with no matching ']'");
                e.setErrorCode("XTDE1340");
                e.setXPathContext(context);
                throw e;
            }
            String componentFormat = format.substring(i, close);
            sb.append(FormatDate.formatComponent(value, Whitespace.removeAllWhitespace(componentFormat), numberer, country, context));
            i = close + 1;
        }
        return sb;
    }

    private static CharSequence formatComponent(CalendarValue value, CharSequence specifier, Numberer numberer, String country, XPathContext context) throws XPathException {
        boolean ignoreDate = value instanceof TimeValue;
        boolean ignoreTime = value instanceof DateValue;
        DateTimeValue dtvalue = value.toDateTime();
        Matcher matcher = componentPattern.matcher(specifier);
        if (!matcher.matches()) {
            XPathException error = new XPathException("Unrecognized date/time component [" + specifier + ']');
            error.setErrorCode("XTDE1340");
            error.setXPathContext(context);
            throw error;
        }
        String component = matcher.group(1);
        String format = matcher.group(2);
        if (format == null) {
            format = "";
        }
        boolean defaultFormat = false;
        if ("".equals(format) || format.startsWith(",")) {
            defaultFormat = true;
            switch (component.charAt(0)) {
                case 'F': {
                    format = "Nn" + format;
                    break;
                }
                case 'P': {
                    format = 'n' + format;
                    break;
                }
                case 'C': 
                case 'E': {
                    format = 'N' + format;
                    break;
                }
                case 'm': 
                case 's': {
                    format = "01" + format;
                    break;
                }
                case 'Z': 
                case 'z': {
                    break;
                }
                default: {
                    format = '1' + format;
                }
            }
        }
        switch (component.charAt(0)) {
            case 'Y': {
                if (ignoreDate) {
                    XPathException error = new XPathException("In formatTime(): an xs:time value does not contain a year component");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int year = dtvalue.getYear();
                if (year < 0) {
                    year = 1 - year;
                }
                return FormatDate.formatNumber(component, year, format, defaultFormat, numberer, context);
            }
            case 'M': {
                if (ignoreDate) {
                    XPathException error = new XPathException("In formatTime(): an xs:time value does not contain a month component");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                byte month = dtvalue.getMonth();
                return FormatDate.formatNumber(component, month, format, defaultFormat, numberer, context);
            }
            case 'D': {
                if (ignoreDate) {
                    XPathException error = new XPathException("In formatTime(): an xs:time value does not contain a day component");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                byte day = dtvalue.getDay();
                return FormatDate.formatNumber(component, day, format, defaultFormat, numberer, context);
            }
            case 'd': {
                if (ignoreDate) {
                    XPathException error = new XPathException("In formatTime(): an xs:time value does not contain a day component");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int day = DateValue.getDayWithinYear(dtvalue.getYear(), dtvalue.getMonth(), dtvalue.getDay());
                return FormatDate.formatNumber(component, day, format, defaultFormat, numberer, context);
            }
            case 'W': {
                if (ignoreDate) {
                    XPathException error = new XPathException("In formatTime(): cannot obtain the week number from an xs:time value");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int week = DateValue.getWeekNumber(dtvalue.getYear(), dtvalue.getMonth(), dtvalue.getDay());
                return FormatDate.formatNumber(component, week, format, defaultFormat, numberer, context);
            }
            case 'w': {
                if (ignoreDate) {
                    XPathException error = new XPathException("In formatTime(): cannot obtain the week number from an xs:time value");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int week = DateValue.getWeekNumberWithinMonth(dtvalue.getYear(), dtvalue.getMonth(), dtvalue.getDay());
                return FormatDate.formatNumber(component, week, format, defaultFormat, numberer, context);
            }
            case 'H': {
                if (ignoreTime) {
                    XPathException error = new XPathException("In formatDate(): an xs:date value does not contain an hour component");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                Int64Value hour = (Int64Value)value.getComponent(4);
                return FormatDate.formatNumber(component, (int)hour.longValue(), format, defaultFormat, numberer, context);
            }
            case 'h': {
                if (ignoreTime) {
                    XPathException error = new XPathException("In formatDate(): an xs:date value does not contain an hour component");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                Int64Value hour = (Int64Value)value.getComponent(4);
                int hr = (int)hour.longValue();
                if (hr > 12) {
                    hr -= 12;
                }
                if (hr == 0) {
                    hr = 12;
                }
                return FormatDate.formatNumber(component, hr, format, defaultFormat, numberer, context);
            }
            case 'm': {
                if (ignoreTime) {
                    XPathException error = new XPathException("In formatDate(): an xs:date value does not contain a minutes component");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                Int64Value min = (Int64Value)value.getComponent(5);
                return FormatDate.formatNumber(component, (int)min.longValue(), format, defaultFormat, numberer, context);
            }
            case 's': {
                if (ignoreTime) {
                    XPathException error = new XPathException("In formatDate(): an xs:date value does not contain a seconds component");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                IntegerValue sec = (IntegerValue)value.getComponent(12);
                return FormatDate.formatNumber(component, (int)sec.longValue(), format, defaultFormat, numberer, context);
            }
            case 'f': {
                if (ignoreTime) {
                    XPathException error = new XPathException("In formatDate(): an xs:date value does not contain a fractional seconds component");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int micros = (int)((Int64Value)value.getComponent(11)).longValue();
                return FormatDate.formatNumber(component, micros, format, defaultFormat, numberer, context);
            }
            case 'Z': 
            case 'z': {
                return FormatDate.formatTimeZone(value.toDateTime(), component.charAt(0), format, country);
            }
            case 'F': {
                if (ignoreDate) {
                    XPathException error = new XPathException("In formatTime(): an xs:time value does not contain day-of-week component");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int day = DateValue.getDayOfWeek(dtvalue.getYear(), dtvalue.getMonth(), dtvalue.getDay());
                return FormatDate.formatNumber(component, day, format, defaultFormat, numberer, context);
            }
            case 'P': {
                if (ignoreTime) {
                    XPathException error = new XPathException("In formatDate(): an xs:date value does not contain an am/pm component");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int minuteOfDay = dtvalue.getHour() * 60 + dtvalue.getMinute();
                return FormatDate.formatNumber(component, minuteOfDay, format, defaultFormat, numberer, context);
            }
            case 'C': {
                return numberer.getCalendarName("AD");
            }
            case 'E': {
                if (ignoreDate) {
                    XPathException error = new XPathException("In formatTime(): an xs:time value does not contain an AD/BC component");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int year = dtvalue.getYear();
                return numberer.getEraName(year);
            }
        }
        XPathException e = new XPathException("Unknown formatDate/time component specifier '" + format.charAt(0) + '\'');
        e.setErrorCode("XTDE1340");
        e.setXPathContext(context);
        throw e;
    }

    private static CharSequence formatNumber(String component, int value, String format, boolean defaultFormat, Numberer numberer, XPathContext context) throws XPathException {
        Matcher matcher = formatPattern.matcher(format);
        if (!matcher.matches()) {
            XPathException error = new XPathException("Unrecognized format picture [" + component + format + ']');
            error.setErrorCode("XTDE1340");
            error.setXPathContext(context);
            throw error;
        }
        String primary = matcher.group(1);
        String modifier = null;
        if (primary.endsWith("t")) {
            primary = primary.substring(0, primary.length() - 1);
            modifier = "t";
        } else if (primary.endsWith("o")) {
            primary = primary.substring(0, primary.length() - 1);
            modifier = "o";
        }
        String letterValue = "t".equals(modifier) ? "traditional" : null;
        String ordinal = "o".equals(modifier) ? numberer.getOrdinalSuffixForDateTime(component) : null;
        String widths = matcher.group(2);
        if (!alphanumericPattern.matcher(primary).matches()) {
            XPathException error = new XPathException("In format picture at '" + primary + "', primary format must be alphanumeric");
            error.setErrorCode("XTDE1340");
            error.setXPathContext(context);
            throw error;
        }
        int min = 1;
        int max = Integer.MAX_VALUE;
        if (widths == null || "".equals(widths)) {
            int len;
            if (digitsPattern.matcher(primary).matches() && (len = StringValue.getStringLength(primary)) > 1) {
                min = len;
                max = len;
            }
        } else {
            if (primary.equals("I") || primary.equals("i")) {
                int[] range = FormatDate.getWidths(widths);
                min = range[0];
                max = Integer.MAX_VALUE;
                String s = numberer.format(value, UnicodeString.makeUnicodeString(primary), null, letterValue, ordinal);
                for (int len = StringValue.getStringLength(s); len < min; ++len) {
                    s = s + ' ';
                }
                return s;
            }
            int[] range = FormatDate.getWidths(widths);
            min = range[0];
            max = range[1];
            if (defaultFormat && primary.endsWith("1") && min != primary.length()) {
                FastStringBuffer sb = new FastStringBuffer(min + 1);
                for (int i = 1; i < min; ++i) {
                    sb.append('0');
                }
                sb.append('1');
                primary = sb.toString();
            }
        }
        if ("P".equals(component)) {
            if (!("N".equals(primary) || "n".equals(primary) || "Nn".equals(primary))) {
                primary = "n";
            }
            if (max == Integer.MAX_VALUE) {
                max = 4;
            }
        } else if ("f".equals(component)) {
            String s;
            if (value == 0) {
                s = "0";
            } else {
                s = (1000000 + value + "").substring(1);
                if (s.length() > max) {
                    DecimalValue dec = new DecimalValue(new BigDecimal("0." + s));
                    s = (dec = (DecimalValue)dec.roundHalfToEven(max)).getStringValue();
                    s = s.length() > 2 ? s.substring(2) : "";
                }
            }
            while (s.length() < min) {
                s = s + '0';
            }
            while (s.length() > min && s.charAt(s.length() - 1) == '0') {
                s = s.substring(0, s.length() - 1);
            }
            return s;
        }
        if ("N".equals(primary) || "n".equals(primary) || "Nn".equals(primary)) {
            String s = "";
            if ("M".equals(component)) {
                s = numberer.monthName(value, min, max);
            } else if ("F".equals(component)) {
                s = numberer.dayName(value, min, max);
            } else if ("P".equals(component)) {
                s = numberer.halfDayName(value, min, max);
            } else {
                primary = "1";
            }
            if ("N".equals(primary)) {
                return s.toUpperCase();
            }
            if ("n".equals(primary)) {
                return s.toLowerCase();
            }
            return s;
        }
        String s = numberer.format(value, UnicodeString.makeUnicodeString(primary), null, letterValue, ordinal);
        int len = StringValue.getStringLength(s);
        while (len < min) {
            s = ("00000000" + s).substring(s.length() + 8 - min);
            len = StringValue.getStringLength(s);
        }
        if (len > max && component.charAt(0) == 'Y') {
            s = len == s.length() ? s.substring(s.length() - max) : s.substring(s.length() - 2 * max);
        }
        return s;
    }

    private static int[] getWidths(String widths) throws XPathException {
        try {
            int min = -1;
            int max = -1;
            if (!"".equals(widths)) {
                Matcher widthMatcher = widthPattern.matcher(widths);
                if (widthMatcher.matches()) {
                    String smin = widthMatcher.group(1);
                    min = smin == null || "".equals(smin) || "*".equals(smin) ? 1 : Integer.parseInt(smin);
                    String smax = widthMatcher.group(3);
                    max = smax == null || "".equals(smax) || "*".equals(smax) ? Integer.MAX_VALUE : Integer.parseInt(smax);
                } else {
                    XPathException error = new XPathException("Unrecognized width specifier " + Err.wrap(widths, 4));
                    error.setErrorCode("XTDE1340");
                    throw error;
                }
            }
            if (min > max && max != -1) {
                XPathException e = new XPathException("Minimum width in date/time picture exceeds maximum width");
                e.setErrorCode("XTDE1340");
                throw e;
            }
            int[] result = new int[]{min, max};
            return result;
        }
        catch (NumberFormatException err) {
            XPathException e = new XPathException("Invalid integer used as width in date/time picture");
            e.setErrorCode("XTDE1340");
            throw e;
        }
    }

    private static String formatTimeZone(DateTimeValue value, char component, String format, String country) throws XPathException {
        int[] expandedFormat;
        int comma = format.lastIndexOf(44);
        String widthModifier = "";
        if (comma >= 0) {
            widthModifier = format.substring(comma);
            format = format.substring(0, comma);
        }
        if (!value.hasTimezone()) {
            if (format.equals("Z")) {
                return "J";
            }
            return "";
        }
        if (format.length() == 0 && widthModifier.length() > 0) {
            int[] widths = FormatDate.getWidths(widthModifier);
            int min = widths[0];
            int max = widths[1];
            format = min <= 1 ? (max >= 4 ? "0:00" : "0") : (min <= 4 ? (max >= 5 ? "00:00" : "00") : "00:00");
        }
        if (format.length() == 0) {
            format = "00:00";
        }
        int tz = value.getTimezoneInMinutes();
        boolean useZforZero = format.endsWith("t");
        if (useZforZero && tz == 0) {
            return "Z";
        }
        if (useZforZero) {
            format = format.substring(0, format.length() - 1);
        }
        int digits = 0;
        int separators = 0;
        int separatorChar = 58;
        int zeroDigit = -1;
        for (int ch : expandedFormat = StringValue.expand(format)) {
            if (Character.isDigit(ch)) {
                ++digits;
                if (zeroDigit >= 0) continue;
                zeroDigit = Alphanumeric.getDigitFamily(ch);
                continue;
            }
            ++separators;
            separatorChar = ch;
        }
        int[] buffer = new int[10];
        int used = 0;
        if (digits > 0) {
            int hourDigits;
            if (component == 'z') {
                buffer[0] = 71;
                buffer[1] = 77;
                buffer[2] = 84;
                used = 3;
            }
            boolean negative = tz < 0;
            tz = Math.abs(tz);
            buffer[used++] = negative ? 45 : 43;
            int hour = tz / 60;
            int minute = tz % 60;
            boolean includeMinutes = minute != 0 || digits >= 3 || separators > 0;
            boolean includeSep = minute != 0 && digits <= 2 || separators > 0 && (minute != 0 || digits >= 3);
            int n = hourDigits = digits <= 2 ? digits : digits - 2;
            if (hour > 9 || hourDigits >= 2) {
                buffer[used++] = zeroDigit + hour / 10;
            }
            buffer[used++] = hour % 10 + zeroDigit;
            if (includeSep) {
                buffer[used++] = separatorChar;
            }
            if (includeMinutes) {
                buffer[used++] = minute / 10 + zeroDigit;
                buffer[used++] = minute % 10 + zeroDigit;
            }
            return ((Object)StringValue.contract(buffer, used)).toString();
        }
        if (format.equals("Z")) {
            int hour = tz / 60;
            int minute = tz % 60;
            if (hour < -12 || hour > 12 || minute != 0) {
                return FormatDate.formatTimeZone(value, 'Z', "00:00", country);
            }
            return Character.toString("YXWVUTSRQPONZABCDEFGHIKLM".charAt(hour + 12));
        }
        if (format.charAt(0) == 'N' || format.charAt(0) == 'n') {
            return FormatDate.getNamedTimeZone(value, country, format);
        }
        return FormatDate.formatTimeZone(value, 'Z', "00:00", country);
    }

    private static String getNamedTimeZone(DateTimeValue value, String country, String format) throws XPathException {
        int min = 1;
        int comma = format.indexOf(44);
        if (comma > 0) {
            String widths = format.substring(comma);
            int[] range = FormatDate.getWidths(widths);
            min = range[0];
        }
        if (format.charAt(0) == 'N' || format.charAt(0) == 'n') {
            if (min <= 5) {
                String tzname = NamedTimeZone.getTimeZoneNameForDate(value, country);
                if (format.charAt(0) == 'n') {
                    tzname = tzname.toLowerCase();
                }
                return tzname;
            }
            return NamedTimeZone.getOlsenTimeZoneName(value, country);
        }
        FastStringBuffer sbz = new FastStringBuffer(8);
        value.appendTimezone(sbz);
        return sbz.toString();
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        CalendarValue value = (CalendarValue)arguments[0].head();
        if (value == null) {
            return EmptySequence.getInstance();
        }
        String format = arguments[1].head().getStringValue();
        StringValue calendarVal = null;
        AtomicValue countryVal = null;
        AtomicValue languageVal = null;
        if (this.argument.length > 2) {
            languageVal = (StringValue)arguments[2].head();
            calendarVal = (StringValue)arguments[3].head();
            countryVal = (StringValue)arguments[4].head();
        }
        String language = languageVal == null ? null : languageVal.getStringValue();
        String country = countryVal == null ? null : countryVal.getStringValue();
        CharSequence result = FormatDate.formatDate(value, format, language, country, context);
        if (calendarVal != null) {
            result = this.adjustCalendar(calendarVal, result, context);
        }
        return new StringValue(result);
    }
}

