/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.HashSet;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.VennPattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;

public class UnionPattern
extends VennPattern {
    public UnionPattern(Pattern p1, Pattern p2) {
        super(p1, p2);
    }

    public ItemType getItemType() {
        ItemType t1 = this.p1.getItemType();
        ItemType t2 = this.p2.getItemType();
        return Type.getCommonSuperType(t1, t2);
    }

    public boolean matches(Item item, XPathContext context) throws XPathException {
        return this.p1.matches(item, context) || this.p2.matches(item, context);
    }

    public boolean matchesBeneathAnchor(NodeInfo node, NodeInfo anchor, XPathContext context) throws XPathException {
        return this.p1.matchesBeneathAnchor(node, anchor, context) || this.p2.matchesBeneathAnchor(node, anchor, context);
    }

    public boolean equals(Object other) {
        if (other instanceof UnionPattern) {
            HashSet<Pattern> s0 = new HashSet<Pattern>(10);
            this.gatherComponentPatterns(s0);
            HashSet<Pattern> s1 = new HashSet<Pattern>(10);
            ((UnionPattern)other).gatherComponentPatterns(s1);
            return ((Object)s0).equals(s1);
        }
        return false;
    }

    public int hashCode() {
        return 0x9BD723A6 ^ this.p1.hashCode() ^ this.p2.hashCode();
    }
}

