/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.sort.GenericSorter;
import net.sf.saxon.expr.sort.Sortable;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class AttributeSorter
extends ProxyReceiver
implements Sortable {
    private Map<NodeName, Integer> knownAttributes;
    private AttributeCollectionImpl attributes;

    public AttributeSorter(Receiver next) {
        super(next);
    }

    public void setOutputProperties(Properties details) throws XPathException {
        String attOrder = details.getProperty("{http://saxon.sf.net/}attribute-order");
        if (attOrder == null) {
            attOrder = "";
        }
        this.knownAttributes = new HashMap<NodeName, Integer>();
        int pos = 0;
        StringTokenizer st2 = new StringTokenizer(attOrder, " \t\n\r", false);
        while (st2.hasMoreTokens()) {
            String expandedName = st2.nextToken();
            StructuredQName sq = StructuredQName.fromClarkName(expandedName);
            this.knownAttributes.put(new FingerprintedQName("", sq.getURI(), sq.getLocalPart()), pos++);
        }
    }

    public void startElement(NodeName elemName, SchemaType typeCode, int locationId, int properties) throws XPathException {
        this.attributes = new AttributeCollectionImpl(this.getConfiguration());
        super.startElement(elemName, typeCode, locationId, properties);
    }

    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        this.attributes.addAttribute(nameCode, typeCode, ((Object)value).toString(), locationId, properties);
    }

    public void startContent() throws XPathException {
        if (this.attributes.getLength() > 1) {
            GenericSorter.quickSort(0, this.attributes.getLength(), this);
        }
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            this.nextReceiver.attribute(this.attributes.getNodeName(i), this.attributes.getTypeAnnotation(i), this.attributes.getValue(i), this.attributes.getLocationId(i), this.attributes.getProperties(i));
        }
        super.startContent();
    }

    public int compare(int a, int b) {
        NodeName n0 = this.attributes.getNodeName(a);
        NodeName n1 = this.attributes.getNodeName(b);
        Integer r0 = this.knownAttributes.get(n0);
        Integer r1 = this.knownAttributes.get(n1);
        if (r0 != null) {
            if (r1 == null) {
                return -1;
            }
            return r0.compareTo(r1);
        }
        if (r1 != null) {
            return 1;
        }
        int x = n0.getURI().compareTo(n1.getURI());
        if (x == 0) {
            x = n1.getLocalPart().compareTo(n1.getLocalPart());
        }
        return x;
    }

    public void swap(int a, int b) {
        this.attributes.swap(a, b);
    }
}

