/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.linked;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import net.sf.saxon.event.CopyInformee;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.CopyOptions;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.AttributeImpl;
import net.sf.saxon.tree.linked.DocumentImpl;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.tree.linked.ParentNodeImpl;
import net.sf.saxon.tree.linked.TextImpl;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementImpl
extends ParentNodeImpl
implements NamespaceResolver {
    private int nameCode;
    private int typeCode = 630;
    private AttributeCollection attributeList;
    private NamespaceBinding[] namespaceList = null;

    public void setNameCode(int nameCode) {
        this.nameCode = nameCode;
    }

    public void setAttributeList(AttributeCollection atts) {
        this.attributeList = atts;
    }

    public void setNamespaceList(NamespaceBinding[] namespaces) {
        this.namespaceList = namespaces;
    }

    public void initialise(NodeName elemName, SchemaType elementType, AttributeCollectionImpl atts, NodeInfo parent, int sequenceNumber) {
        this.setNameCode(elemName.allocateNameCode(parent.getNamePool()));
        this.typeCode = elementType.getFingerprint();
        this.setRawParent((ParentNodeImpl)parent);
        this.setRawSequenceNumber(sequenceNumber);
        this.attributeList = atts;
    }

    public void setLocation(String systemId, int line, int column) {
        DocumentImpl root = this.getRawParent().getPhysicalRoot();
        root.setLineAndColumn(this.getRawSequenceNumber(), line, column);
        root.setSystemId(this.getRawSequenceNumber(), systemId);
    }

    @Override
    public void setSystemId(String uri) {
        this.getPhysicalRoot().setSystemId(this.getRawSequenceNumber(), uri);
    }

    @Override
    public NodeInfo getRoot() {
        ParentNodeImpl up = this.getRawParent();
        if (up == null || up instanceof DocumentImpl && ((DocumentImpl)up).isImaginary()) {
            return this;
        }
        return up.getRoot();
    }

    @Override
    public DocumentInfo getDocumentRoot() {
        NodeInfo root = this.getRoot();
        if (root instanceof DocumentInfo) {
            return (DocumentInfo)root;
        }
        return null;
    }

    @Override
    public final String getSystemId() {
        DocumentImpl root = this.getPhysicalRoot();
        return root == null ? null : root.getSystemId(this.getRawSequenceNumber());
    }

    @Override
    public String getBaseURI() {
        return Navigator.getBaseURI(this);
    }

    public AttributeCollection gsetAttributeCollection() {
        return this.attributeList;
    }

    @Override
    public boolean isNilled() {
        return (this.typeCode & 0x20000000) != 0;
    }

    @Override
    public void setTypeAnnotation(int typeCode) {
        if (typeCode == -1) {
            typeCode = 630;
        }
        this.typeCode = typeCode;
    }

    @Override
    public int getTypeAnnotation() {
        return this.typeCode & 0xFFFFF;
    }

    @Override
    public SchemaType getSchemaType() {
        if (this.typeCode == 630) {
            return Untyped.getInstance();
        }
        return this.getConfiguration().getSchemaType(this.typeCode & 0xFFFFF);
    }

    @Override
    public int getLineNumber() {
        DocumentImpl root = this.getPhysicalRoot();
        if (root == null) {
            return -1;
        }
        return root.getLineNumber(this.getRawSequenceNumber());
    }

    @Override
    public int getColumnNumber() {
        DocumentImpl root = this.getPhysicalRoot();
        if (root == null) {
            return -1;
        }
        return root.getColumnNumber(this.getRawSequenceNumber());
    }

    @Override
    public int getNameCode() {
        return this.nameCode;
    }

    @Override
    public void generateId(FastStringBuffer buffer) {
        int sequence = this.getRawSequenceNumber();
        if (sequence >= 0) {
            this.getPhysicalRoot().generateId(buffer);
            buffer.append("e");
            buffer.append(Integer.toString(sequence));
        } else {
            this.getRawParent().generateId(buffer);
            buffer.append("f");
            buffer.append(Integer.toString(this.getSiblingPosition()));
        }
    }

    @Override
    public final int getNodeKind() {
        return 1;
    }

    @Override
    public void copy(Receiver out, int copyOptions, int locationId) throws XPathException {
        SchemaType typeCode = CopyOptions.includes(copyOptions, 4) ? this.getSchemaType() : Untyped.getInstance();
        CopyInformee informee = (CopyInformee)out.getPipelineConfiguration().getComponent(CopyInformee.class.getName());
        if (informee != null) {
            locationId = informee.notifyElementNode(this);
        }
        out.startElement(new NameOfNode(this), typeCode, locationId, 0);
        int childCopyOptions = copyOptions & 0xFFFFFFFD;
        if ((copyOptions & 1) != 0) {
            NamespaceBinding[] localNamespaces;
            for (NamespaceBinding ns : localNamespaces = this.getDeclaredNamespaces(null)) {
                if (ns == null) break;
                out.namespace(ns, 0);
            }
        } else if ((copyOptions & 2) != 0) {
            NamespaceIterator.sendNamespaces(this, out);
            childCopyOptions |= 1;
        }
        if (this.attributeList != null) {
            for (int i = 0; i < this.attributeList.getLength(); ++i) {
                NodeName nc = this.attributeList.getNodeName(i);
                if (nc == null) continue;
                out.attribute(nc, BuiltInAtomicType.UNTYPED_ATOMIC, this.attributeList.getValue(i), 0, 0);
            }
        }
        out.startContent();
        for (NodeImpl next = this.getFirstChild(); next != null; next = next.getNextSibling()) {
            next.copy(out, childCopyOptions, locationId);
        }
        out.endElement();
    }

    @Override
    public void delete() {
        DocumentImpl root = this.getPhysicalRoot();
        super.delete();
        if (root != null) {
            AxisIterator iter = this.iterateAxis((byte)5, NodeKindTest.ELEMENT);
            while (true) {
                ElementImpl n = (ElementImpl)iter.next();
                int atts = this.attributeList.getLength();
                for (int index = 0; index < atts; ++index) {
                    if (!this.attributeList.isId(index)) continue;
                    root.deregisterID(this.attributeList.getValue(index));
                }
                if (n == null) break;
                root.deIndex(n);
            }
        }
    }

    @Override
    public void rename(NodeName newName) {
        String prefix = newName.getPrefix();
        String uri = newName.getURI();
        NamespaceBinding ns = new NamespaceBinding(prefix, uri);
        String uc = this.getURIForPrefix(prefix, true);
        if (uc == null) {
            uc = "";
        }
        if (!uc.equals(uri)) {
            if (uc.length() == 0) {
                this.addNamespace(ns, true);
            } else {
                throw new IllegalArgumentException("Namespace binding of new name conflicts with existing namespace binding");
            }
        }
        this.nameCode = this.getNamePool().allocate(prefix, uri, newName.getLocalPart());
    }

    @Override
    public void addNamespace(NamespaceBinding nscode, boolean inherit) {
        if (nscode.getURI().length() == 0) {
            throw new IllegalArgumentException("Cannot add a namespace undeclaration");
        }
        this.addNamespaceInternal(nscode, true);
        if (this.hasChildNodes() && !inherit) {
            ElementImpl child;
            AxisIterator kids = this.iterateChildren(NodeKindTest.ELEMENT);
            while ((child = (ElementImpl)kids.next()) != null) {
                child.addNamespaceInternal(nscode, false);
            }
        }
    }

    private void addNamespaceInternal(NamespaceBinding nscode, boolean externalCall) {
        if (this.namespaceList == null) {
            this.namespaceList = new NamespaceBinding[]{nscode};
        } else {
            NamespaceBinding[] nsList = this.namespaceList;
            for (int i = 0; i < nsList.length; ++i) {
                if (nsList[i].equals(nscode)) {
                    return;
                }
                if (!nsList[i].getPrefix().equals(nscode.getPrefix())) continue;
                if (nsList[i].getURI().length() == 0) {
                    nsList[i] = nscode;
                    return;
                }
                if (externalCall) {
                    throw new IllegalArgumentException("New namespace conflicts with existing namespace binding");
                }
                return;
            }
            int len = nsList.length;
            NamespaceBinding[] ns2 = new NamespaceBinding[len + 1];
            System.arraycopy(nsList, 0, ns2, 0, len);
            ns2[len] = nscode;
            this.namespaceList = ns2;
        }
    }

    @Override
    public void replaceStringValue(CharSequence stringValue) {
        if (stringValue.length() == 0) {
            this.setChildren(null);
        } else {
            TextImpl text = new TextImpl(((Object)stringValue).toString());
            text.setRawParent(this);
            this.setChildren(text);
        }
    }

    @Override
    public void addAttribute(NodeName nameCode, SimpleType attType, CharSequence value, int properties) {
        DocumentImpl root;
        AttributeCollectionImpl atts;
        int index;
        if (this.attributeList == null || this.attributeList.getLength() == 0) {
            this.attributeList = new AttributeCollectionImpl(this.getConfiguration());
        }
        if ((index = (atts = (AttributeCollectionImpl)this.attributeList).findByNodeName(nameCode)) != -1) {
            throw new IllegalStateException("Cannot add an attribute to an element as it already has an attribute with the specified name");
        }
        atts.addAttribute(nameCode, attType, ((Object)value).toString(), 0, 0);
        if (!nameCode.isInNamespace("")) {
            NamespaceBinding binding = nameCode.getNamespaceBinding();
            String prefix = binding.getPrefix();
            String uc = this.getURIForPrefix(prefix, false);
            if (uc == null) {
                this.addNamespace(binding, true);
            } else if (!uc.equals(binding.getURI())) {
                throw new IllegalStateException("Namespace binding of new name conflicts with existing namespace binding");
            }
        }
        if ((properties & 0x800) != 0 && (root = this.getPhysicalRoot()) != null) {
            root.registerID(this, Whitespace.trim(value));
        }
    }

    @Override
    public void removeAttribute(NodeInfo attribute) {
        if (!(attribute instanceof AttributeImpl)) {
            return;
        }
        AttributeCollectionImpl atts = (AttributeCollectionImpl)this.getAttributeList();
        int index = ((AttributeImpl)attribute).getSiblingPosition();
        if (index >= 0 && atts.isId(index)) {
            DocumentImpl root = this.getPhysicalRoot();
            root.deregisterID(atts.getValue(index));
        }
        atts.removeAttribute(index);
        ((AttributeImpl)attribute).setRawParent(null);
    }

    @Override
    public void removeTypeAnnotation() {
        int t = this.getTypeAnnotation();
        if (t != 630) {
            this.typeCode = 572;
            this.getRawParent().removeTypeAnnotation();
        }
    }

    public void setNamespaceDeclarations(NamespaceBinding[] namespaces, int namespacesUsed) {
        this.namespaceList = new NamespaceBinding[namespacesUsed];
        System.arraycopy(namespaces, 0, this.namespaceList, 0, namespacesUsed);
    }

    @Override
    public String getURIForPrefix(String prefix, boolean useDefault) {
        ParentNodeImpl next;
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.length() == 0 && !useDefault) {
            return "";
        }
        if (this.namespaceList != null) {
            for (NamespaceBinding aNamespaceList : this.namespaceList) {
                if (!aNamespaceList.getPrefix().equals(prefix)) continue;
                String uri = aNamespaceList.getURI();
                return uri.length() == 0 && prefix.length() != 0 ? null : uri;
            }
        }
        if ((next = this.getRawParent()).getNodeKind() == 9) {
            return prefix.length() == 0 ? "" : null;
        }
        return ((ElementImpl)next).getURIForPrefix(prefix, useDefault);
    }

    @Override
    public Iterator<String> iteratePrefixes() {
        return new Iterator<String>(){
            private NamePool pool = null;
            private Iterator<NamespaceBinding> iter = NamespaceIterator.iterateNamespaces(ElementImpl.this);

            @Override
            public boolean hasNext() {
                return this.pool == null || this.iter.hasNext();
            }

            @Override
            public String next() {
                if (this.pool == null) {
                    this.pool = ElementImpl.this.getNamePool();
                    return "xml";
                }
                return this.iter.next().getPrefix();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    public String getPrefixForURI(String uri) {
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        Iterator<String> iter = this.iteratePrefixes();
        while (iter.hasNext()) {
            String prefix = iter.next();
            if (!uri.equals(this.getURIForPrefix(prefix, true))) continue;
            return uri;
        }
        return null;
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        return this.namespaceList == null ? NamespaceBinding.EMPTY_ARRAY : this.namespaceList;
    }

    protected void fixupInsertedNamespaces(boolean inherit) {
        if (this.getRawParent().getNodeKind() == 9) {
            return;
        }
        HashSet<NamespaceBinding> childNamespaces = new HashSet<NamespaceBinding>();
        if (this.namespaceList != null) {
            childNamespaces.addAll(Arrays.asList(this.namespaceList));
        }
        InscopeNamespaceResolver inscope = new InscopeNamespaceResolver(this.getRawParent());
        if (this.getURI().length() == 0 && inscope.getURIForPrefix("", true).length() != 0) {
            childNamespaces.add(NamespaceBinding.DEFAULT_UNDECLARATION);
        }
        if (!inherit) {
            Iterator<String> it = inscope.iteratePrefixes();
            while (it.hasNext()) {
                String prefix = it.next();
                if (prefix.equals("xml")) continue;
                boolean found = false;
                if (this.namespaceList != null) {
                    for (NamespaceBinding aNamespaceList : this.namespaceList) {
                        if (!aNamespaceList.getPrefix().equals(prefix)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                childNamespaces.add(new NamespaceBinding(prefix, ""));
            }
        }
        if (this.namespaceList != null) {
            for (NamespaceBinding nscode : this.namespaceList) {
                String prefix = nscode.getPrefix();
                String uri = nscode.getURI();
                String parentUri = inscope.getURIForPrefix(prefix, true);
                if (parentUri == null || !parentUri.equals(uri)) continue;
                childNamespaces.remove(nscode);
            }
        }
        NamespaceBinding[] n2 = new NamespaceBinding[childNamespaces.size()];
        int j = 0;
        for (NamespaceBinding childNamespace : childNamespaces) {
            n2[j++] = childNamespace;
        }
        this.namespaceList = n2;
    }

    public AttributeCollection getAttributeList() {
        return this.attributeList == null ? AttributeCollectionImpl.EMPTY_ATTRIBUTE_COLLECTION : this.attributeList;
    }

    public NamespaceBinding[] getNamespaceList() {
        return this.namespaceList;
    }

    @Override
    public String getAttributeValue(String uri, String localName) {
        return this.attributeList == null ? null : this.attributeList.getValue(uri, localName);
    }

    @Override
    public String getAttributeValue(int fp) {
        return this.attributeList == null ? null : this.attributeList.getValueByFingerprint(fp);
    }

    @Override
    public boolean isId() {
        SchemaType type = this.getSchemaType();
        return type.getFingerprint() == 560 || type.isIdType() && this.getConfiguration().getNameChecker().isValidNCName(this.getStringValueCS());
    }
}

