/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.RangeIterator;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerRange
implements AtomicSequence,
GroundedValue {
    public long start;
    public long end;

    public IntegerRange(long start, long end) {
        if (end < start) {
            throw new IllegalArgumentException("end < start in IntegerRange");
        }
        if (end - start > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Maximum length of sequence in Saxon is 2147483647");
        }
        this.start = start;
        this.end = end;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public SequenceIterator<IntegerValue> iterate() {
        try {
            return new RangeIterator(this.start, this.end);
        }
        catch (XPathException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.INTEGER;
    }

    public int getCardinality() {
        return 32768;
    }

    @Override
    public IntegerValue itemAt(int n) {
        if (n < 0 || (long)n > this.end - this.start) {
            return null;
        }
        return Int64Value.makeIntegerValue(this.start + (long)n);
    }

    @Override
    public GroundedValue subsequence(int start, int length) {
        if (length <= 0) {
            return EmptySequence.getInstance();
        }
        long newStart = this.start + (long)(start > 0 ? start : 0);
        long newEnd = newStart + (long)length - 1L;
        if (newEnd > this.end) {
            newEnd = this.end;
        }
        if (newEnd >= newStart) {
            return new IntegerRange(newStart, newEnd);
        }
        return EmptySequence.getInstance();
    }

    @Override
    public int getLength() {
        return (int)(this.end - this.start + 1L);
    }

    @Override
    public AtomicValue head() {
        return new Int64Value(this.start);
    }

    @Override
    public CharSequence getCanonicalLexicalRepresentation() {
        return this.getStringValueCS();
    }

    @Override
    public Comparable getSchemaComparable() {
        try {
            return new AtomicArray(this.iterate()).getSchemaComparable();
        }
        catch (XPathException err) {
            throw new AssertionError((Object)err);
        }
    }

    @Override
    public CharSequence getStringValueCS() {
        try {
            return SequenceTool.getStringValue(this);
        }
        catch (XPathException err) {
            throw new AssertionError((Object)err);
        }
    }

    @Override
    public String getStringValue() {
        return ((Object)this.getStringValueCS()).toString();
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.iterate());
    }

    @Override
    public GroundedValue reduce() {
        if (this.start == this.end) {
            return this.itemAt(0);
        }
        return this;
    }
}

