/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rmi;

import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import org.apache.camel.CamelContext;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.component.bean.RegistryBean;

public class RmiRegistryBean
extends RegistryBean {
    private final Registry registry;

    public RmiRegistryBean(CamelContext context, String name, Registry registry) {
        super(context, name);
        this.registry = registry;
    }

    public RmiRegistryBean(CamelContext context, String name, ParameterMappingStrategy parameterMappingStrategy, Registry registry) {
        super(context, name);
        this.registry = registry;
        this.setParameterMappingStrategy(parameterMappingStrategy);
    }

    protected Object lookupBean() throws NoSuchBeanException {
        try {
            return this.registry.lookup(this.getName());
        }
        catch (NotBoundException e) {
            throw new NoSuchBeanException(this.getName(), (Throwable)e);
        }
        catch (AccessException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

