/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fuse.commands;

import io.fabric8.utils.shell.ShellUtils;
import java.io.File;
import java.io.IOException;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(name="create-admin-user", scope="esb", description="Creates a new admin user if one doesn't exist")
public class CreateAdminUser
extends OsgiCommandSupport {
    @Option(name="--new-user", multiValued=false, description="The username of a new user. The option refers to karaf user (ssh, http, jmx).")
    private String newUser;
    @Option(name="--new-user-password", multiValued=false, description="The password of the new user. The option refers to karaf user (ssh, http, jmx).")
    private String newUserPassword;
    @Option(name="--new-user-role", multiValued=false, description="The role of the new user. The option refers to karaf user (ssh, http, jmx).")
    private String newUserRole = "admin";

    protected Object doExecute() throws Exception {
        Properties userProps = new Properties(new File(System.getProperty("karaf.home") + "/etc/users.properties"));
        if (userProps.isEmpty() && (this.newUser == null || this.newUserPassword == null)) {
            String[] credentials = this.promptForNewUser(this.newUser, this.newUserPassword);
            this.newUser = credentials[0];
            this.newUserPassword = credentials[1];
        }
        if (this.newUser == null) {
            System.out.println("No user specified. Some features may not be accessible.");
            return null;
        }
        if (this.session != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("jaas:manage --realm karaf --index 1;").append("jaas:useradd ").append(this.newUser).append(" ").append(this.newUserPassword).append(";").append("jaas:roleadd ").append(this.newUser).append(" ").append(this.newUserRole).append(";").append("jaas:update");
            this.session.execute((CharSequence)sb.toString());
        }
        return null;
    }

    protected String[] promptForNewUser(String user, String password) throws IOException {
        String[] response = new String[2];
        if (user == null || password == null) {
            System.out.println("Please specify a user...");
        }
        while ((user == null || user.isEmpty()) && (user = ShellUtils.readLine(this.session, "New user name: ", false)) != null) {
        }
        if (user != null && password == null) {
            String password1 = null;
            String password2 = null;
            while (password1 == null || !password1.equals(password2)) {
                password1 = ShellUtils.readLine(this.session, "Password for " + user + ": ", true);
                password2 = ShellUtils.readLine(this.session, "Verify password for " + user + ": ", true);
                if (password1 == null || password2 == null) break;
                if (password1 != null && password1.equals(password2)) {
                    password = password1;
                    continue;
                }
                System.out.println("Passwords did not match. Please try again!");
            }
        }
        response[0] = user;
        response[1] = password;
        return response;
    }

    public String getNewUser() {
        return this.newUser;
    }

    public void setNewUser(String newUser) {
        this.newUser = newUser;
    }

    public String getNewUserPassword() {
        return this.newUserPassword;
    }

    public void setNewUserPassword(String newUserPassword) {
        this.newUserPassword = newUserPassword;
    }
}

