/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api;

import io.fabric8.api.ContainerOptions;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.jcip.Immutable;
import io.fabric8.api.jcip.ThreadSafe;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonProperty;

@Immutable
@ThreadSafe
public class CreateEnsembleOptions
extends ContainerOptions {
    public static final String AGENT_AUTOSTART = "agent.auto.start";
    public static final String ENSEMBLE_AUTOSTART = "ensemble.auto.start";
    public static final String PROFILES_AUTOIMPORT = "profiles.auto.import";
    public static final String PROFILES_AUTOIMPORT_PATH = "profiles.auto.import.path";
    public static final String DEFAULT_IMPORT_PATH = "fabric" + File.separatorChar + "import";
    public static final String ZOOKEEPER_PASSWORD = "zookeeper.password";
    public static String ZOOKEEPER_SERVER_PORT = "zookeeper.server.port";
    public static String ZOOKEEPER_SERVER_CONNECTION_PORT = "zookeeper.server.connection.port";
    public static final String ROLE_DELIMITER = ",";
    public static final long DEFAULT_MIGRATION_TIMEOUT = 120000L;
    public static final int DEFAULT_TICKTIME = 2000;
    public static final int DEFAULT_INIT_LIMIT = 10;
    public static final int DEFAULT_SYNC_LIMIT = 5;
    public static final String DEFAULT_DATA_DIR = "data/zookeeper";
    @JsonProperty
    final int zooKeeperServerPort;
    @JsonProperty
    final int zooKeeperServerConnectionPort;
    @JsonProperty
    final int zooKeeperServerTickTime;
    @JsonProperty
    final int zooKeeperServerInitLimit;
    @JsonProperty
    final int zooKeeperServerSyncLimit;
    @JsonProperty
    final String zooKeeperServerDataDir;
    @JsonProperty
    final String zookeeperPassword;
    @JsonProperty
    final boolean ensembleStart;
    @JsonProperty
    final boolean agentEnabled;
    @JsonProperty
    final boolean waitForProvision;
    @JsonProperty
    final long provisionTimeout;
    @JsonProperty
    final long migrationTimeout;
    @JsonProperty
    final boolean autoImportEnabled;
    @JsonProperty
    final String importPath;
    @JsonProperty
    final boolean clean;
    @JsonProperty
    final Map<String, String> users;

    public static Builder<? extends Builder<?>> builder() {
        return new Builder();
    }

    CreateEnsembleOptions(String bindAddress, String resolver, String globalResolver, String manualIp, int minimumPort, int maximumPort, Set<String> profiles, String version, Map<String, String> dataStoreProperties, int zooKeeperServerPort, int zooKeeperServerConnectionPort, int zooKeeperServerTickTime, int zooKeeperServerInitLimit, int zooKeeperServerSyncLimit, String zooKeeperServerDataDir, String zookeeperPassword, boolean ensembleStart, boolean agentEnabled, boolean waitForProvision, long provisionTimeout, long migrationTimeout, boolean autoImportEnabled, String importPath, Map<String, String> users, boolean clean) {
        super(bindAddress, resolver, globalResolver, manualIp, minimumPort, maximumPort, profiles, version, dataStoreProperties);
        this.zooKeeperServerPort = zooKeeperServerPort;
        this.zooKeeperServerConnectionPort = zooKeeperServerConnectionPort;
        this.zookeeperPassword = zookeeperPassword;
        this.ensembleStart = ensembleStart;
        this.agentEnabled = agentEnabled;
        this.waitForProvision = waitForProvision;
        this.provisionTimeout = provisionTimeout;
        this.migrationTimeout = migrationTimeout;
        this.autoImportEnabled = autoImportEnabled;
        this.importPath = importPath;
        this.zooKeeperServerTickTime = zooKeeperServerTickTime;
        this.zooKeeperServerInitLimit = zooKeeperServerInitLimit;
        this.zooKeeperServerSyncLimit = zooKeeperServerSyncLimit;
        this.zooKeeperServerDataDir = zooKeeperServerDataDir;
        this.users = Collections.unmodifiableMap(new HashMap<String, String>(users));
        this.clean = clean;
    }

    public int getZooKeeperServerPort() {
        return this.zooKeeperServerPort;
    }

    public int getZooKeeperServerConnectionPort() {
        return this.zooKeeperServerConnectionPort;
    }

    public int getZooKeeperServerTickTime() {
        return this.zooKeeperServerTickTime;
    }

    public int getZooKeeperServerInitLimit() {
        return this.zooKeeperServerInitLimit;
    }

    public int getZooKeeperServerSyncLimit() {
        return this.zooKeeperServerSyncLimit;
    }

    public String getZooKeeperServerDataDir() {
        return this.zooKeeperServerDataDir;
    }

    public String getZookeeperPassword() {
        return this.zookeeperPassword;
    }

    public boolean isEnsembleStart() {
        return this.ensembleStart;
    }

    public boolean isAgentEnabled() {
        return this.agentEnabled;
    }

    public boolean isAutoImportEnabled() {
        return this.autoImportEnabled;
    }

    public String getImportPath() {
        return this.importPath;
    }

    public Map<String, String> getUsers() {
        return this.users;
    }

    public boolean isWaitForProvision() {
        return this.waitForProvision;
    }

    public long getProvisionTimeout() {
        return this.provisionTimeout;
    }

    public long getMigrationTimeout() {
        return this.migrationTimeout;
    }

    public boolean isClean() {
        return this.clean;
    }

    @Override
    public String toString() {
        return super.toString() + " CreateEnsembleOptions{" + "zooKeeperServerPort=" + this.zooKeeperServerPort + ", zookeeperPassword='" + this.zookeeperPassword + '\'' + ", agentEnabled=" + this.agentEnabled + ", autoImportEnabled=" + this.autoImportEnabled + ", importPath='" + this.importPath + '\'' + ", users=" + this.users + '}';
    }

    public static String generatePassword() {
        StringBuilder password = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            long l = Math.round(Math.floor(Math.random() * 62.0));
            if (l < 10L) {
                password.append((char)(48L + l));
                continue;
            }
            if (l < 36L) {
                password.append((char)(65L + l - 10L));
                continue;
            }
            password.append((char)(97L + l - 36L));
        }
        return password.toString();
    }

    public static class Builder<B extends Builder<?>>
    extends ContainerOptions.Builder<B> {
        @JsonProperty
        int zooKeeperServerPort = 2181;
        @JsonProperty
        int zooKeeperServerConnectionPort = 2181;
        @JsonProperty
        int zooKeeperServerTickTime = 2000;
        @JsonProperty
        int zooKeeperServerInitLimit = 10;
        @JsonProperty
        int zooKeeperServerSyncLimit = 5;
        @JsonProperty
        String zooKeeperServerDataDir = "data/zookeeper";
        @JsonProperty
        String zookeeperPassword = Builder.generatePassword();
        @JsonProperty
        boolean ensembleStart = false;
        @JsonProperty
        boolean agentEnabled = true;
        @JsonProperty
        boolean waitForProvision = true;
        @JsonProperty
        long provisionTimeout = 120000L;
        @JsonProperty
        long migrationTimeout = 120000L;
        @JsonProperty
        boolean autoImportEnabled = true;
        @JsonProperty
        String importPath = DEFAULT_IMPORT_PATH;
        @JsonProperty
        Map<String, String> users = new HashMap<String, String>();
        @JsonProperty
        boolean clean;

        @Override
        public B fromRuntimeProperties(RuntimeProperties sysprops) {
            super.fromRuntimeProperties(sysprops);
            this.ensembleStart = Boolean.parseBoolean(sysprops.getProperty(CreateEnsembleOptions.ENSEMBLE_AUTOSTART, "false"));
            this.agentEnabled = Boolean.parseBoolean(sysprops.getProperty(CreateEnsembleOptions.AGENT_AUTOSTART, "false"));
            this.zookeeperPassword = sysprops.getProperty(CreateEnsembleOptions.ZOOKEEPER_PASSWORD, Builder.generatePassword());
            this.zooKeeperServerPort = Integer.parseInt(sysprops.getProperty(ZOOKEEPER_SERVER_PORT, "2181"));
            this.zooKeeperServerConnectionPort = Integer.parseInt(sysprops.getProperty(ZOOKEEPER_SERVER_CONNECTION_PORT, "2181"));
            this.importPath = sysprops.getProperty(CreateEnsembleOptions.PROFILES_AUTOIMPORT_PATH, DEFAULT_IMPORT_PATH);
            this.autoImportEnabled = Boolean.parseBoolean(sysprops.getProperty(CreateEnsembleOptions.PROFILES_AUTOIMPORT, "true"));
            return (B)this;
        }

        public B zooKeeperServerPort(int zooKeeperServerPort) {
            this.zooKeeperServerPort = zooKeeperServerPort;
            return (B)this;
        }

        public B zooKeeperServerPort(Integer zooKeeperServerPort) {
            this.zooKeeperServerPort = zooKeeperServerPort;
            return (B)this;
        }

        public B zooKeeperServerPort(Long zooKeeperServerPort) {
            this.zooKeeperServerConnectionPort = zooKeeperServerPort.intValue();
            return (B)this;
        }

        public B zooKeeperServerConnectionPort(int zooKeeperServerConnectionPort) {
            this.zooKeeperServerConnectionPort = zooKeeperServerConnectionPort;
            return (B)this;
        }

        public B zooKeeperServerConnectionPort(Integer zooKeeperServerConnectionPort) {
            this.zooKeeperServerConnectionPort = zooKeeperServerConnectionPort;
            return (B)this;
        }

        public B zooKeeperServerConnectionPort(Long zooKeeperServerConnectionPort) {
            this.zooKeeperServerConnectionPort = zooKeeperServerConnectionPort.intValue();
            return (B)this;
        }

        public B zooKeeperServerTickTime(int zooKeeperServerTickTime) {
            this.zooKeeperServerTickTime = zooKeeperServerTickTime;
            return (B)this;
        }

        public B zooKeeperServerInitLimit(int zooKeeperServerInitLimit) {
            this.zooKeeperServerInitLimit = zooKeeperServerInitLimit;
            return (B)this;
        }

        public B zooKeeperServerSyncLimit(int zooKeeperServerSyncLimit) {
            this.zooKeeperServerSyncLimit = zooKeeperServerSyncLimit;
            return (B)this;
        }

        public B zooKeeperServerDataDir(String zooKeeperServerDataDir) {
            this.zooKeeperServerDataDir = zooKeeperServerDataDir;
            return (B)this;
        }

        public B zookeeperPassword(String zookeeperPassword) {
            this.zookeeperPassword = zookeeperPassword;
            return (B)this;
        }

        public B users(Map<String, String> users) {
            this.users = users;
            return (B)this;
        }

        public B withUser(String user, String password, String role) {
            this.users.put(user, password + CreateEnsembleOptions.ROLE_DELIMITER + role);
            return (B)this;
        }

        public B ensembleStart(boolean ensembleStart) {
            this.ensembleStart = ensembleStart;
            return (B)this;
        }

        public B agentEnabled(boolean agentEnabled) {
            this.agentEnabled = agentEnabled;
            return (B)this;
        }

        public B agentEnabled(Boolean agentEnabled) {
            this.agentEnabled = agentEnabled;
            return (B)this;
        }

        public B autoImportEnabled(boolean autoImportEnabled) {
            this.autoImportEnabled = autoImportEnabled;
            return (B)this;
        }

        public B autoImportEnabled(Boolean autoImportEnabled) {
            this.autoImportEnabled = autoImportEnabled;
            return (B)this;
        }

        public B migrationTimeout(long migrationTimeout) {
            this.migrationTimeout = migrationTimeout;
            return (B)this;
        }

        public B provisionTimeout(long provisionTimeout) {
            this.provisionTimeout = provisionTimeout;
            return (B)this;
        }

        public B waitForProvision(boolean waitForProvision) {
            this.waitForProvision = waitForProvision;
            return (B)this;
        }

        public B importPath(String importPath) {
            this.importPath = importPath;
            return (B)this;
        }

        public B clean(boolean clean) {
            this.clean = clean;
            return (B)this;
        }

        public void setZooKeeperServerPort(int zooKeeperServerPort) {
            this.zooKeeperServerPort = zooKeeperServerPort;
        }

        public void setZookeeperPassword(String zookeeperPassword) {
            this.zookeeperPassword = zookeeperPassword;
        }

        public void setEnsembleStart(boolean ensembleStart) {
            this.ensembleStart = ensembleStart;
        }

        public void setAgentEnabled(boolean agentEnabled) {
            this.agentEnabled = agentEnabled;
        }

        public void setAutoImportEnabled(boolean autoImportEnabled) {
            this.autoImportEnabled = autoImportEnabled;
        }

        public void setImportPath(String importPath) {
            this.importPath = importPath;
        }

        public void setUsers(Map<String, String> users) {
            this.users = users;
        }

        public void setWaitForProvision(boolean waitForProvision) {
            this.waitForProvision = waitForProvision;
        }

        public void setProvisionTimeout(long provisionTimeout) {
            this.provisionTimeout = provisionTimeout;
        }

        public int getZooKeeperServerPort() {
            return this.zooKeeperServerPort;
        }

        public int getZooKeeperServerConnectionPort() {
            return this.zooKeeperServerConnectionPort;
        }

        public String getZookeeperPassword() {
            return this.zookeeperPassword;
        }

        public boolean isEnsembleStart() {
            return this.ensembleStart;
        }

        public boolean isAgentEnabled() {
            return this.agentEnabled;
        }

        public boolean isAutoImportEnabled() {
            return this.autoImportEnabled;
        }

        public String getImportPath() {
            return this.importPath;
        }

        public Map<String, String> getUsers() {
            return this.users;
        }

        public boolean isWaitForProvision() {
            return this.waitForProvision;
        }

        public long getProvisionTimeout() {
            return this.provisionTimeout;
        }

        public boolean isClean() {
            return this.clean;
        }

        private static String generatePassword() {
            StringBuilder password = new StringBuilder();
            for (int i = 0; i < 16; ++i) {
                long l = Math.round(Math.floor(Math.random() * 62.0));
                if (l < 10L) {
                    password.append((char)(48L + l));
                    continue;
                }
                if (l < 36L) {
                    password.append((char)(65L + l - 10L));
                    continue;
                }
                password.append((char)(97L + l - 36L));
            }
            return password.toString();
        }

        @Override
        public CreateEnsembleOptions build() {
            return new CreateEnsembleOptions(this.bindAddress, this.resolver, this.globalResolver, this.manualIp, this.minimumPort, this.maximumPort, this.profiles, this.version, this.dataStoreProperties, this.zooKeeperServerPort, this.zooKeeperServerConnectionPort, this.zooKeeperServerTickTime, this.zooKeeperServerInitLimit, this.zooKeeperServerSyncLimit, this.zooKeeperServerDataDir, this.zookeeperPassword, this.ensembleStart, this.agentEnabled, this.waitForProvision, this.provisionTimeout, this.migrationTimeout, this.autoImportEnabled, this.importPath, this.users, this.clean);
        }
    }
}

