/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api;

import io.fabric8.api.DynamicReferenceException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicReference<T>
implements Callable<T> {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicReference.class);
    private static final long DEFAULT_TIMEOUT = 5000L;
    private static final String DEFAULT_NAME = "dynamic reference";
    private static final String TIMEOUT_MESSAGE_FORMAT = "Gave up waiting for: %s";
    private static final String INTERRUPTED_MESSAGE_FORMAT = "Interrupted while waiting for: %s";
    private final AtomicReference<ValueRevision> revision = new AtomicReference();
    private final long timeout;
    private final TimeUnit unit;
    private final String name;

    public DynamicReference() {
        this(DEFAULT_NAME);
    }

    public DynamicReference(String name) {
        this(name, 5000L, TimeUnit.MILLISECONDS);
    }

    public DynamicReference(String name, long timeout, TimeUnit unit) {
        this.name = name;
        this.unit = unit;
        this.timeout = timeout;
        this.revision.set(new ValueRevision());
    }

    @Override
    public T call() throws Exception {
        return this.currentRevision().get(this.timeout, this.unit);
    }

    public T get() {
        Object value = this.currentRevision().get(this.timeout, this.unit);
        while (value == null) {
            LOG.warn("Unbound while waiting for: {}", (Object)this.name);
            value = this.currentRevision().get(this.timeout, this.unit);
        }
        return value;
    }

    public T getIfPresent() {
        return this.currentRevision().getIfPresent();
    }

    public void bind(T value) {
        this.currentRevision().bind(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(T value) {
        AtomicReference<ValueRevision> atomicReference = this.revision;
        synchronized (atomicReference) {
            ValueRevision currev = this.revision.get();
            currev.unbind(value);
            if (currev.getIfPresent() == null) {
                this.revision.set(new ValueRevision());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValueRevision currentRevision() {
        AtomicReference<ValueRevision> atomicReference = this.revision;
        synchronized (atomicReference) {
            return this.revision.get();
        }
    }

    class ValueRevision {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference<T> ref = new AtomicReference();

        ValueRevision() {
        }

        void bind(T value) {
            LOG.debug("bind: {}", value);
            this.ref.set(value);
            this.latch.countDown();
        }

        void unbind(T value) {
            LOG.debug("unbind: {}", value);
            if (value != null) {
                this.ref.compareAndSet(value, null);
            } else {
                this.ref.set(null);
            }
            this.latch.countDown();
        }

        T getIfPresent() {
            return this.ref.get();
        }

        T get(long timeout, TimeUnit unit) {
            try {
                if (!this.latch.await(timeout, unit)) {
                    throw new DynamicReferenceException(String.format(DynamicReference.TIMEOUT_MESSAGE_FORMAT, DynamicReference.this.name));
                }
            }
            catch (InterruptedException ex) {
                throw new DynamicReferenceException(String.format(DynamicReference.INTERRUPTED_MESSAGE_FORMAT, DynamicReference.this.name), ex);
            }
            Object value = this.ref.get();
            return value;
        }
    }
}

