/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.internal.locks;

import io.fabric8.api.jcip.GuardedBy;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.locks.LockService;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;

@ThreadSafe
@Component(name="io.fabric8.lock.service", label="Fabric8 Lock Service", metatype=false)
@Service(value={LockService.class})
public final class LockServiceImpl
extends AbstractComponent
implements LockService {
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @GuardedBy(value="locks")
    private final Map<String, InterProcessLock> locks = new HashMap<String, InterProcessLock>();

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InterProcessLock getLock(String path) {
        Map<String, InterProcessLock> map = this.locks;
        synchronized (map) {
            this.assertValid();
            if (this.locks.containsKey(path)) {
                return this.locks.get(path);
            }
            this.locks.put(path, (InterProcessLock)new InterProcessMutex((CuratorFramework)this.curator.get(), path));
            return this.locks.get(path);
        }
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }
}

