/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.Container;
import io.fabric8.api.ContainerAutoScaler;
import io.fabric8.api.Containers;
import io.fabric8.api.CreateChildContainerOptions;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.FabricService;
import io.fabric8.api.NameValidator;
import io.fabric8.service.ChildContainerProvider;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildAutoScaler
implements ContainerAutoScaler {
    private static final transient Logger LOG = LoggerFactory.getLogger(ChildAutoScaler.class);
    private final ChildContainerProvider containerProvider;

    public ChildAutoScaler(ChildContainerProvider containerProvider) {
        this.containerProvider = containerProvider;
    }

    public int getWeight() {
        return 0;
    }

    public void createContainers(String version, String profile, int count) throws Exception {
        CreateChildContainerOptions.Builder builder = null;
        FabricService fabricService = this.containerProvider.getFabricService();
        if (fabricService != null) {
            builder = this.createAuthoScaleOptions(fabricService);
        }
        if (builder != null) {
            Container[] containers = fabricService.getContainers();
            for (int i = 0; i < count; ++i) {
                CreateChildContainerOptions.Builder configuredBuilder = (CreateChildContainerOptions.Builder)((CreateChildContainerOptions.Builder)((CreateChildContainerOptions.Builder)builder.number(1)).version(version)).profiles(profile);
                NameValidator nameValidator = Containers.createNameValidator((Container[])containers);
                String name = Containers.createContainerName((Container[])containers, (String)profile, (String)this.containerProvider.getScheme(), (NameValidator)nameValidator);
                CreateChildContainerOptions options = ((CreateChildContainerOptions.Builder)configuredBuilder.name(name)).build();
                LOG.info("Creating container name " + name + " version " + version + " profile " + profile + " " + count + " container(s)");
                fabricService.createContainers((CreateContainerOptions)options);
            }
        } else {
            LOG.warn("Could not create version " + version + " profile " + profile + " due to missing autoscale configuration");
        }
    }

    protected CreateChildContainerOptions.Builder createAuthoScaleOptions(FabricService fabricService) {
        CreateChildContainerOptions.Builder builder = CreateChildContainerOptions.builder();
        Container[] containers = fabricService.getContainers();
        if (containers != null) {
            String parent = null;
            for (Container container : containers) {
                if (!container.isRoot()) continue;
                parent = container.getId();
                builder = (CreateChildContainerOptions.Builder)builder.parent(parent);
                break;
            }
        }
        String zookeeperUrl = fabricService.getZookeeperUrl();
        String zookeeperPassword = fabricService.getZookeeperPassword();
        return (CreateChildContainerOptions.Builder)((CreateChildContainerOptions.Builder)builder.jmxUser("admin").jmxPassword(zookeeperPassword).zookeeperUrl(zookeeperUrl)).zookeeperPassword(zookeeperPassword);
    }

    public void destroyContainers(String profile, int count, List<Container> containers) {
    }
}

