/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.api.scr.support.ConfigInjection;
import io.fabric8.utils.Strings;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;

@Component(immediate=true)
@Service(value={Configurer.class})
public class ComponentConfigurer
extends AbstractComponent
implements Configurer {
    private static final String ENV_VAR_PREFIX = "FABRIC8_";
    private static final String REPLACE_PATTERN = "-|\\.";
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{([a-zA-Z0-9\\.\\-]+)}");
    private static final String BOX_FORMAT = "\\$\\{%s\\}";
    @Reference(referenceInterface=RuntimeProperties.class, bind="bindRuntimeProperties", unbind="unbindRuntimeProperties")
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    public <T> void configure(Map<String, ?> configuration, T target) throws Exception {
        this.assertValid();
        RuntimeProperties properties = (RuntimeProperties)this.runtimeProperties.get();
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, ?> entry : configuration.entrySet()) {
            String substitutedValue;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value.getClass().isArray() || !(value instanceof String) || !Strings.isNotBlank(substitutedValue = ComponentConfigurer.substitute((String)value, properties))) continue;
            result.put(key, substitutedValue);
        }
        ConfigInjection.applyConfiguration(result, target);
    }

    static String substitute(String key, RuntimeProperties properties) {
        String result = new String(key);
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(key);
        while (matcher.find()) {
            String name = matcher.group(1);
            String toReplace = String.format(BOX_FORMAT, name);
            String replacement = properties.getProperty(name);
            replacement = Strings.isNotBlank(replacement) ? replacement : "";
            result = result.replaceAll(toReplace, replacement);
        }
        return result;
    }
}

