/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.FabricService;
import io.fabric8.api.MQService;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.utils.Strings;
import java.util.Map;

public class MQServiceImpl
implements MQService {
    private FabricService fabricService;

    public MQServiceImpl(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public Profile createOrUpdateMQProfile(String versionId, String profile, String brokerName, Map<String, String> configs, boolean replicated) {
        Version version = this.fabricService.getVersion(versionId);
        String parentProfileName = null;
        if (configs != null && configs.containsKey("parent")) {
            parentProfileName = configs.remove("parent");
        }
        if (Strings.isNullOrBlank(parentProfileName)) {
            parentProfileName = replicated ? "mq-replicated" : "mq-base";
        }
        Profile parentProfile = version.getProfile(parentProfileName);
        String pidName = this.getBrokerPID(brokerName);
        Profile result = parentProfile;
        if (brokerName != null && profile != null) {
            String[] propertiesToDefault;
            Map config = null;
            if (!version.hasProfile(profile)) {
                result = version.createProfile(profile);
                result.setParents(new Profile[]{parentProfile});
            } else {
                result = version.getProfile(profile);
                config = result.getConfiguration(pidName);
            }
            Map parentProfileConfig = parentProfile.getConfiguration("org.fusesource.mq.fabric.template");
            if (config == null) {
                config = parentProfileConfig;
            }
            config.put("broker-name", brokerName);
            if (configs != null) {
                config.putAll(configs);
            }
            for (String key : propertiesToDefault = new String[]{"config", "standby.pool", "connectors"}) {
                String defaultValue;
                if (config.get(key) != null || !Strings.isNotBlank(defaultValue = (String)parentProfileConfig.get(key))) continue;
                config.put(key, defaultValue);
            }
            result.setConfiguration(pidName, config);
        }
        return result;
    }

    public Profile createOrUpdateMQClientProfile(String versionId, String profile, String group, String parentProfileName) {
        Version version = this.fabricService.getVersion(versionId);
        Profile parentProfile = null;
        if (Strings.isNotBlank(parentProfileName)) {
            parentProfile = version.getProfile(parentProfileName);
        }
        Profile result = parentProfile;
        if (group != null && profile != null) {
            Map config = null;
            result = !version.hasProfile(profile) ? version.createProfile(profile) : version.getProfile(profile);
            if (parentProfile != null) {
                result.setParents(new Profile[]{parentProfile});
            }
            Map parentProfileConfig = result.getConfiguration("org.fusesource.mq.fabric.cf");
            if (config == null) {
                config = parentProfileConfig;
            }
            config.put("group", group);
            result.setConfiguration("org.fusesource.mq.fabric.cf", config);
        }
        return result;
    }

    public String getConfig(String version, String config) {
        return "profile:" + config;
    }

    protected String getBrokerPID(String brokerName) {
        return "org.fusesource.mq.fabric.server-" + brokerName;
    }
}

